<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Swarkul | About us</title>

    <!-- Styles -->
    <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldPushContent('css-inline'); ?>
</head>
<body class="bg-full-screen-image">
<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section id="page-header" class="page-about">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">About</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 200px;">
                About Us
            </div>
		</div>
    </section>
    <section id="content" style="min-height: 500px;">
        <div class="container">
            <p>
                About ICIMP (International Certification for Indian Music Practitioner)
            </p>
            <b>Objective:</b>
            <p style="text-indent: 3%;">
                To address a rising need for validating freelance/guided Indian music leaning across the world, Swarkul Academy USA has launched an initiative for having a comprehensive certification process to evaluate a music learner's skill level in Indian music. This certification will be regarded as an accurate assessment of the student's learning. The certification syllabus has been drafted by renowned veterans in Indian music field.
            </p>
            <p>ICIMP certification comprises a simplified 9 Grade system that allows a student to move onwards and upwards from one level to another.</p>
            <p>
                It is the first international certification that is conducted 100% virtually. No travel required, appear for your certification from the comfort of your home or anywhere.
            </p>
            <p>
                <b>Vision:</b> Educating. Guiding. Inspiring
            </p>
            <p>
                <b>Mission:</b> To have a structured and internationally accredited certification for an Indian music practitioner</p>
        </div>
    </section>
    <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
    <?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->yieldPushContent('script-function'); ?>
</html><?php /**PATH /home/shahul2020/swarkul/resources/views/site/landing/about.blade.php ENDPATH**/ ?>