<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldPushContent('css-inline'); ?>
</head>
<body class="bg-full-screen-image">
<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Edit</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Student Edit
            </div>
		</div>
    </section>
    <section id="content" class="container">
		<div class="row col-md-6">
			<?php echo Form::model($usersInfo,['url' => url('student/update'),'id'=>'studentEdit']); ?>

				<input type="hidden" name="id" value="<?php echo e(App\Http\Helper\Admin\Helpers::encodeAndDecodeID($usersInfo->id,'encode')); ?>" />
				<div class="form-group mb-50">
		<label class="text-bold-600">Full Name<span class="red-star">*</span></label>
		<?php echo Form::text('name',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'100']); ?>

	 </div>
	 <div class="form-group mb-50 ">
		<label class="text-bold-600" for="exampleInputEmail1">Email ID<span class="red-star">*</span></label>
		<?php echo Form::email('email',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'255']); ?>

	 </div>
	 <div class="row">
		
		<div class="form-group col-md-4 col-xs-6">
		   <label class="text-bold-600">Date of Birth<span class="red-star">*</span></label>
		   <div class="inner-addon left-addon">
			  <i class="icofont-calendar d-sm-block"></i>
			  <?php echo Form::text('dob',null,['class'=>'form-control  date-selection datepicker','autocomplete'=>'nope','placeholder'=>'DD-MM-YYYY','data-date-format'=>'dd-mm-yyyy']); ?>

		   </div>
		</div>

		<div class="form-group col-md-8 col-xs-6">
		   <label class="text-bold-600">Gender<span class="red-star">*</span></label>
		   <div class="row">
			  <div class="col-md-4">
				 <input type="radio" id="male" name="gender" checked value="male">
				 <label for="male">Male</label>
			  </div>
			  <div class="col-md-4">
				 <input type="radio" id="female" name="gender" value="female">
				 <label for="female">Female</label>
			  </div>
			  <div class="col-md-4">
				 <input type="radio" id="other" name="gender" value="other">
				 <label for="other">Other</label>
			  </div>
		   </div>
		</div>
		
		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600">Address 1<span class="red-star">*</span></label>
		   <?php echo Form::text('address_1',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'100']); ?>

		</div>
		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600">Address 2</label>
		   
		   <?php echo Form::text('address_2',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'100']); ?>

		</div>
		<div class="form-group col-md-6 col-12">
		   <label class="text-bold-600">City<span class="red-star">*</span></label>
		   <?php echo Form::text('city',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'45']); ?>

		</div>
		<div class="form-group col-md-6 col-12">
		   <label class="text-bold-600">State<span class="red-star">*</span></label>
		    <?php echo Form::text('state',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'45']); ?>

		</div>
		<div class="form-group col-md-6 col-12">
		   <label class="text-bold-600">Zip code<span class="red-star">*</span></label>
		    <?php echo Form::text('zipcode',null,['class'=>'form-control js-number','autocomplete'=>'nope','maxlength'=>'11']); ?>

		</div>
		<div class="form-group col-md-6 col-12">
		   <label class="text-bold-600">Country<span class="red-star">*</span></label>
		     <?php echo Form::select('country', array(''=>'Select')+$country,null,['class'=>'form-control','id'=>'country']); ?>

		</div>
		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600" for="exampleInputPassword1">Phone<span class="red-star">*</span></label>
		   <div class="row">
			  <div class="col-md-1">
				 <i class='bx bx-plus' style="font-size: 1.20em; padding: 8px;"></i>
			  </div>
			  <div class="col-md-2">
				  <?php echo Form::text('code',null,['class'=>'form-control js-number','autocomplete'=>'nope','maxlength'=>'3','style'=>'width:60px']); ?>

			  </div>
			  <div class="col-md-4">
				 <?php echo Form::text('phone',null,['class'=>'form-control js-number','autocomplete'=>'nope','maxlength'=>'10']); ?>

			  </div>
		   </div>
		</div>

		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600" for="music_academy">Music Academy</label>
		   <?php echo Form::text('music_academy',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'100']); ?>

		</div>
		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600" for="teacher_name">Teacher Name</label>
		   <?php echo Form::text('teacher_name',null,['class'=>'form-control','autocomplete'=>'nope','maxlength'=>'100']); ?>

		</div>
		<?php if(\Auth::user()->role_type == 'Examiner'): ?>
		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600" for="teacher_name"> Zoom Client Id </small></label>
		   <?php echo Form::text('client_id',null,['class'=>'form-control','autocomplete'=>'nope']); ?>

		</div>
		<div class="form-group col-md-12 col-12">
		   <label class="text-bold-600" for="teacher_name"> Zoom Secret Id </small></label>
		   <?php echo Form::text('secret_id',null,['class'=>'form-control','autocomplete'=>'nope']); ?>

		</div>
		<?php endif; ?>
	 </div>
	 
	 <div class="col-12 d-flex justify-content-end">
			<button type="submit" class="btn btn-primary mr-1 mb-1">Submit</button>
			<button type="reset" class="btn btn-light-secondary mr-1 mb-1">Reset</button>
		  </div>
			<?php echo Form::close(); ?>

		</div>
		
		
    </section>
    <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
    <?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->yieldPushContent('script-function'); ?>

</html><?php /**PATH /home/shahul2020/swarkul/resources/views/site/student/studentEdit.blade.php ENDPATH**/ ?>