<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldPushContent('css-inline'); ?>
</head>
<body class="bg-full-screen-image">
<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page"> My Certification</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                My Certification
            </div>
		</div>
    </section>
    <section id="content" class="container">
		<div class="row mb-5">
		<div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="50">
				<h4><?php echo e(ucfirst(Auth::user()->name)); ?></h4>
				<h5><?php echo e(Auth::user()->email); ?></h5>
				<h5><?php echo e(Auth::user()->phone); ?></h5>
				<SMALL>DATE OF BIRTH</SMALL><br>
				<h5><?php echo e(Auth::user()->dob); ?></h5>
				<SMALL>ADDRESS</SMALL><br>
				<b><?php echo e(ucfirst(Auth::user()->address_1)); ?>,</b><br>
				<b><?php echo e(ucfirst(Auth::user()->address_2)); ?></b><br>
				<b><?php echo e(ucfirst(Auth::user()->city)); ?> <?php echo e(ucfirst(Auth::user()->zipcode)); ?></b><br>
				<b><?php echo e(ucfirst(Auth::user()->state)); ?>, <?php echo e(ucfirst(Auth::user()->country)); ?></b><br>
				<a href="<?php echo e(url('/student-edit')); ?>" class="btn btn-success mt-2">Edit Bio</a>
				<a href="<?php echo e(url('/change-password')); ?>" class="btn btn-success mt-2">Change Password</a>
			</div>
			<div class="col-md-8 js-dynamic-list">
				<table class="swarkul-table mt-3">
					<thead>
						<tr>							
							<th scope="col">Genre</th>
							<th scope="col">Level</th>
							<th scope="col">Date</th>
							<th scope="col">Time Slot</th>
							<th scope="col">Status</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
						<?php if(count($examinerSchedulerinfo) == 0): ?>
						<tr>
							<td colspan="7">
								<div class="card p-3 w-100 text-center"><b>No certification found</b></div>
							</td>
						</tr>
						<?php else: ?>
						<?php $__currentLoopData = $examinerSchedulerinfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							
							<td><?php echo e(@$list->exam_master->genre); ?></td>
							<td><?php echo e(@$list->exam_master->exam_level); ?></td>
							<td><?php echo e(date('d M, Y',strtotime($list->slot->slot_date))); ?></td>
							<td><?php echo e($list->slot->slot_time_start); ?> to <?php echo e($list->slot->slot_time_end); ?></td>
							<td><?php if($list->status == 'Complete'): ?>
								<div class="swarkul-status complete">Completed</div>
								<?php elseif($list->status == 'Pending'): ?>
								<div class="swarkul-status pending">Scheduled</div>
								<?php else: ?>
								<div class="swarkul-status inprogress">In-progress</div>
								<?php endif; ?>
							</td>
							<?php if($list->status == 'Complete'): ?>
							<td><a class="btn btn-success" href="<?php echo e(url('exam/view/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode'))); ?>">Evaluation Detail</a> | <a class="btn btn-success" href="<?php echo e(url('getCertification/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode'))); ?>">My Certificate</a></td>
							<?php else: ?>
								<td>-</td>
							<?php endif; ?>
							
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>

					</tbody>
				</table>
			</div>
		</div>
		
		
    </section>
    <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
    <?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->yieldPushContent('script-function'); ?>
	<script>
	
	$(document).on('click', '.js-prev-month', function() {
		var type = -1;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	$(document).on('click', '.js-next-month', function() {
		var type = 0;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	function loadListing(monthDate, type) {
		var url = appUrl + "/my-certification-ajax";
		var token = $('meta[name=csrf-token]').attr("content");
		$.ajax({
			url: url,
			method: "post",
			data: {
				'date': monthDate,
				'type': type,
				'_token': token
			},
			success: function(result) {
				$('.js-dynamic-list').html(result);
			}
		})
	}
</script>
</html><?php /**PATH C:\xampp\htdocs\swarkul\resources\views/site/student/my-certification.blade.php ENDPATH**/ ?>