<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>Swarkul | Admin Dashboard</title>

  <!-- Styles -->
  <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->yieldPushContent('css'); ?>
  <?php echo $__env->yieldPushContent('css-inline'); ?>
  <style>
    .card {
      box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
      transition: 0.3s;
      width: 40%;
      border-radius: 5px;
    }

    .card:hover {
      box-shadow: 0 8px 16px 0 rgba(0, 0, 0, 0.2);
    }

    img {
      border-radius: 5px 5px 0 0;
    }

    .container {
      padding: 2px 16px;
    }

    .dot {
      height: 250px;
      width: 250px;
      background-color: #bbb;
      border-radius: 50%;
      display: inline-block;
    }
  </style>
</head>

<body class="bg-full-screen-image">
  <?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <section id="page-header" class="page-examiner-dashboard">
    <div class="container-swarkul">
      <nav aria-label="breadcrumb" class="d-none d-sm-block">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="/">Home</a></li>
          <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
        </ol>
      </nav>
      <div class="page-title" style="max-width: 420px;">
        Admin Dashboard
      </div>
    </div>
  </section>
  <section id="team" class="team">
    <div class="container">
      <div class="row">
        <div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="100">
          <h4><?php echo e(ucfirst(Auth::user()->name)); ?></h4>
          <h5><?php echo e(Auth::user()->email); ?></h5>
          <h5><?php echo e(Auth::user()->phone); ?></h5>
          <SMALL>DATE OF BIRTH</SMALL><br>
          <h5><?php echo e(Auth::user()->dob); ?></h5>
          <SMALL>ADDRESS</SMALL><br>
          <b><?php echo e(ucfirst(Auth::user()->address_1)); ?>,</b><br>
          <b><?php echo e(ucfirst(Auth::user()->address_2)); ?></b><br>
          <b><?php echo e(ucfirst(Auth::user()->city)); ?> <?php echo e(ucfirst(Auth::user()->zipcode)); ?></b><br>
          <b><?php echo e(ucfirst(Auth::user()->state)); ?>, <?php echo e(ucfirst(Auth::user()->country)); ?></b><br>
          <a href="<?php echo e(url('/student-edit')); ?>" class="btn btn-success mt-2">Edit Bio</a>
          <a href="<?php echo e(url('/change-password')); ?>" class="btn btn-success mt-2">Change Password</a>

        </div>
        <div class="col-xl-3 col-lg-4 col-md-3" data-aos="fade-up" data-aos-delay="100">
          <div class="member">
            <div class="pic"><img src="../../../images/site/examiner-schedule.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">

              <h4>Teacher Management</h4>
              <div class="social">
                <a href="<?php echo e(url('/admin/teacher-management')); ?>" class="btn btn-success">View</a>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>

  <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
<?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->yieldPushContent('script-function'); ?>

</html><?php /**PATH C:\xampp\htdocs\swarkul\resources\views/site/admin/dashboard.blade.php ENDPATH**/ ?>