<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<title>Swarkul | Dashboard</title>

	<!-- Styles -->
	<?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->yieldPushContent('css'); ?>
	<?php echo $__env->yieldPushContent('css-inline'); ?>
</head>

<body class="bg-full-screen-image">
	<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<section id="page-header" class="page-contact">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page"> My Certification</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				My Certification
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<div class="row mb-5">
			<div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="50">
				<h4><?php echo e(ucfirst(Auth::user()->name)); ?></h4>
				<h5><?php echo e(Auth::user()->email); ?></h5>
				<h5><?php echo e(Auth::user()->phone); ?></h5>
				<SMALL>DATE OF BIRTH</SMALL><br>
				<h5><?php echo e(Auth::user()->dob); ?></h5>
				<SMALL>ADDRESS</SMALL><br>
				<b><?php echo e(ucfirst(Auth::user()->address_1)); ?>,</b><br>
				<b><?php echo e(ucfirst(Auth::user()->address_2)); ?></b><br>
				<b><?php echo e(ucfirst(Auth::user()->city)); ?> <?php echo e(ucfirst(Auth::user()->zipcode)); ?></b><br>
				<b><?php echo e(ucfirst(Auth::user()->state)); ?>, <?php echo e(ucfirst(Auth::user()->country)); ?></b><br>
				<a href="<?php echo e(url('/student-edit')); ?>" class="btn btn-success mt-2">Edit Bio</a>
				<a href="<?php echo e(url('/change-password')); ?>" class="btn btn-success mt-2">Change Password</a>
			</div>
			<div class="col-md-8 js-dynamic-list">
				<small>Booking a slot will take you to the payment gateway and you will have 10 mins to complete your payment.</small>
				<table class="swarkul-table mt-3">
					<thead>
						<tr>
							<th scope="col">Genre & Level</th>
							<th scope="col">Date</th>
							<th scope="col">Time Slot</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
					    <?php if(isset($listingInfo) && $masterId->id > 0): ?>
						<?php $__currentLoopData = $listingInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td><?php echo e($masterId['genre']); ?> - <?php echo e($masterId['exam_level']); ?></td>
							<td><?php echo e(date('M d, Y (l)', strtotime($list->slot['slot_date']))); ?></td>
							<td><?php echo e($list->slot['slot_time_start']); ?> - <?php echo e($list->slot['slot_time_end']); ?></td>
							<td class="booknow <?php echo e($list['id']); ?>" data-id="<?php echo e($list['id']); ?>" data-slot="<?php echo e($list->id .'/'.$popup['academy'].'/'.$popup['level'].'/'.$list['slot_id'].'/'.$masterId->id); ?>"><a id="bookingSlot" class="btn btn-success" style="background-color: green; border: 1px solid green;">Book This Slot</a></td>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>
					</tbody>
				</table>
			</div>
		</div>


	</section>
	<?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
<?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->yieldPushContent('script-function'); ?>
<script>
$(function(){
	//getData();
// 	setInterval(function(){
// 		getData();
// 	},10000);
$('.booknow').click(function(e){
    e.preventDefault();
	var ids = $(this).data('id');
	
	    var url = appUrl + "/slot_booking_status/"+ids;
			$.ajax({
			url: url,
			method: "GET",
			success: function(result){
			    console.log(result);
				if(result.status == false){
						$(".toast-error").hide();
    					js_notification('error','Slot has been  Already taken.  Please try again Later');
    					$('.'+ids).find('a').css('background-color','red');
    					$('.'+ids).find('a').css('border','0');
					}else{
    					$('.'+ids).find('a').removeClass('btn-danger');
						$('.'+ids).find('a').addClass('btn-success');
    					window.location.href = '/paymentconfirm/' + $('.'+ids).data('slot');
				
				}
			}
		})
});
	
		
	
})
</script>

<!--<script type="application/javascript" src="http://jsonip.appspot.com/?callback=getip"></script> -->
</script>
</html><?php /**PATH C:\xampp\htdocs\swarkul\resources\views/site/landing/my-apply.blade.php ENDPATH**/ ?>