<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldPushContent('css-inline'); ?>
</head>
<body class="bg-full-screen-image">
<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Dashboard</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Teacher Management
            </div>
		</div>
    </section>
    <section id="content" class="container">
	<a href="<?php echo e(url('teacher-registration')); ?>" class="btn btn-primary" style="float:right;">Add Teacher</a><br>
		<div class="row">
			<table class="swarkul-table mt-3" id="teacherTable">
					<thead>
						<tr>
							<th scope="col">Code</th>
							<th scope="col">Name</th>
							<th scope="col">email</th>
							<th scope="col">Music Academy</th>
							<th scope="col">Music Stream</th>
							<th scope="col">Is Academy</th>
							<th scope="col">Status</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
						<?php if(count($teacherInfo) == 0): ?>
						<tr>
							<td colspan="7">
								<div class="card p-3 w-100 text-center"><b>No slot scheduled for evaluation</b></div>
							</td>
						</tr>
						<?php else: ?>
						<?php $__currentLoopData = $teacherInfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							
							<td><?php echo e($list->unique_code); ?></td>
							<td><?php echo e($list->academy_name); ?></td>
							<td><?php echo e($list->email); ?></td>
							<td><?php echo e($list->music_academy); ?></td>
							<td><?php echo e($list->music_stream); ?></td>
							<td><?php echo e(($list->is_academy == 1) ? "Yes" : "No"); ?></td>
							<td><?php echo e($list->status); ?></td>
							<td><a href="<?php echo e(url('admin/teacher',$list->id)); ?>">Edit</a> | <a href="<?php echo e(url('admin/changeStatus/'.$list->id)); ?>"><?php echo e(($list->status == 'Active') ? "Deactivate" : "Activate"); ?> </a></td>
							
							
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>

					</tbody>
				</table>
		</div>
		
		
    </section>
    <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
    <?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->yieldPushContent('script-function'); ?>
	<script>
	$(document).ready( function () {
		$('#teacherTable').DataTable({
			dom: 'Bfrtip',
			buttons: [
				'excelHtml5',
				'csvHtml5',
				'pdfHtml5'
			]
		});
	} );
	</script>
</html><?php /**PATH D:\test\resources\views/site/admin/teachermanagement.blade.php ENDPATH**/ ?>