<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<title>Swarkul | Login</title>

	<!-- Styles -->
	<?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->yieldPushContent('css'); ?>
	<?php echo $__env->yieldPushContent('css-inline'); ?>
</head>

<body class="bg-full-screen-image">
	<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<section id="page-header" class="page-swarkul-login">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Login</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 380px;">
                Login to Swarkul
            </div>
		</div>
    </section>
	<div class="container">
		<div class="content-wrapper">
			<div class="content-body">
				<section id="auth-login" class="row flexbox-container">
					<div class="col-xl-12 col-12">
						<div class="mb-0">
							<div class="row m-0">
								<!-- left section-login -->
								<div class="col-md-6 col-12 px-0">
									<div class="card d-flex justify-content-center">

										<div class="card-content">
											<div class="card-body">
											<?php if($message = Session::get('error')): ?>
												<div class="col-xl-8 col-8 login-error pt-2">
													<div class="row">
														<span class="col-xl-11 login-error-msg"><?php echo e($message); ?></span><span class="col-xl-1 login-error-msg login-error-msg-hide">X</span>
													</div>
												</div>
											<?php endif; ?>
												<form method="POST" action="<?php echo e(url('admin/login')); ?>">
													<?php echo csrf_field(); ?>
													<div class="form-group mb-50 mt-2">
														<label class="text-bold-600" for="exampleInputEmail1">Email address</label>
														<input type="email" name="email" class="form-control" id="exampleInputEmail1"></div>
													<div class="form-group">
														<label class="text-bold-600" for="exampleInputPassword1">Password</label>
														<input type="password" name="password" class="form-control" id="exampleInputPassword1">
													</div>

													<button type="submit" class="btn btn-primary glow w-100 position-relative">Login<i id="icon-arrow" class="bx bx-right-arrow-alt"></i></button>
													<div class="row mt-2">
													<div class="text-left col-md-6"><a href="<?php echo e(url('student-registration')); ?>" class="card-link">Register new account</a></div>
													<div class="text-right col-md-6"><a href="<?php echo e(url('forgot')); ?>" class="card-link">Forgot Password?</a></div>
</div>
												</form>
											</div>
										</div>
									</div>
								</div>
								<!-- right section image -->
								<div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
									<div class="card-content">
										<img class="img-fluid" src="<?php echo e(asset('images/admin/images/pages/login.jpg')); ?>" alt="branding logo">
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
			</div>
		</div>
	</div>
	<?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
<?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->yieldPushContent('script-function'); ?>
<script>
$(document).on('click','.login-error-msg-hide',function(){
	$('.login-error').hide(900);
});
</script>
</html><?php /**PATH /home/shahul2020/swarkul/resources/views/site/landing/login.blade.php ENDPATH**/ ?>