<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

Route::get('/', 'Site\LandingController@index');
Route::get('why-certification', 'Site\LandingController@whyCertification');
Route::get('how-to-apply', 'Site\LandingController@howToApply');
Route::get('syllabus', 'Site\LandingController@syllabus');
Route::get('benefits', 'Site\LandingController@benefits');
Route::get('about-us', 'Site\LandingController@about');
Route::get('eligibility', 'Site\LandingController@eligibility');
Route::get('fees', 'Site\LandingController@fees');
Route::get('schedule', 'Site\LandingController@schedule');
Route::get('advisory-committee', 'Site\LandingController@advisory');
Route::get('apply', 'Site\LandingController@apply');
Route::get('enquiry', 'Site\LandingController@enquiry');
Route::get('contact', 'Site\LandingController@contact');

Route::group(array('middleware' => 'auth'), function() {
	Route::get('dashboard', 'Site\LandingController@dashboard');
	Route::get('student-edit', 'Site\LandingController@studentEdit');
	Route::post('student/update', 'Site\LandingController@studentUpdate');
	Route::post('student/changePassword', 'Site\LandingController@studentchangePassword');
	Route::get('my-certification', 'Site\LandingController@myCertification');
	Route::post('my-certification-ajax', 'Site\LandingController@myCertificationListing');
	Route::get('change-password', 'Site\LandingController@changePassword');
	Route::post('apply-certification', 'Site\LandingController@applyCertification');
	Route::post('getLevel', 'Site\LandingController@getLevel');
	Route::post('getLevelPrice', 'Site\LandingController@getLevelPrice');
	Route::get('apply-exam', 'Site\LandingController@apply_Exam');
	Route::post('apply-exam', 'Site\LandingController@applyExam');
	Route::get('paymentconfirm/{id}/{academy}/{level?}/{slot}/{master}', 'Site\LandingController@paymentconfirm');
	Route::get('payment/{id}/{academy}/{master}/success', 'Site\LandingController@paymentsuccess');
	Route::get('payment/{id}/fail', 'Site\LandingController@paymentfail');
	Route::get('getCertification/{id}', 'Site\LandingController@getCertification');
	
	Route::get('/slot_booking_status/{id}','Site\LandingController@SlotBookingStatus');
	Route::get('change-status/{id}','Site\LandingController@changeStatus');
	Route::get('/studentcapability/{level}/{genre}','Site\LandingController@studentcapability');
	Route::get('/zoom-create','Site\ExaminerController@zoomCreate');
	Route::get('/zoom-metting','Site\ExaminerController@zoomMetting');
	Route::get('/zoom-delete','Site\ExaminerController@deleteMetting');

	Route::get('examiner-landing', 'Site\ExaminerController@index');
	Route::get('examiner-scheduler', 'Site\ExaminerController@examiner_scheduler');
	Route::post('schedulerStore', 'Site\ExaminerController@schedulerStore');
	Route::post('schedulerCancel', 'Site\ExaminerController@schedulerCancel');
	Route::post('getExamEvaluationListing', 'Site\ExaminerController@getExamEvaluationListing');
	Route::post('getExamListing', 'Site\LandingController@getExamListing');
	Route::get('examiner-evaluation', 'Site\ExaminerController@examiner_evaluation');
	Route::get('examiner-evaluation/view/{id?}', 'Site\ExaminerController@examiner_evaluation2_view');
	Route::get('exam/view/{id?}', 'Site\LandingController@exam_view');
	Route::get('examiner-evaluation/{id?}', 'Site\ExaminerController@examiner_evaluation2');
	Route::post('evaluationStore', 'Site\ExaminerController@evaluationStore');
	Route::get('teacher-dashboard', 'Site\TeacherController@index');
	
	Route::group(array('prefix' => 'admin'), function() {
        Route::get('dashboard', 'Site\Admin\DashboardController@index');
        Route::get('teacher-management', 'Site\Admin\DashboardController@teacherMgmt');
        Route::get('changeStatus/{id}', 'Site\Admin\DashboardController@changeStatus');
		Route::get('teacher/{id}', 'Site\Admin\DashboardController@edit');
		Route::post('update', 'Site\Admin\DashboardController@update');
    });	
});

/* Admin route */
Route::get('login', [ 'as' => 'login', 'uses' => 'Auth\LoginController@getLogin']);
//Route::get('admin/login', 'Auth\LoginController@getLogin');
Route::post('admin/login', 'Auth\LoginController@postLogin');
Route::get('admin/logout', 'Auth\LoginController@logout');
Route::get('logout', 'Auth\LoginController@logout');
Route::get('forgot', 'Auth\LoginController@forgot');
Route::post('forgot', 'Auth\LoginController@setForgot');

Route::get('student-registration', 'Auth\RegisterController@getRegister');
Route::get('teacher-registration', 'Auth\RegisterController@getTeacherRegister');
Route::post('teacher-registration', 'Auth\RegisterController@storeTeacher');
Route::post('student-registration', 'Auth\RegisterController@storeStudent');
Route::post('userEmailValidate', 'Admin\SubAdmin\SubAdminController@userEmailValidate');
Route::post('userEmailCheck', 'Admin\SubAdmin\SubAdminController@userEmailCheck');

Route::group(array('prefix' => 'admin','middleware' => 'auth'), function() {
    
    Route::group(array('prefix' => 'dashboard'), function() {
        Route::get('dashboard', 'Admin\Dashboard\DashboardController@index');
    });
	
	Route::group(array('prefix' => 'manage-admin'), function() {
        
		Route::get('admin-user', 'Admin\SubAdmin\SubAdminController@index');
        Route::get('admin-user/create', 'Admin\SubAdmin\SubAdminController@create');
        Route::post('admin-user/add', 'Admin\SubAdmin\SubAdminController@store');
        Route::get('admin-user/{id}/edit', 'Admin\SubAdmin\SubAdminController@edit');
		Route::post('admin-user/update', 'Admin\SubAdmin\SubAdminController@update');
		
        Route::get('admin-roles/', 'Admin\SubAdmin\PermissionController@index');
        Route::get('admin-roles/create', 'Admin\SubAdmin\PermissionController@create');
        Route::post('admin-roles/add', 'Admin\SubAdmin\PermissionController@store');
        Route::get('admin-roles/{id}/edit', 'Admin\SubAdmin\PermissionController@edit');
        Route::post('admin-roles/update', 'Admin\SubAdmin\PermissionController@update');
    });
});