<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>How to Apply for Certification</title>

    <!-- Styles -->
    @include('site.layouts.CommonCSS')
    @stack('css')
    @stack('css-inline')
</head>
<body>
@include('site.layouts.header')
    <section id="page-header" class="page-apply">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">How to Apply?</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 300px;">
                How to apply?
            </div>
		</div>
    </section>
    <section id="content" style="min-height: 500px;">
    <div class="container">
       <p>Ready to start the ICIMP certification journey?</p>
       <b>Follow these simple steps if you are a teacher or a music school:</b>
       <p>"Register" with ICIMP and receive your unique registration id through email. Registration is free!. <br>Coach your student(s) based on the syllabus for the appropriate grade level and genre, available in the website.<br>Make your student(s) schedule an exam using your unique registration id and appear for it.<br>Exams for each grade level and genre are conducted once every month.<br>Theory and practical exams are conducted on the same day.<br>Student performance is evaluated by industry experts and graded accordingly.</p>
       <b>Follow these simple steps if you are a student(with a teacher or part of a music school):</b>
       <p>"Register" with ICIMP as a student using your teacher's or music school's unique registration id. Registration is free!.<br>Coach yourself based on the syllabus for the appropriate grade level and genre, available in the website.<br>Schedule an exam after paying the exam fees and appear for it.<br>Exams for each grade level and genre are conducted once every <br>Theory and practical exams are conducted on the same day.<br>Exam performance is evaluated by industry experts and graded accordingly.</p>
       <b>Follow these simple steps if you are a student(without a teacher or not part of a music school):</b>
       <p>"Register" with ICIMP using the student registration option. Registration is free!. <br>Coach yourself based on the syllabus for the appropriate grade level and genre, available in the website.<br>Schedule an exam after paying the exam fees and appear for it. <br>Exams for each grade level and genre are conducted once every month. <br>Theory and practical exams are conducted on the same day. performance is evaluated by industry experts and graded accordingly.</p>
       
    </div>
    </section>
    @include('site.layouts.footer')
</body>
    @include('site.layouts.CommonJS')
	@include('site.layouts.flashMessage')
    @stack('script')
    @stack('script-function')
</html>