<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>Swarkul | Advisory Committee</title>

  <!-- Styles -->
  @include('site.layouts.CommonCSS')
  @stack('css')
  @stack('css-inline')
  <style>
    .card {
      box-shadow: 0 4px 8px 0 rgba(0, 0, 0, 0.2);
      transition: 0.3s;
      width: 40%;
      border-radius: 5px;
    }

    .card:hover {
      box-shadow: 0 8px 16px 0 rgba(0, 0, 0, 0.2);
    }

    img {
      border-radius: 5px 5px 0 0;
    }

    .container {
      padding: 2px 16px;
    }

    .dot {
      height: 250px;
      width: 250px;
      background-color: #bbb;
      border-radius: 50%;
      display: inline-block;
    }
  </style>
</head>

<body class="bg-full-screen-image">
  @include('site.layouts.header')
  <section id="page-header" class="page-examiner-dashboard">
    <div class="container-swarkul">
      <nav aria-label="breadcrumb" class="d-none d-sm-block">
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="/">Home</a></li>
          <li class="breadcrumb-item active" aria-current="page">Dashboard</li>
        </ol>
      </nav>
      <div class="page-title" style="max-width: 420px;">
        Examiner Dashboard
      </div>
    </div>
  </section>
  <section id="team" class="team">
    <div class="container">
      <div class="row">
        <div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="100">
          <h4>{{ ucfirst(Auth::user()->name) }}</h4>
          <h5>{{ Auth::user()->email }}</h5>
          <h5>{{ Auth::user()->phone }}</h5>
          <SMALL>DATE OF BIRTH</SMALL><br>
          <h5>{{ Auth::user()->dob }}</h5>
          <SMALL>ADDRESS</SMALL><br>
          <b>{{ ucfirst(Auth::user()->address_1) }},</b><br>
          <b>{{ ucfirst(Auth::user()->address_2) }}</b><br>
          <b>{{ ucfirst(Auth::user()->city)  }} {{ ucfirst(Auth::user()->zipcode)  }}</b><br>
          <b>{{ ucfirst(Auth::user()->state)  }}, {{ ucfirst(Auth::user()->country)  }}</b><br>
          <a href="{{ url('/student-edit') }}" class="btn btn-success mt-2">Edit Bio</a>
          <a href="{{ url('/change-password') }}" class="btn btn-success mt-2">Change Password</a>

        </div>
        <div class="col-xl-3 col-lg-4 col-md-3" data-aos="fade-up" data-aos-delay="100">
          <div class="member">
            <div class="pic"><img src="../../../images/site/examiner-schedule.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
              <h1 style="font-size: 50px; color: #fff;">{{ $slotCount }}</h1>
              <h4>Open Exams</h4>
              <div class="social">
                <a href="{{ url('/examiner-scheduler') }}" class="btn btn-success">Schedule</a>
              </div>
            </div>
          </div>
        </div>

        <div class="col-xl-3 col-lg-4 col-md-3" data-aos="fade-up" data-aos-delay="200">
          <div class="member">
            <div class="pic"><img src="../../../images/site/evaluation.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
              <h1 style="font-size: 50px; color: #fff;">{{ $schedulerCount }}</h1>
              <h4>Exams to evaluate</h4>
              <div class="social">
                <a href="{{ url('/examiner-evaluation') }}" class="btn btn-success">Evaluate</a>
              </div>
            </div>
          </div>
        </div>

      </div>

    </div>
  </section>

  @include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')

</html>