<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Swarkul | Advisory Committee</title>

	<!-- Styles -->
	@include('site.layouts.CommonCSS')
	@stack('css')
	@stack('css-inline')
</head>

<body class="bg-full-screen-image">
	@include('site.layouts.header')
	<section id="page-header" class="page-evaluate-1">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item"><a href="/examiner-evaluation/">Evaluation</a></li>
					<li class="breadcrumb-item active" aria-current="page">@if(isset($examinerScheduler->student)){{ $examinerScheduler->student->name }} @else John Doe @endif</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				Evaluation
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<div class="col-md-12">
		<div class="row">
				<div class="col-md-12">
					<div class="row">
						<div class="col-md-12">
							<h3>Student Information</h3>
						</div>
					</div>
					@if(isset($examinerScheduler->student))
					<div class="row p-5">
						<div class="col-md-4">
							<h6>Name</h6>
							<h4> {{ $examinerScheduler->student->name }}</h4>
						</div>
						<div class="col-md-4">
							<h6>Gender</h6>
							@if($examinerScheduler->student->gender == 'female')
							<i style="padding-right: 10px; font-size: 18px;" class="bx bx-female"></i> Female
							@else
							<i style="padding-right: 10px; font-size: 18px;" class="bx bx-male"></i> Male
							@endif
						</div>
						<div class="col-md-4">
							<h6>DOB</h6>
							<b>Born on {{ date('d , F Y',strtotime($examinerScheduler->student->dob)) }}</b>
						</div>

					</div>
				</div>
				@else
				<div class="row">
					<div class="col-md-12 p-5 mb-2">
						<h4>No student information found</h4>
					</div>
				</div>
				@endif
			</div>
			<div class="row">
				<div class="col-md-12">
					<div class="row">
						<div class="col-md-8">
							<h3>{{ @$examinerScheduler->exam_master->genre }} Evaluation</h3>
						</div>
						<div class="col-md-4">

						</div>
					</div>
					<div class="row">
						<div class="col-md-12">
							<table class="swarkul-table">
								<tr>
									<th>Category</th>
									<th>Total Marks</th>
									<th>Marks Given</th>
									<th>Notes</th>
								</tr>
								
								<?php $category = App\Http\Helper\Admin\Helpers::getEvaluationCategoryView($examinerScheduler->exam_master_id,0,0,$examinerScheduler->id); ?>
								@foreach($category as $list)
									{!! $list !!}
								@endforeach
							</table>
						</div>
					</div>
					<div class="row">
						<div class="col-md-12">

							<b>Total Grade*</b><br>
							<input type="number" name="mark" value="{{ @$examinerScheduler->examEvaluationGrade->grade}}" class="form-control js-grade" id="mark" maxlength="3" style="width: 100px;">
							<span id="err_grade" style="color:red;display:none">Enter grade</span>
							<br>
							<br>
							<b>Final Comment*</b>

							<textarea type="textarea"  name="note" class="form-control js-final-note" id="note">{{ @$examinerScheduler->examEvaluationGrade->final_comment }}</textarea>
							<span id="err_note" style="color:red;display:none">Enter final comment</span>
						</div>
					</div>
					
				</div>
			</div>
		</div>
	</section>
	@include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')
<script>
$('input').attr('readonly', true);
$('textarea').attr('readonly', true);

$(document).on('change','.js-child',function(){
	var parentId = $(this).attr('data-parent');
	var totalMark = 0;
	$(".js-child[data-parent='"+parentId+"']").each(function(){
		if($(this).val() != '')
			totalMark = parseInt(totalMark) + parseInt($(this).val());
	});
	$('.js-parent[data-child="'+parentId+'"]').val(totalMark).change();
});

$(document).on('change','.js-parent',function(){
	var parentId = $(this).attr('data-parent');
	var totalParentMark = 0;
	$(".js-parent[data-parent='"+parentId+"']").each(function(){
		if($(this).val() != '')
			totalParentMark = parseInt(totalParentMark) + parseInt($(this).val());
	});
	$('.js-parent[data-child="'+parentId+'"]').val(totalParentMark);
	
});

$(document).on('click','.js-save',function(){
	var data = {};
	$(".js-mark").each(function(){
		var saveId = $(this).attr('data-save');
		data[saveId] = $('.js-mark[data-save="'+ saveId +'"]').val() +"~~"+$('.js-notes[data-save="'+ saveId +'"]').val();
	});
	
	/* Mark Validation */
	
	/* $(".js-category-mark").each(function(){
		console.log($(this).text());
		console.log($(this).closest('input.js-mark').val());
	}); */
	
	var exam_scheduler_id = '{{ $examinerScheduler->id }}';
	var url = appUrl + "/evaluationStore";
	var token = $('meta[name=csrf-token]').attr("content");
	var grade = $('.js-grade').val();
	var final_note = $('.js-final-note').val();
	if(grade == ''){
		$('#err_grade').show();
	}else if(final_note == ''){
		$('#err_grade').hide();
		$('#err_note').show();
	}else{
		$('#err_note').hide();
		$('#err_grade').hide();
		swal({
  title: "Submit Evaluation?",
  text: "Once submitted you will not be able to change the evaluation! Press Ok if you want to proceed",
  icon: "warning",
  buttons: true,
  dangerMode: false,
})
.then((saveEval) => {
  if (saveEval) {
	var data = {};
		$(".js-mark").each(function(){
			var saveId = $(this).attr('data-save');
			data[saveId] = $('.js-mark[data-save="'+ saveId +'"]').val() +"~~"+$('.js-notes[data-save="'+ saveId +'"]').val();
		});
		var exam_scheduler_id = '{{ $examinerScheduler->id }}';
		var url = appUrl + "/evaluationStore";
		var token = $('meta[name=csrf-token]').attr("content");
		var grade = $('.js-grade').val();
		var final_note = $('.js-final-note').val();
		if(grade == ''){
			$('#err_grade').show();
		}else if(final_note == ''){
			$('#err_grade').hide();
			$('#err_note').show();
		}else{
			$('#err_note').hide();
			$.ajax({
				url: url,
				method: "post",
				data: {'exam_scheduler_id':exam_scheduler_id,'_token':token,'data':data,'grade':grade,'final_note':final_note},
				success: function(result){
					js_notification('success','Student Evaluation Completed');
					setTimeout(function(){ location.href = "{{ url('/') }}" + '/examiner-evaluation'; }, 1000);
				}
			})
		}

  }
});
	}
	
});

</script>
</html>