<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExamScheduler extends Model
{
	public $timestamps = false;
	protected $table 	= 'exam_scheduler';
	protected $fillable	=['slot_id','student_id','examiner_id','exam_master_id','status','created_by','academy_name'];
	
	public function exam_master()
	{
		return $this->belongsTo('App\Models\ExamMaster','exam_master_id','id');
	}
	
	public function student()
	{
		return $this->belongsTo('App\Models\Users','student_id','id');
	}
	
	public function slot()
	{
		return $this->belongsTo('App\Models\Slots','slot_id','id');
	}
	
	public function examEvaluationGrade()
	{
		return $this->belongsTo('App\Models\ExamEvaluationGrade','id','exam_shedule_id');
	}
}