<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CommonEmail extends Mailable
{
    use Queueable, SerializesModels;

    /**
     * Create a new message instance.
     *
     * @return void
     */
	 
	public $template; 
	public $data; 
    public function __construct($template,$data)
    {
       $this->data = $data;
       $this->template = $template;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $from = $this->data['from'];
        $replayTo = $this->data['replayTo'];
        $subject = $this->data['subject'];
		$templatePath = 'emails.'.$this->template;
        return $this->view($templatePath)
                    ->from($from)
                    ->replyTo($replayTo)
                    ->subject($subject)
                    ->with([ 'test_message' => $this->data['message'] ]);
    }
}
