<?php

namespace App\Http\Controllers\Site;
use App\Http\Controllers\Controller as Controller;
use Request;
use Redirect;
use App\Models\Slots;
use App\Http\Helper\Admin\Helpers;
use App\Models\ExamScheduler;
use App\Models\ExamEvaluation;
use App\Models\ExamMaster;
use App\Models\ExamEvaluationGrade;
use App\Models\Academy;
use App\Models\Users;
use App\Models\FeeStructure;
use App\Models\Country;
use Auth;
use DB;
use Hash;
use Session;
use Razorpay\Api\Api;
use PDF;
use PayPal\Rest\ApiContext;
use PayPal\Auth\OAuthTokenCredential;
use PayPal\Api\Amount;
use PayPal\Api\Details;
use PayPal\Api\Item;
use PayPal\Api\ItemList;
use PayPal\Api\Payer;
use PayPal\Api\Payment;
use PayPal\Api\RedirectUrls;
use PayPal\Api\ExecutePayment;
use PayPal\Api\PaymentExecution;
use PayPal\Api\Transaction;
//use Illuminate\Http\Request;
use App\Mail\CommonEmail;
use Mail;
use App\Models\Configurations;


class LandingController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $paypal_configuration = \Config::get('paypal');
        $this->_api_context = new ApiContext(new OAuthTokenCredential($paypal_configuration['client_id'], $paypal_configuration['secret']));
        $this->_api_context->setConfig($paypal_configuration['settings']);
    }

   
    public function index()
    {
        return view('site/landing/landing');
    }
    public function whyCertification()
    {
        return view('site/landing/whycertification');
    }
    public function howToApply()
    {
        return view('site/landing/howtoapply');
    }
    public function syllabus()
    {
        return view('site/landing/syllabus');
    }
    public function benefits()
    {
        return view('site/landing/benifits');
    }
    public function about()
    {
        return view('site/landing/about');
    }
    public function eligibility()
    {
        return view('site/landing/eligibility');
    }
    public function fees()
    {
        return view('site/landing/fees');
    }
    public function schedule()
    {
        return view('site/landing/schedule');
    }
    public function advisory()
    {
        return view('site/landing/advisory');
    }
    public function apply()
    {
        return view('site/landing/apply');
    }
    public function enquiry()
    {
        return view('site/landing/enquiry');
    }
    public function contact()
    {
        return view('site/landing/contact');
    }
	public function apply_Exam()
	{
	    return view('site/landing/my-apply');
	}
	public function dashboard()
    {	
		//student_id
		$date = date('m/d/Y');
		$first_day_this_month = date('Y-m-01',strtotime($date));
		$last_day_this_month  = date('Y-m-t',strtotime($date));
		
		$examinerScheduler = ExamScheduler::pluck('slot_id')->toArray();
		$slotInfo = Slots::with('evaluation')->whereIn('id',$examinerScheduler)->where('status','Active')->get();
		$examinerSchedulerinfo = ExamScheduler::whereHas('slot', function($q) use($first_day_this_month,$last_day_this_month){
									$q->whereRaw("DATE(slot_date) >= '$first_day_this_month' and DATE(slot_date) <= '$last_day_this_month'");
								})->with('exam_master','student','slot','examEvaluationGrade')->where('status','Complete')->get();
		
        return view('site/landing/dashboard',compact('slotInfo','examinerScheduler','examinerSchedulerinfo'));
    }
	
	public function exam_view($id){
		$id = Helpers::encodeAndDecodeID($id,'decode');
		$examinerScheduler = ExamScheduler::with('exam_master','student','examEvaluationGrade')->where('id',$id)->get()->first();
		return view('site/landing/exam_view',compact('id','examinerScheduler'));
	}
	
	
	public function getExamListing(){
		$request = Request::all();
		$date = date('m/d/Y',strtotime($request['date']));
		$type = $request['type'];
		if($type == 0){
			$first_day_this_month = date('Y-m-01', strtotime("+1 month",strtotime($date)));
			$last_day_this_month  = date('Y-m-t',strtotime("+1 month",strtotime($date)));
			$date = date('F - Y',strtotime("+1 month",strtotime($date)));
		}else{
			$first_day_this_month = date('Y-m-01', strtotime("-1 month",strtotime($date)));
			$last_day_this_month  = date('Y-m-t',strtotime("-1 month",strtotime($date)));
			$date = date('F - Y',strtotime("-1 month",strtotime($date)));
		}
		$examinerScheduler = ExamScheduler::pluck('slot_id')->toArray();
		$slotInfo = Slots::with('evaluation')->whereIn('id',$examinerScheduler)->where('status','Active')->get();
		$examinerSchedulerinfo = ExamScheduler::whereHas('slot', function($q) use($first_day_this_month,$last_day_this_month){
									$q->whereRaw("DATE(slot_date) >= '$first_day_this_month' and DATE(slot_date) <= '$last_day_this_month'");
								})->with('exam_master','student','slot','examEvaluationGrade')->where('status','Complete')->get();
		return view('site/landing/dashboard_ajax',compact('slotInfo','examinerScheduler','examinerSchedulerinfo','date'));
	}
	
	public function studentEdit(){
		$id = Auth::user()->id;
		$usersInfo = Users::where('id',$id)->get()->first();
		$country = Country::whereNull('deleted_at')->pluck('name','id')->toArray();
		return view('site/student/studentEdit',compact('usersInfo','country'));
	}
	
	public function studentUpdate(){
		DB::beginTransaction();
		try{
			$request = Request::all();
			$id = Helpers::encodeAndDecodeID($request['id'],'decode');
			unset($request['_token']);
			unset($request['id']);
			
			if(isset($request['dob']))
			
			$request['dob'] = date('Y-m-d',strtotime($request['dob']));
			$data['from'] = 'sivakumaraa@gmail.com';
			$data['replayTo'] = 'sivakumaraa@gmail.com';
			$data['subject'] = 'Your ICIMP profile updated successfully';
			$data['message'] = 'Dear '.$request['name'].'<br>You have successfully updated your ICIMP profile.<br>If you think you have not updated your profile please reach out to our support team -<br>'.$request['email'].'<br>'.$request['phone'].'<br>Regards,<br>Team ICIMP<br>www.icimp.com<br>www.swarkul.com';
			$template = 'apply';
			Mail::to($request['email'])->send(new CommonEmail($template,$data));

			Users::where('id',$id)->update($request);
			DB::commit();
			return redirect('dashboard')->with('success','Successfully updated');
		} catch(Exception $e) {
			DB::rollback();
			return redirect('dashboard')->with('success','Something went wrong');
		}
	}
	
	public function changePassword(){
		$id = Auth::user()->id;
		$usersInfo = Users::where('id',$id)->get()->first();
		return view('site/student/changePassword',compact('usersInfo'));
	}
	
	public function studentchangePassword(){
		DB::beginTransaction();
		try{
			$request = Request::all();
			$id = Helpers::encodeAndDecodeID($request['id'],'decode');
			unset($request['_token']);
			unset($request['id']);
			unset($request['confirm_password']);
			
			$request['password'] = Hash::make($request['password']);
			Users::where('id',$id)->update($request);
			
			DB::commit();
			return redirect('dashboard')->with('success','Successfully updated');
		} catch(Exception $e) {
			DB::rollback();
			return redirect('dashboard')->with('success','Something went wrong');
		}
	}
	
	public function myCertification(){
		$examinerScheduler = ExamScheduler::where('student_id',Auth::user()->id)->pluck('slot_id')->toArray();
		$slotInfo = Slots::with('evaluation')->whereIn('id',$examinerScheduler)->where('status','Active')->get();

	//	$date = date('m/d/Y');
	//	$first_day_this_month = date('Y-m-01',strtotime($date));
	//	$last_day_this_month  = date('Y-m-t',strtotime($date));
	//	$examinerSchedulerinfo = ExamScheduler::where('student_id',Auth::user()->id)->whereHas('slot', function($q) use($first_day_this_month,$last_day_this_month){
	//								$q->whereRaw("DATE(slot_date) >= '$first_day_this_month' and DATE(slot_date) <= '$last_day_this_month'");
	//							})->with('exam_master','student','slot','examEvaluationGrade')->get();
	$examinerSchedulerinfo = ExamScheduler::where('student_id',Auth::user()->id)
			->with('exam_master','student','slot','examEvaluationGrade')->get();
		return view('site/student/my-certification',compact('slotInfo','examinerScheduler','examinerSchedulerinfo'));
	}
	
	public function myCertificationListing(){
		$request = Request::all();
		$date = date('m/d/Y',strtotime($request['date']));
		$type = $request['type'];
		if($type == 0){
			$first_day_this_month = date('Y-m-01', strtotime("+1 month",strtotime($date)));
			$last_day_this_month  = date('Y-m-t',strtotime("+1 month",strtotime($date)));
			$date = date('F - Y',strtotime("+1 month",strtotime($date)));
		}else{
			$first_day_this_month = date('Y-m-01', strtotime("-1 month",strtotime($date)));
			$last_day_this_month  = date('Y-m-t',strtotime("-1 month",strtotime($date)));
			$date = date('F - Y',strtotime("-1 month",strtotime($date)));
		}

		$examinerScheduler = ExamScheduler::where('student_id',Auth::user()->id)->pluck('slot_id')->toArray();
		$slotInfo = Slots::with('evaluation')->whereIn('id',$examinerScheduler)->where('status','Active')->get();
		$examinerSchedulerinfo = ExamScheduler::where('student_id',Auth::user()->id)->whereHas('slot', function($q) use($first_day_this_month,$last_day_this_month){
									$q->whereRaw("DATE(slot_date) >= '$first_day_this_month' and DATE(slot_date) <= '$last_day_this_month'");
								})->with('exam_master','student','slot','examEvaluationGrade')->get();
		return view('site/student/my-certification_ajax',compact('slotInfo','examinerScheduler','examinerSchedulerinfo','date'));
	}
	
	
	public function applyCertification(){
	    $user_ip_address=Request::ip();
        	   $details = "http://api.ipstack.com/{$user_ip_address}?access_key=7165d70ac9db9d25826246b8f9cd0b81"; 
        	   $curl_handle=curl_init();
          curl_setopt($curl_handle,CURLOPT_URL,$details);
          curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
          curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
          $buffer = curl_exec($curl_handle);
          curl_close($curl_handle);
          if (empty($buffer)){
              $country_name = '';
          }
          else{
              $abc = json_decode($buffer);
              $country_name = $abc->country_name;
          }
		$student_id = Auth::user()->id;
		if(ExamScheduler::where('student_id',Auth::user()->id)->where('status','Inprogress')->count() > 0){
			return 'Your certification is in progress, please complete the existing certification or contact administrator for more information';
		}else if(ExamScheduler::where('student_id',Auth::user()->id)->where('status','Pending')->count() > 0){
			return 'You cannot apply for more than one certification at a time';
		}else if(ExamScheduler::where('student_id',Auth::user()->id)->whereIn('status',['Pending','Inprogress'])->count() == 0){
			$examinerScheduler = ExamScheduler::whereNull('student_id')->where('examiner_id','!=',0)->whereNotNull('exam_master_id')->where('status','Pending')->pluck('exam_master_id')->toArray();
			$academy = Academy::select(
            DB::raw("CONCAT(unique_code,' - ',academy_name) AS academy_name"),'id')->whereNull('deleted_at')->pluck('academy_name','id')->toArray();
			//$genre = ExamMaster::whereIn('id',$examinerScheduler)->groupBy('genre')->pluck('genre','id')->toArray();
            $genre = DB::table('genrelist')->groupBy('genre')->pluck('genre','id')->toArray();
			return view('site/landing/applyCertification',compact('genre', 'academy','country_name'));
		}
		
	}
	
	public function getLevel(){
		$request = Request::all();
		$genre_id = $request['genre_id'];
		$genre_text = ExamMaster::where('id',$genre_id)->pluck('genre');
	//	$subCategory = ExamMaster::where('genre',$genre_text)
	    $subCategory = DB::table('fee_structure')->groupBy('level')->pluck('level','id')->toArray();
	
		return $subCategory;
	}
	
	public function getLevelPrice(){
	    $user_ip_address=Request::ip();
        	   $details = "http://api.ipstack.com/{$user_ip_address}?access_key=7165d70ac9db9d25826246b8f9cd0b81"; 
        	   $curl_handle=curl_init();
          curl_setopt($curl_handle,CURLOPT_URL,$details);
          curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
          curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
          $buffer = curl_exec($curl_handle);
          curl_close($curl_handle);
          if (empty($buffer)){
              $country_name = '';
          }
          else{
              $abc = json_decode($buffer);
              $country_name = $abc->country_name;
          }
		$request = Request::all();
		$level = $request['level'];
		//$levelInfo = ExamMaster::where('id',$level)->get()->first();
	    $levelPrice =	DB::table('fee_structure')->where('id',$level)->first();
		//$levelPrice = FeeStructure::where('level',$levelInfo->exam_level)->get()->first();
		$countryInfo = Country::where('id',Auth::user()->country)->get()->first();
		if($country_name == 'India'){
			$price = isset($levelPrice->inr_currency) ? $levelPrice->inr_currency : '0';
		}else{
			$price = isset($levelPrice->usd_currency) ? $levelPrice->usd_currency : '0';
		}
		return $price;
	}
	
	public function applyExam(){
		$popup = Request::all();

		$general = DB::table('genrelist')->find($popup['genre']);
		$level = FeeStructure::find($popup['level']);
		$masterId = ExamMaster::where('exam_level',$level->level)->where('genre',$general->genre)->first();
		$ExaminerCapabilities = DB::table('examiner_capabilities')->where('level',$level->level)->where('genre',$general->genre)->pluck('examiner_id')->toArray();
		
		//ExamScheduler::where('exam_master_id',$request['level'])->whereNull('student_id')->update(['student_id'=>Auth::user()->id,'academy_name'=>$request['academy_name'],'Student_booked_at'=>date('Y-m-d h:i:s')]);
		$date = date('Y-m-d');
		$listingInfo = ExamScheduler::whereIn('created_by',$ExaminerCapabilities)
			->where('status','Pending')
			->whereNull('student_id')
			->whereHas('slot', function($q) use($date){
				$q->whereRaw("DATE(slot_date) >= '$date'");
			})
			->with('student','slot','examEvaluationGrade')->get();
		// $listingInfo = ExamScheduler::where('exam_master_id',$popup['level'])
		// ->where('status','Pending')
		// ->whereNull('student_id')
		// ->whereHas('slot', function($q) use($date){
		// 	$q->whereRaw("DATE(slot_date) >= '$date'");
		// })
		// ->with('exam_master','student','slot','examEvaluationGrade')->get();
		
		//$listingInfo = ExamScheduler::where('student_id',Auth::user()->id)->where('status','Pending')->with('exam_master','student','slot','examEvaluationGrade')->get();

		return view('site/landing/my-apply',compact('listingInfo','popup','masterId'));
	}
	
	public function paymentconfirm($id, $academy, $level,$slot,$master){

	    $user_ip_address=Request::ip();
	   $details = "http://api.ipstack.com/{$user_ip_address}?access_key=7165d70ac9db9d25826246b8f9cd0b81"; 
	   $curl_handle=curl_init();
  curl_setopt($curl_handle,CURLOPT_URL,$details);
  curl_setopt($curl_handle,CURLOPT_CONNECTTIMEOUT,2);
  curl_setopt($curl_handle,CURLOPT_RETURNTRANSFER,1);
  $buffer = curl_exec($curl_handle);
  curl_close($curl_handle);
  if (empty($buffer)){
      $country_name = '';
  }
  else{
      $abc = json_decode($buffer);
      $country_name = $abc->country_name;
  }
	    //print_r($details);
	    //die;
		$examServerCheck = ExamScheduler::where('id',$id)->whereNotNull('student_booked_at')->where('status','Pending')->get();
		//dd($examServerCheck);
		
		ExamScheduler::where('id',$id)->where('slot_id',$slot)->update(['slot_booking_status' => 1]);
		if($examServerCheck->count() == 0){
			
			$levelInfo = ExamMaster::where('id',$level)->get()->first();
			$levelPrice = FeeStructure::where('level',$levelInfo->exam_level)->get()->first();
			$countryInfo = Country::where('id',Auth::user()->country)->get()->first();
			
			
			
			if(strtolower($country_name) == 'india'){
				$price = isset($levelPrice->inr_currency) ? $levelPrice->inr_currency.'00' : '000';
			}else{
				$price = isset($levelPrice->usd_currency) ? $levelPrice->usd_currency : '0';
			}
		
			//dd(strtolower($countryInfo->name));
			
			if($country_name == 'India'){
				$key_id = 'rzp_test_myFbwsfAtaPX7d';
				$key_secret = 'bKcvzv9RWbEAGijofCctNufT';
				$api = new Api($key_id, $key_secret);
				
				$order  = $api->order->create([
				  'receipt'         => 'order_swarkul'.microtime(),
				  'amount'          => $price, // amount in the smallest currency unit
				  'currency'        => 'INR',// <a href="/docs/payment-gateway/payments/international-payments/#supported-currencies" target="_blank">See the list of supported currencies</a>.)
				]);
				
				$orderId = $order->id;
				$amount = $price;

				$timer = Configurations::find(5);
				
				return view('site/landing/payment',compact('orderId','amount','academy','level','timer','master','id'));
			}else{
				$payer = new Payer();
				$payer->setPaymentMethod('paypal');
                
				$item_1 = new Item();

				$item_1->setName('Swarkul')
					->setCurrency('USD')
					->setQuantity(1)
					->setPrice($price);

				$item_list = new ItemList();
				$item_list->setItems(array($item_1));

				$amount = new Amount();
				$amount->setCurrency('USD')
					->setTotal($price);

				$transaction = new Transaction();
				$transaction->setAmount($amount)
					->setItemList($item_list)
					->setDescription('Swarkul');

				$redirect_urls = new RedirectUrls();
				$redirect_urls->setReturnUrl(url('/payment/'.$id.'/success'))
					->setCancelUrl(url('/payment/'.$id.'/fail'));

				$payment = new Payment();
				$payment->setIntent('Sale')
					->setPayer($payer)
					->setRedirectUrls($redirect_urls)
					->setTransactions(array($transaction));            
				try {
					$payment->create($this->_api_context);
				} catch (\PayPal\Exception\PPConnectionException $ex) {
					if (\Config::get('app.debug')) {
						\Session::put('error','Connection timeout');
						return Redirect::route('dashboard');                
					} else {
						\Session::put('error','Some error occur, sorry for inconvenient');
						return Redirect::route('dashboard');                
					}
				}

				foreach($payment->getLinks() as $link) {
					if($link->getRel() == 'approval_url') {
						$redirect_url = $link->getHref();
						break;
					}
				}
				
				Session::put('paypal_payment_id', $payment->getId());

				if(isset($redirect_url)) {            
					return Redirect::away($redirect_url);
				}

				\Session::put('error','Unknown error occurred');
				return Redirect::route('dashboard');
			}
		}else{
			return redirect('dashboard')->with('error','Already someone booked this slot');
		}
	}
	
	public function paymentsuccess($id,$academy,$master){
		ExamScheduler::where('id',$id)
			->update(['student_id'=>Auth::user()->id,'academy_name'=>$academy,'student_booked_at'=>date('Y-m-d h:i:s'),'payment_status'=>'Success','exam_master_id' => $master]);
		//ExamScheduler::where('id',$id)->update(['student_booked_at'=>NULL,'payment_status'=>'Success']);
		$examSchedulerInfo = ExamScheduler::where('id',$id)->get()->first();
		$slotInfo = Slots::where('id',$examSchedulerInfo->slot_id)->get()->first();
		$studentInfo = Users::where('id',$examSchedulerInfo->student_id)->get()->first();
		$examinerInfo = Users::where('id',$examSchedulerInfo->examiner_id)->get()->first();
		$examInfo = ExamMaster::where('id',$examSchedulerInfo->exam_master_id)->get()->first();
		$email = $studentInfo->email;
		$data['from'] = 'sivakumaraa@gmail.com';
		$data['replayTo'] = 'sivakumaraa@gmail.com';
		$data['subject'] = 'Successfully applied for ICIMP certification';
		
		$data['message'] = 'Dear '.$studentInfo->name.' Below slot has been confirmed by student for ICIMP certification-
		<br>Certification Date '.date('m/d/Y',strtotime($slotInfo->slot_date)).' and time '.$slotInfo->slot_time_start.' '.$slotInfo->slot_time_end.'
		<br>Certification detail: '.$examInfo->genre.'-'.$examInfo->level.'
		<br>Examiner Zoom ID: '.$examSchedulerInfo->zoom_url.'. Zoom Password: '.$examSchedulerInfo->zoom_password.'Note - You will need zoom app on your device which you will be using at the time of certification.<br>
        Please keep your mobile on silent mode at the time of certification exam to avoid any type of distraction.<br>
        Please make sure you have stable internet connection during the exam time.<br>
        Please bring in your photo id which you have uploaded at the time of creating the exam. Examiner will check the photo id and complete the exam only after successful validation of the photo id.
        <br>Thanks & Regards,<br>Team ICIMP<br>www.icimp.com<br>www.swarkul.com';
		$template = 'apply';
		Mail::to($email)->send(new CommonEmail($template,$data));
		Mail::to($examinerInfo->email)->send(new CommonEmail($template,$data));
		Mail::to('admin@swarkul2.com')->send(new CommonEmail($template,$data));
		return redirect('my-certification');
	}

	public function SlotBookingStatus($id){
		$examSchedulerInfo = ExamScheduler::where('id',$id)->first();

		if ($examSchedulerInfo->slot_booking_status == 0) {
			return response()->json(['status' => true]);
		}else{
			return response()->json(['status' => false]);
		}
	}

	public function changeStatus($id){
		ExamScheduler::where('id',$id)->update(['slot_booking_status' => 0]);
		return response()->json(['status' => true]);
	}
	
	public function paymentfail($id){
		if(ExamScheduler::where('id',$id)->where('payment_status','Success')->count() == 0)
			ExamScheduler::where('id',$id)->update(['student_booked_at'=>NULL,'payment_status'=>'Failed','student_id'=>NULL,'academy_name'=>NULL]);
		return redirect('my-certification');
	}

	public function studentcapability($level,$genre){

		$levels = FeeStructure::find($level);
		$general = DB::table('genrelist')->find($genre);

		$masterId = ExamMaster::where('exam_level',$levels->level)->where('genre',$general->genre)->first();

		$previousExample = ExamScheduler::where('student_id',Auth::user()->id)->where('exam_master_id',$masterId->id)->first();
		
		if (! empty($previousExample)) {
			return response()->json(['status' => 2]);
		}else{
			
			if ($level >= 5) {
				$capability = ExamScheduler::where('student_id',Auth::user()->id)->get();
				
				if (count($capability) > 0) {
					return response()->json(['status' => 1]);
				}else{
					return response()->json(['status' => 0]);
				}
			}else{
				return response()->json(['status' => 1]);
			}

		}
	}
	
	public function getCertification($id){
		$id = Helpers::encodeAndDecodeID($id,'decode');
		$eEG = ExamEvaluationGrade::where('exam_shedule_id',$id)->get()->first();
		$name = Auth::user()->name;
		$grade = json_decode($eEG->status, true);
				$array_mark = array_keys($grade);
				$array_status = array_values($grade);
				$status = '';
				if ($eEG->grade  >= 0 && $eEG->grade <= $array_mark[0]) {
					$status = $array_status[0];
				} elseif ($eEG->grade >= $array_mark[0] && $eEG->grade <= $array_mark[1]) {
					$status = $array_status[1];
				} elseif ($eEG->grade >= $array_mark[1] && $eEG->grade <= $array_mark[2]) {
					$status = $array_status[2];
				} elseif ($eEG->grade >= $array_mark[2] && $eEG->grade <= $array_mark[3]) {
					$status = $array_status[3];
				}
				
		$pdf = PDF::loadView('site/landing/ceritificate',compact('status','name'));
		return $pdf->download('Swarkul.pdf');
	}
	
	
}
