<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use App\User;
use App\Models\Users;
use App\Models\Country;
use App\Models\Academy;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Request;
use Auth;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
    protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }


	public function getRegister(){
		$country = Country::whereNull('deleted_at')->pluck('name','id')->toArray();
        return view('auth.studentRegister',compact('country'));
    }
	
	public function getTeacherRegister(){
		$country = Country::whereNull('deleted_at')->pluck('name','id')->toArray();
        return view('auth.teacherRegister',compact('country'));
    }

	public function storeStudent(){
        $request = Request::all();
		unset($request['_token']);
		unset($request['confirm_password']);
		$request['password'] = Hash::make($request['password']);
		$request['role_type'] = 'Student';
		$request['dob'] = date('Y-m-d',strtotime($request['dob']));
		$request['register_type'] = 'Web';
		Users::create($request);
		return redirect('login')->with('success', 'Student Registration Successful');
    }
	
	public function storeTeacher(){
        
        $request = Request::all();
		unset($request['_token']);
		unset($request['confirm_password']);
		$request['password'] = Hash::make($request['password']);
		$request['role_type'] = 'Academy';
		$request['register_type'] = 'Web';
		$teacherInfo = Academy::where('role_type','Academy')->orderBy('id','desc')->get()->first();
		if(!empty($teacherInfo->unique_code)){
			$code = str_replace('SM','',$teacherInfo->unique_code);
			$code = $code+1;
			$tempLength = strlen($code);
			if($tempLength == 1){
				$code = '000'.$code;
			}elseif($tempLength == 2){
				$code = '00'.$code;
			}elseif($tempLength == 3){
				$code = '0'.$code;
			}else{
				$code = $code;
			}
			$request['unique_code'] = 'SM'.$code;
		}else{
			$request['unique_code'] = 'SM0001';
		}
		Academy::create($request);
		if(Auth::check() && Auth::user()->role_type == 'Admin'){
			return redirect('admin/teacher-management')->with('success', 'Teacher Registration Successful');
		}else{
			return redirect('login')->with('success', 'Teacher Registration Successful');
		}
    }
}
