<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <title>Swarkul</title>

  <!-- Styles -->
  <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <?php echo $__env->yieldPushContent('css'); ?>
  <?php echo $__env->yieldPushContent('css-inline'); ?>
</head>

<body class="bg-full-screen-image">
  <?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  <!-- ======= Hero Section ======= -->
  <section id="hero">
    <div class="hero-container">
      <div id="heroCarousel" class="carousel slide carousel-fade" data-ride="carousel">

        <ol class="carousel-indicators" id="hero-carousel-indicators"></ol>

        <div class="carousel-inner" role="listbox">

          <!-- Slide 1 -->
          <div class="carousel-item active" style="background-image: url('../../../images/site/image1.jpg');">
            <div class="carousel-container">
              <div class="carousel-content container">
                <h2 class="animate__animated animate__fadeInDown">Trinity<br><small> of</small><br> Carnatic Music</h2>
              </div>
            </div>
          </div>

          <!-- Slide 2 -->
          <div class="carousel-item" style="background-image: url('../../../images/site/image2-1.jpg');">
            <div class="carousel-container">
              <div class="carousel-content container">
                <h2 class="animate__animated animate__fadeInDown">Carnatic Music<br> Certification</h2>
              </div>
            </div>
          </div>

          <!-- Slide 3 -->
          <div class="carousel-item" style="background-image: url('../../../images/site/image3.jpg');">
            <div class="carousel-container">
              <div class="carousel-content container">
                <h2 class="animate__animated animate__fadeInDown"><small>Get</small> <br>Swarkul Certified</h2>
              </div>
            </div>
          </div>

          <!-- Slide 4 -->
          <div class="carousel-item" style="background-image: url('../../../images/site/image4.jpg');">
            <div class="carousel-container">
              <div class="carousel-content container">
                <h2 class="animate__animated animate__fadeInDown">Get Certified <br>in<br> Western Music</h2>
              </div>
            </div>
          </div>
        </div>
        <a class="carousel-control-prev" href="#heroCarousel" role="button" data-slide="prev">
          <span class="carousel-control-prev-icon icofont-rounded-left" aria-hidden="true"></span>
          <span class="sr-only">Previous</span>
        </a>
        <a class="carousel-control-next" href="#heroCarousel" role="button" data-slide="next">
          <span class="carousel-control-next-icon icofont-rounded-right" aria-hidden="true"></span>
          <span class="sr-only">Next</span>
        </a>

      </div>
    </div>
  </section>
  <section id="team" class="team">
    <div class="container">
      <div class="row">
        <div class="col-xl-3 col-lg-4 col-md-6" data-aos="fade-up">
          <div class="member">
            <div class="pic"><img src="../../../images/site/why-swarkul.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
              <h4>Why Swarkul Certification?</h4>
              <div class="social">
                <a href="why-certification" class="btn btn-success">Read More</a>
              </div>
            </div>
          </div>
        </div>

        <div class="col-xl-3 col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
          <div class="member">
            <div class="pic"><img src="../../../images/site/apply.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
              <h4>How to Apply?</h4>
              <div class="social">
                <a href="how-to-apply" class="btn btn-success">Read More</a>
              </div>
            </div>
          </div>
        </div>

        <div class="col-xl-3 col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="200">
          <div class="member">
            <div class="pic"><img src="../../../images/site/syllabus.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
              <h4>Syllabus</h4>
              <div class="social">
                <a href="syllabus" class="btn btn-success">Read More</a>
              </div>
            </div>
          </div>
        </div>

        <div class="col-xl-3 col-lg-4 col-md-6" data-aos="fade-up" data-aos-delay="300">
          <div class="member">
            <div class="pic"><img src="../../../images/site/benefits.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
              <h4>Benefits</h4>
              <div class="social">
                <a href="benefits" class="btn btn-success">Read More</a>
              </div>
            </div>
          </div>
        </div>

      </div>

    </div>
  </section>
  <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
<?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->yieldPushContent('script-function'); ?>

</html><?php /**PATH D:\test\resources\views/site/landing/landing.blade.php ENDPATH**/ ?>