<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    <?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('css'); ?>
    <?php echo $__env->yieldPushContent('css-inline'); ?>
</head>
<body class="bg-full-screen-image">

<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Dashboard</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Student Dashboard
            </div>
		</div>
    </section>
    <section id="content" class="container">
	<section id="team" class="team">
    <div class="container">
      <div class="row">
	  <div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="100">
		  <h4><?php echo e(ucfirst(Auth::user()->name)); ?></h4>
		  <h5><?php echo e(Auth::user()->email); ?></h5>
		  <h5><?php echo e(Auth::user()->phone); ?></h5>
		  <SMALL>DATE OF BIRTH</SMALL><br>
		  <h5><?php echo e(Auth::user()->dob); ?></h5>
		  <SMALL>ADDRESS</SMALL><br>
		  <b><?php echo e(ucfirst(Auth::user()->address_1)); ?>,</b><br>
		  <b><?php echo e(ucfirst(Auth::user()->address_2)); ?></b><br>
		  <b><?php echo e(ucfirst(Auth::user()->city)); ?> <?php echo e(ucfirst(Auth::user()->zipcode)); ?></b><br>
		  <b><?php echo e(ucfirst(Auth::user()->state)); ?>, <?php echo e(ucfirst(Auth::user()->country)); ?></b><br>
		  <a href="<?php echo e(url('/student-edit')); ?>" class="btn btn-success mt-2">Edit Bio</a>
		  <a href="<?php echo e(url('/change-password')); ?>" class="btn btn-success mt-2">Change Password</a>
          
        </div>
        <div class="col-xl-3 col-lg-4 col-md-3" data-aos="fade-up" data-aos-delay="100">
          <div class="member">
            <div class="pic"><img src="../../../images/site/examiner-schedule.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
            <h1 style="font-size: 50px; color: #fff;"></h1>
            <h4>Get Swarkul Certified</h4>
              <div class="social">
                <a href="javascript:void(0)" class="btn btn-success js-apply">Apply for Certification</a>
              </div>
            </div>
          </div>
        </div>

        <div class="col-xl-3 col-lg-4 col-md-3" data-aos="fade-up" data-aos-delay="200">
          <div class="member">
            <div class="pic"><img src="../../../images/site/evaluation.jpg" class="img-fluid" alt=""></div>
            <div class="member-info">
            <h1 style="font-size: 50px; color: #fff;"></h1>
            <h4>My Certification and Schedule</h4>
              <div class="social">
                <a href="<?php echo e(url('/my-certification')); ?>" class="btn btn-success">View</a>
              </div>
            </div>
          </div>
		</div>
      </div>

    </div>
	

  </section>
	
<div id="applyModal" class="modal fade" role="dialog">
  <div class="modal-dialog js-append">

  </div>
</div>
    </section>
    <?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
    <?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->yieldPushContent('script'); ?>
    <?php echo $__env->yieldPushContent('script-function'); ?>
	<script>
	$(document).on('click','.js-prev-month',function(){
	var type = -1;
	var monthDate = $(this).attr('data-date');
	loadListing(monthDate,type);
});

$(document).on('click','.js-next-month',function(){
	var type = 0;
	var monthDate = $(this).attr('data-date');
	loadListing(monthDate,type);
});

function loadListing(monthDate,type){
	var url = appUrl + "/getExamListing";
	var token = $('meta[name=csrf-token]').attr("content");
	$.ajax({
		url: url,
		method: "post",
		data: {'date':monthDate,'type':type,'_token':token},
		success: function(result){
			$('.js-dynamic-list').html(result);
		}
	})
}

$(document).on('click','.js-apply',function(){
	var url = appUrl + "/apply-certification";
	var token = $('meta[name=csrf-token]').attr("content");
	$.ajax({
		url: url,
		method: "post",
		data: {'_token':token},
		success: function(result){
			if(result == 'Your certification is in progress, please complete the existing certification or contact administrator for more information'){
				js_notification('error',result);
			}else if(result == 'You cannot apply for more than one certification at a time'){
				js_notification('error',result);
			}else{
				$('.js-append').html(result);
				$('#applyModal').modal('show');
				popvalidate();
			}
		}
	})
});

$(document).on('change', '.js-genre', function(){
	$('#level').find('option').remove();
	var url = appUrl + "/getLevel";
	var genre_id = $(this).val();
	var token = $('meta[name=csrf-token]').attr("content");
	var options = '<option value="">Select</option>';
	$.ajax({
		url: url,
		method: "post",
		data: {'genre_id':genre_id,'_token':token},
		success: function(result){
			$.each(result, function(key, value){
				options += '<option value="'+key+'">'+value+'</option>';
			});
			$('#level').append(options).trigger('change');
		}
	})
});


function popvalidate(){
	$('#popForm').bootstrapValidator({
        message: 'This value is not valid',
        feedbackIcons: {
            valid: '',
            invalid: '',
            validating: ''
        },
		excluded: [':disabled'],
        fields: {
            genre: {
                message: 'Select genre',
                validators: {
                    notEmpty: {
                        message: 'Select genre'
                    }
                }
            },
			level: {
                message: 'Select level',
                validators: {
                    notEmpty: {
                        message: 'Select level'
                    }
                }
            }
        }
    });
}

$(document).on('change', '.js-level', function(){
	var url = appUrl + "/getLevelPrice";
	var level = $(this).val();
	var token = $('meta[name=csrf-token]').attr("content");
	$.ajax({
		url: url,
		method: "post",
		data: {'level':level,'_token':token},
		success: function(result){
			$('#amount').text(result);
		}
	})
});

$(function(){
	$('body').on('change','#level',function(){
		
		var level = $(this).val();
		var genre = $("#role-column").val();

		if(level > 0){
			var url = appUrl + "/studentcapability/"+level+'/'+genre;
			$.ajax({
				url: url,
				method: "get",
				success: function(result){
					//console.log(result);
					if(result.status == 0){
						$('#applyCertificate').attr('disabled',true);
						$(".toast").hide();
						js_notification('error','Apply the exam with low level grade');
					}
					else if(result.status == 2){
						$('#applyCertificate').attr('disabled',true);
						$(".toast").hide();
						js_notification('error','This Level Already completed');
					}
					else if(result.status == 1) {
						$(".toast").hide();
						$('#applyCertificate').attr('disabled',false);
					}
				}
			})
		}
		
	});
	$(window).resize(function() {
	  	if ($(this).width() < 991){
	    	$('.bio-card').hide();
	  	}else{
	    	$('.bio-card').show();
	    }
	});
});
</script>
</html><?php /**PATH /home/shahul2020/swarkul/resources/views/site/landing/dashboard.blade.php ENDPATH**/ ?>