<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<title>Swarkul | Advisory Committee</title>

	<!-- Styles -->
	<?php echo $__env->make('site.layouts.CommonCSS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<?php echo $__env->yieldPushContent('css'); ?>
	<?php echo $__env->yieldPushContent('css-inline'); ?>
	<?php date_default_timezone_set('Asia/Kolkata'); ?>
</head>

<body class="bg-full-screen-image">
	<?php echo $__env->make('site.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
	<section id="page-header" class="page-evaluate-1">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Evaluation</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				Evaluation
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<div class="row mb-5">
			<div class="col-md-12 js-dynamic-list">
				<center><span data-date="<?php echo e(date('m/d/Y')); ?>" class="prev-arrow js-prev-month"><b>
							<<</b> </span> <span class="font-600 month-heading"><?php echo e(date('F - Y')); ?></span><span data-date="<?php echo e(date('m/d/Y')); ?>" class="next-arrow js-next-month"> <b>>></b></span></center>
				<table class="swarkul-table mt-3">
					<thead>
						<tr>
							<th scope="col">Student</th>
							<th scope="col">Genre</th>
							<th scope="col">Date</th>
							<th scope="col">Time Slot</th>
							<th scope="col">Grade</th>
							<th scope="col">Status</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
						<?php if(count($examinerSchedulerinfo) == 0): ?>
						<tr>
							<td colspan="7">
								<div class="card p-3 w-100 text-center"><b>No slot scheduled for evaluation</b></div>
							</td>
						</tr>
						<?php else: ?>
						<?php $__currentLoopData = $examinerSchedulerinfo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<tr>
							<td>
							<?php if(@$list->student != null): ?>
							<?php echo e(@$list->student->name); ?><br><small>DOB: <?php echo e(date('m/d/Y',strtotime(@$list->student->dob))); ?> </small>
							<?php else: ?>
							<div class="badge badge-light p-2">Student Not Assigned</div>
							<?php endif; ?>
						</td>
							<td><?php echo e(@$list->exam_master->genre); ?></td>
							<td><?php echo e(date('m/d/Y',strtotime($list->slot->slot_date))); ?></td>
							<td><?php echo e($list->slot->slot_time_start); ?> to <?php echo e($list->slot->slot_time_end); ?></td>
							<?php
							$currentTime = date('Ymdhi');
							$enableTime = date('Ymdhi',strtotime('-'.$evalaution_time_from.'  minutes',strtotime($list->slot->slot_date.' '.$list->slot->slot_time_start)));
							$stopTime = date('Ymdhi',strtotime('+'.$evalaution_time_to.'  minutes',strtotime($list->slot->slot_date.' '.$list->slot->slot_time_end)));
							?>
							<td><?php if($list->status == 'Complete'): ?>
								<?php $grade = json_decode($list->examEvaluationGrade->status, true);
								$array_mark = array_keys($grade);
								$array_status = array_values($grade);
								$status = '';
								if ($list->examEvaluationGrade->grade  >= 0 && $list->examEvaluationGrade->grade <= $array_mark[0]) {
									$status = $array_status[0];
								} elseif ($list->examEvaluationGrade->grade >= $array_mark[0] && $list->examEvaluationGrade->grade <= $array_mark[1]) {
									$status = $array_status[1];
								} elseif ($list->examEvaluationGrade->grade >= $array_mark[1] && $list->examEvaluationGrade->grade <= $array_mark[2]) {
									$status = $array_status[2];
								} elseif ($list->examEvaluationGrade->grade >= $array_mark[2] && $list->examEvaluationGrade->grade <= $array_mark[3]) {
									$status = $array_status[3];
								}
								?>
								<div><b><?php echo e($status); ?></b></div>
								<?php else: ?>
								<div><b> - </b></div>
								<?php endif; ?>
							</td>
							<td><?php if($list->status == 'Complete'): ?>
								<div class="swarkul-status complete">Completed</div>
								<?php endif; ?>
								<?php if($slotInfo[$key]->slot_date < $currentDate): ?>
									<div class="swarkul-status pending"><font color="red">Over Due</font></div>
								<?php elseif($slotInfo[$key]->slot_date == $currentDate): ?>
									<?php if($slotInfo[$key]->slot_time_start < $currentTimeist): ?>
									<div class="swarkul-status pending"><font color="red">Over Due</font></div>
									<?php else: ?>
										<div class="swarkul-status pending"><?php echo e($list->status); ?></div>
									<?php endif; ?>
								<?php else: ?>
									<?php if($list->status == 'Pending'): ?>
										<div class="swarkul-status pending"><?php echo e($list->status); ?></div>
									<?php elseif($list->status == 'Inprogress'): ?>
										<div class="swarkul-status inprogress"><?php echo e($list->status); ?></div>
									<?php endif; ?>
								<?php endif; ?>
							</td>
							<?php if(isset($list->examEvaluationGrade)): ?>
								<?php if($slotInfo[$key]->slot_date < $currentDate): ?>
									<td><div class="badge badge-danger p-2">Contact Site Administrator</div></td>
								<?php elseif($slotInfo[$key]->slot_date == $currentDate): ?>
									<?php if($slotInfo[$key]->slot_time_start < $currentTimeist): ?>
										<td><div class="badge badge-danger p-2">Contact Site Administrator</div></td>
									<?php else: ?>
										<td><a class="btn btn-success" href="<?php echo e(url('/examiner-evaluation/view/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode'))); ?>">View</a></td>
									<?php endif; ?>
								<?php else: ?>
									<td><a class="btn btn-success" href="<?php echo e(url('/examiner-evaluation/view/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode'))); ?>">View</a></td>
								<?php endif; ?>
							<?php else: ?>
							<?php if($currentTime >= $enableTime && $currentTime <= $stopTime): ?> 
							<td><a class="btn btn-success" href="<?php echo e(url('/examiner-evaluation/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode'))); ?>">Evaluate</a></td>
								<?php else: ?>
								<?php if($list->status == 'Inprogress'): ?>
								<td>
									<div class="badge badge-danger p-2">Contact Site Administrator</div>
								</td>
								<?php else: ?>
								<td>
									<div class="badge badge-light p-2">Scheduled</div>
								</td>
								<?php endif; ?>
								<?php endif; ?>
								<?php endif; ?>
						</tr>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						<?php endif; ?>

					</tbody>
				</table>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="card bg-light p-3">
					<ul>
						<li>Evaluate button will be enabled <?php echo e($evalaution_time_from); ?> mins before the slot time</li>
						<li>Once you click on evaluate your timer will be enabled and you have <?php echo e($slot_time); ?> mins to complete the evaluation</li>
					</ul>
				</div>
			</div>
		</div>

	</section>
	<?php echo $__env->make('site.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</body>
<?php echo $__env->make('site.layouts.CommonJS', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('site.layouts.flashMessage', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->yieldPushContent('script'); ?>
<?php echo $__env->yieldPushContent('script-function'); ?>
<script>
	$(document).on('click', '.js-save-schedule', function() {
		var id = $(this).attr('data-id');
		var url = appUrl + "/schedulerStore";
		var token = $('meta[name=csrf-token]').attr("content");
		$.ajax({
			url: url,
			method: "post",
			data: {
				'id': id,
				'_token': token
			},
			success: function(result) {
				location.reload();
			}
		})
	});

	$(document).on('click', '.js-prev-month', function() {
		var type = -1;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	$(document).on('click', '.js-next-month', function() {
		var type = 0;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	function loadListing(monthDate, type) {
		var url = appUrl + "/getExamEvaluationListing";
		var token = $('meta[name=csrf-token]').attr("content");
		$.ajax({
			url: url,
			method: "post",
			data: {
				'date': monthDate,
				'type': type,
				'_token': token
			},
			success: function(result) {
				$('.js-dynamic-list').html(result);
			}
		})
	}
</script>

</html><?php /**PATH D:\test\resources\views/site/examiner/examiner_evaluation.blade.php ENDPATH**/ ?>