<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    @include('site.layouts.CommonCSS')
    @stack('css')
    @stack('css-inline')
</head>
<body class="bg-full-screen-image">
@include('site.layouts.header')
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page"> My Certification</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                My Certification
            </div>
		</div>
    </section>
    <section id="content" class="container">
		<div class="row mb-5">
		<div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="50">
				<h4>{{ ucfirst(Auth::user()->name) }}</h4>
				<h5>{{ Auth::user()->email }}</h5>
				<h5>{{ Auth::user()->phone }}</h5>
				<SMALL>DATE OF BIRTH</SMALL><br>
				<h5>{{ Auth::user()->dob }}</h5>
				<SMALL>ADDRESS</SMALL><br>
				<b>{{ ucfirst(Auth::user()->address_1) }},</b><br>
				<b>{{ ucfirst(Auth::user()->address_2) }}</b><br>
				<b>{{ ucfirst(Auth::user()->city)  }} {{ ucfirst(Auth::user()->zipcode)  }}</b><br>
				<b>{{ ucfirst(Auth::user()->state)  }}, {{ ucfirst(Auth::user()->country)  }}</b><br>
				<a href="{{ url('/student-edit') }}" class="btn btn-success mt-2">Edit Bio</a>
				<a href="{{ url('/change-password') }}" class="btn btn-success mt-2">Change Password</a>
			</div>
			<div class="col-md-8 js-dynamic-list">
				<table class="swarkul-table mt-3">
					<thead>
						<tr>							
							<th scope="col">Genre</th>
							<th scope="col">Level</th>
							<th scope="col">Date</th>
							<th scope="col">Time Slot</th>
							<th scope="col">Status</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
						@if(count($examinerSchedulerinfo) == 0)
						<tr>
							<td colspan="7">
								<div class="card p-3 w-100 text-center"><b>No certification found</b></div>
							</td>
						</tr>
						@else
						@foreach($examinerSchedulerinfo as $list)
						<tr>
							
							<td>{{ @$list->exam_master->genre }}</td>
							<td>{{ @$list->exam_master->exam_level }}</td>
							<td>{{ date('d M, Y',strtotime($list->slot->slot_date))  }}</td>
							<td>{{ $list->slot->slot_time_start  }} to {{ $list->slot->slot_time_end  }}</td>
							<td>@if($list->status == 'Complete')
								<div class="swarkul-status complete">Completed</div>
								@elseif($list->status == 'Pending')
								<div class="swarkul-status pending">Scheduled</div>
								@else($list->status == 'Inprogress')
								<div class="swarkul-status inprogress">In-progress</div>
								@endif
							</td>
							@if($list->status == 'Complete')
							<td><a class="btn btn-success" href="{{ url('exam/view/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode')) }}">Evaluation Detail</a> | <a class="btn btn-success" href="{{ url('getCertification/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode')) }}">My Certificate</a></td>
							@else
								<td>-</td>
							@endif
							
						</tr>
						@endforeach
						@endif

					</tbody>
				</table>
			</div>
		</div>
		
		
    </section>
    @include('site.layouts.footer')
</body>
    @include('site.layouts.CommonJS')
	@include('site.layouts.flashMessage')
    @stack('script')
    @stack('script-function')
	<script>
	
	$(document).on('click', '.js-prev-month', function() {
		var type = -1;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	$(document).on('click', '.js-next-month', function() {
		var type = 0;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	function loadListing(monthDate, type) {
		var url = appUrl + "/my-certification-ajax";
		var token = $('meta[name=csrf-token]').attr("content");
		$.ajax({
			url: url,
			method: "post",
			data: {
				'date': monthDate,
				'type': type,
				'_token': token
			},
			success: function(result) {
				$('.js-dynamic-list').html(result);
			}
		})
	}
</script>
</html>