<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    @include('site.layouts.CommonCSS')
    @stack('css')
    @stack('css-inline')
</head>
<body class="bg-full-screen-image">
@include('site.layouts.header')
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Edit</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Change Password
            </div>
		</div>
    </section>
    <section id="content" class="container">
		<div class="row col-md-12">
			{!! Form::model($usersInfo,['url' => url('student/changePassword'),'id'=>'changePassword']) !!}
				<input type="hidden" name="id" value="{{ App\Http\Helper\Admin\Helpers::encodeAndDecodeID($usersInfo->id,'encode') }}" />
				
				<div class="form-group col-md-12 col-12">
				   <label class="text-bold-600">Password<span class="red-star">*</span></label>
				   <input type="password" name="password" class="form-control" id="password">
				   <label class="text-bold-600" style="margin-top: 10px;">Confirm Password<span class="red-star">*</span></label>
				   <input type="password" name="confirm_password" id="confirm_password" class="form-control">
				</div>

				<div class="form-group col-md-6 col-12">
				   <div class="alert alert-warning password-alert d-sm-block" role="alert" style="margin-top: 25px;">
					  
						 <p class="requirements leng"><i class="icofont-check-alt fa-check" style="color: green;"></i><i class="icofont-close-line fa-times" style="color: red;"></i> 8 or more letters</p>
						 <p class="requirements big-letter"><i class="icofont-check-alt fa-check" style="color: green;"></i><i class="icofont-close-line fa-times" style="color: red;"></i> atleast 1 capital letter</p>
						 <p class="requirements num"><i class="icofont-check-alt fa-check" style="color: green;"></i><i class="icofont-close-line fa-times" style="color: red;"></i> at least 1 number</p>
						 <p class="requirements special-char"><i class="icofont-check-alt fa-check" style="color: green;"></i><i class="icofont-close-line fa-times" style="color: red;"></i> at least 1 special character</p>
					  
				   </div>
				</div>
			<div class="col-12 d-flex justify-content-end">
			<button type="submit" class="btn btn-primary mr-1 mb-1">Submit</button>
			<button type="reset" class="btn btn-light-secondary mr-1 mb-1">Reset</button>
		  </div>
			{!! Form::close() !!}
		</div>
		
		
    </section>
    @include('site.layouts.footer')
</body>
    @include('site.layouts.CommonJS')
	@include('site.layouts.flashMessage')
    @stack('script')
    @stack('script-function')

</html>