<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Swarkul | Payment</title>

	<!-- Styles -->
	@include('site.layouts.CommonCSS')
	@stack('css')
	@stack('css-inline')
</head>

<body class="bg-full-screen-image">

	@include('site.layouts.header')

	<section id="page-header" class="page-contact">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Payment</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				Payment
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<section id="team" class="team">
			<small>Booking a slot will take you to the payment gateway and you will have 10 mins to complete your payment.</small>
			<div class="container">
				<div class="row">
					<div class="col-md-2 card p-3 eval-timer">
						Duration<br>
						<h3>
							<label id="minutes"></label>:<label id="seconds"></label>
						</h3>
					</div>
					<div class="col-xl-4 col-lg-4 col-md-4" data-aos="fade-up" data-aos-delay="100">


					</div>
					
				</div>

			</div>


		</section>

		<div id="applyModal" class="modal fade" role="dialog">
			<div class="modal-dialog js-append">

			</div>
		</div>
	</section>
	@include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')

<script>
// window.onbeforeunload = function() {
//     var v = confirm("Are you sure to close the page？");
//     if (v == true) {
    	
//         		window.close();
		
//     }
//     else {
//         return;
//     }
// };
</script>
<script src="https://checkout.razorpay.com/v1/checkout.js"></script>
<script type='text/javascript'>
	function slot_booking_status(){
		var id = "<?php echo $id; ?>";
		var url = appUrl + "/change-status/"+id;
		$.ajax({
			url: url,
			method: "get",
			success: function(result) {
				console.log(result.status);
			}
		})
	}
</script>
<script>
var options = {
    "key": "rzp_test_myFbwsfAtaPX7d", // Enter the Key ID generated from the Dashboard
    "amount": "{{ $amount }}", // Amount is in currency subunits. Default currency is INR. Hence, 50000 refers to 50000 paise
    "currency": "INR",
    "name": "Swarkul",
    "description": "Swarkul Transaction",
    "image": "{{ asset('images/site/logo.png') }}",
    "order_id": "{{ $orderId }}", //This is a sample Order ID. Pass the `id` obtained in the response of Step 1
    "handler": function (response){
        var url = appUrl + "/payment/" + "{{ Request::segment(2) }}" +"/"+ "{{ $academy }}" +"/"+ "{{ $master }}"+"/success";
        
		$.ajax({
			url: url,
			method: "get",
			success: function(result) {
				
				js_notification('success','Thanks for your Payment!. Payment is successfull. Examination Schedule Details has been sent to your registered email id.');
				setInterval(function(){
					location.href = "{{ url('/') }}" + '/my-certification';
				},3500);
			}
		})

    },
    "modal": {
    "ondismiss": function(){
        var id = "<?php echo $id; ?>";
		var url = appUrl + "/change-status/"+id;
		$.ajax({
			url: url,
			method: "get",
			success: function(result) {
				console.log(result.status);
				location.href = "{{ url('/') }}" + '/dashboard'; 
			}
		})
     }
	},
    "prefill": {
        "name": "{{ Auth::user()->name }}",
        "email": "{{ Auth::user()->email }}",
        "contact": "{{ Auth::user()->phone }}"
    },
    "notes": {
        "address": "Razorpay Corporate Office"
    },
    "theme": {
        "color": "#3399cc"
    }
};
var rzp1 = new Razorpay(options);
rzp1.on('payment.failed', function (response){
        var url = appUrl + "/payment/" + "{{ Request::segment(2) }}" + "/fail";
				$.ajax({
					url: url,
					method: "get",
					success: function(result) {
						slot_booking_status();
						location.href = "{{ url('/') }}" + '/dashboard';

					}
				})

});
$(document).ready(function(e){
    rzp1.open();
    e.preventDefault();
});

</script>
<script>
	var minutesLabel = document.getElementById("minutes");
	var secondsLabel = document.getElementById("seconds");
	if (localStorage.getItem("Paymentseconds_" + "{{ Request::segment(2) }}") === null)
		var totalSeconds = "{{ $timer->configuration_value * 60 }}";
	else
		var totalSeconds = "{{ $timer->configuration_value * 60 }}";
		//var totalSeconds = 600;
		//var totalSeconds = localStorage.getItem("Paymentseconds_" + "{{ Request::segment(2) }}");


	setInterval(setTime, 1000);
	var Timecount = 0;

	function setTime() {
		--totalSeconds;
		if (totalSeconds > 0) {
			localStorage.setItem("Paymentseconds_" + "{{ Request::segment(2) }}", totalSeconds);

			secondsLabel.innerHTML = pad(parseInt(totalSeconds % 60));
			minutesLabel.innerHTML = pad(parseInt(totalSeconds / 60));
		} else {
			localStorage.setItem("Paymentseconds_" + "{{ Request::segment(2) }}", 0);
			totalSeconds = 0;
			Timecount++;
			secondsLabel.innerHTML = pad(totalSeconds % 60);
			minutesLabel.innerHTML = pad(parseInt(totalSeconds / 60));
			if (Timecount == 1) {
				var url = appUrl + "/payment/" + "{{ Request::segment(2) }}" + "/fail";
				$.ajax({
					url: url,
					method: "get",
					success: function(result) {
						slot_booking_status();
						js_time_notification('Time Exceeded Please rebook the slot again');
						setTimeout(function() {
							location.href = "{{ url('/') }}" + '/dashboard';
						}, 2000);
					}
				})

			}
		}
	}

	function pad(val) {
		var valString = val + "";
		if (valString.length < 2) {
			return "0" + valString;
		} else {
			return valString;
		}
	}

	

</script>

</html>