<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Swarkul | Dashboard</title>

	<!-- Styles -->
	@include('site.layouts.CommonCSS')
	@stack('css')
	@stack('css-inline')
</head>

<body class="bg-full-screen-image">
	@include('site.layouts.header')
	<section id="page-header" class="page-contact">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page"> My Certification</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				My Certification
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<div class="row mb-5">
			<div class="col-xl-4 col-lg-4 col-md-4 bio-card" data-aos="fade-up" data-aos-delay="50">
				<h4>{{ ucfirst(Auth::user()->name) }}</h4>
				<h5>{{ Auth::user()->email }}</h5>
				<h5>{{ Auth::user()->phone }}</h5>
				<SMALL>DATE OF BIRTH</SMALL><br>
				<h5>{{ Auth::user()->dob }}</h5>
				<SMALL>ADDRESS</SMALL><br>
				<b>{{ ucfirst(Auth::user()->address_1) }},</b><br>
				<b>{{ ucfirst(Auth::user()->address_2) }}</b><br>
				<b>{{ ucfirst(Auth::user()->city)  }} {{ ucfirst(Auth::user()->zipcode)  }}</b><br>
				<b>{{ ucfirst(Auth::user()->state)  }}, {{ ucfirst(Auth::user()->country)  }}</b><br>
				<a href="{{ url('/student-edit') }}" class="btn btn-success mt-2">Edit Bio</a>
				<a href="{{ url('/change-password') }}" class="btn btn-success mt-2">Change Password</a>
			</div>
			<div class="col-md-8 js-dynamic-list">
				<small>Booking a slot will take you to the payment gateway and you will have 10 mins to complete your payment.</small>
				<table class="swarkul-table mt-3">
					<thead>
						<tr>
							<th scope="col">Genre & Level</th>
							<th scope="col">Date</th>
							<th scope="col">Time Slot</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
					    @if(isset($listingInfo) && $masterId->id > 0)
						@foreach($listingInfo as $key => $list)
						<tr>
							<td>{{ $masterId['genre'] }} - {{ $masterId['exam_level'] }}</td>
							<td>{{ date('M d, Y (l)', strtotime($list->slot['slot_date'])) }}</td>
							<td>{{ $list->slot['slot_time_start'] }} - {{ $list->slot['slot_time_end'] }}</td>
							<td class="booknow {{ $list['id'] }}" data-id="{{ $list['id'] }}" data-slot="{{ $list->id .'/'.$popup['academy'].'/'.$popup['level'].'/'.$list['slot_id'].'/'.$masterId->id }}"><a id="bookingSlot" class="btn btn-success" style="background-color: green; border: 1px solid green;">Book This Slot</a></td>
						</tr>
						@endforeach
						@endif
					</tbody>
				</table>
			</div>
		</div>


	</section>
	@include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')
<script>
$(function(){
	//getData();
// 	setInterval(function(){
// 		getData();
// 	},10000);
$('.booknow').click(function(e){
    e.preventDefault();
	var ids = $(this).data('id');
	
	    var url = appUrl + "/slot_booking_status/"+ids;
			$.ajax({
			url: url,
			method: "GET",
			success: function(result){
			    console.log(result);
				if(result.status == false){
						$(".toast-error").hide();
    					js_notification('error','Slot has been  Already taken.  Please try again Later');
    					$('.'+ids).find('a').css('background-color','red');
    					$('.'+ids).find('a').css('border','0');
					}else{
    					$('.'+ids).find('a').removeClass('btn-danger');
						$('.'+ids).find('a').addClass('btn-success');
    					window.location.href = '/paymentconfirm/' + $('.'+ids).data('slot');
				
				}
			}
		})
});
	
		
	
})
</script>

<!--<script type="application/javascript" src="http://jsonip.appspot.com/?callback=getip"></script> -->
</script>
</html>