<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<title>Swarkul | Login</title>

	<!-- Styles -->
	@include('site.layouts.CommonCSS')
	@stack('css')
	@stack('css-inline')
</head>

<body class="bg-full-screen-image">
	@include('site.layouts.header')
	<section id="page-header" class="page-swarkul-login">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Login</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 380px;">
                Login to Swarkul
            </div>
		</div>
    </section>
	<div class="container">
		<div class="content-wrapper">
			<div class="content-body">
				<section id="auth-login" class="row flexbox-container">
					<div class="col-xl-12 col-12">
						<div class="mb-0">
							<div class="row m-0">
								<!-- left section-login -->
								<div class="col-md-6 col-12 px-0">
									<div class="card d-flex justify-content-center">

										<div class="card-content">
											<div class="card-body">
											@if ($message = Session::get('error'))
												<div class="col-xl-8 col-8 login-error pt-2">
													<div class="row">
														<span class="col-xl-11 login-error-msg">{{ $message }}</span><span class="col-xl-1 login-error-msg login-error-msg-hide">X</span>
													</div>
												</div>
											@endif
												<form method="POST" action="{{ url('admin/login') }}">
													@csrf
													<div class="form-group mb-50 mt-2">
														<label class="text-bold-600" for="exampleInputEmail1">Email address</label>
														<input type="email" name="email" class="form-control" id="exampleInputEmail1"></div>
													<div class="form-group">
														<label class="text-bold-600" for="exampleInputPassword1">Password</label>
														<input type="password" name="password" class="form-control" id="exampleInputPassword1">
													</div>

													<button type="submit" class="btn btn-primary glow w-100 position-relative">Login<i id="icon-arrow" class="bx bx-right-arrow-alt"></i></button>
													<div class="row mt-2">
													<div class="text-left col-md-6"><a href="{{ url('student-registration') }}" class="card-link">Register new account</a></div>
													<div class="text-right col-md-6"><a href="{{ url('forgot') }}" class="card-link">Forgot Password?</a></div>
</div>
												</form>
											</div>
										</div>
									</div>
								</div>
								<!-- right section image -->
								<div class="col-md-6 d-md-block d-none text-center align-self-center p-3">
									<div class="card-content">
										<img class="img-fluid" src="{{asset('images/admin/images/pages/login.jpg')}}" alt="branding logo">
									</div>
								</div>
							</div>
						</div>
					</div>
				</section>
			</div>
		</div>
	</div>
	@include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')
<script>
$(document).on('click','.login-error-msg-hide',function(){
	$('.login-error').hide(900);
});
</script>
</html>