<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

	<meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Swarkul | Advisory Committee</title>
    <!-- Styles -->
    @include('site.layouts.CommonCSS')
    @stack('css')
    @stack('css-inline')
<link rel="stylesheet" type="text/css" href="{{asset('css/site/calendar/evo-calendar.css')}}" />
<link rel="stylesheet" type="text/css" href="{{asset('css/site/calendar/evo-calendar.midnight-blue.css')}}" />
</head>
<body class="bg-full-screen-image">
@include('site.layouts.header')
    <section id="page-header" class="page-examiner-syllabus">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Schedules</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Examiner Schedule
            </div>
		</div>
    </section>
    <section id="content" style="min-height: 100px;" class="container">
		<div class="row">
			<div class="col-md-2">
			<div class="row">
				<div class="col-md-12">
				<div style="height: 12px; width: 12px; background-color: #4fe657; position: absolute; top: 6px; border-radius: 6px;"></div> <small style="margin-left: 20px;">Open Slots</small></span>
				</div>
			</div>
			<div class="row">
				<div class="col-md-12">
				<div style="height: 12px; width: 12px; background-color: #ffc107; position: absolute; top: 6px; border-radius: 6px;"></div> <small style="margin-left: 20px;">Booked Slots</small></span>
				</div>
			</div>
			</div>
			<div class="col-md-10">
				<div class="row">
					<div class="col-md-12">
					<div id="calendar"></div>
					</div>
				</div>
			
				
			</div>
		</div>
    </section>
    @include('site.layouts.footer')
</body>
    @include('site.layouts.CommonJS')
	@include('site.layouts.flashMessage')
    @stack('script')
	
    @stack('script-function')
	<script src="{{asset('js/site/calendar/evo-calendar.js')}}"></script>
	<script>
	$(document).ready(function() {
		myEvents = [
	<?php foreach($slotInfo as $list){ if(in_array($list->id, $examinerScheduler)){ ?>
  { 
    id: "required-id-<?php echo $list->id; ?>",
    name: "<?php echo $list->slot_time_start.' to '.$list->slot_time_end; ?>", 
	badge: "Scheduled",
    date: ["<?php echo $list->slot_date; ?>"], 
	<?php if(date('m',strtotime($list->slot_date)) != date('m')){ ?>
	description: "<span class='btn btn-success js-cancel-schedule' data-id='<?php echo $list->id; ?>' >Cancel Booking</span>",
	<?php } ?>
    type: "holiday", 
    everyYear: true 
  },
	<?php }else{ ?>
{ 
    id: "required-id-<?php echo $list->id; ?>",
    name: "<?php echo $list->slot_time_start.' to '.$list->slot_time_end; ?>", 
    date: ["<?php echo $list->slot_date; ?>"], 
	<?php if(date('m',strtotime($list->slot_date)) != date('m')){ ?>
	description: "<span class='btn btn-success js-save-schedule' data-id='<?php echo $list->id; ?>' >Book this slot</span>",
	<?php } ?>
    type: "event", 
    everyYear: true 
  },
	<?php } } ?>
  
  // more events here
];
    $('#calendar').evoCalendar({
		calendarEvents: myEvents,
		todayHighlight:true,
		sidebarToggler: false,
  sidebarDisplayDefault: false,
  eventListToggler: true,
  eventDisplayDefault: true,
  disabledDate: ["12/17/2020","12/21/2020"]

	});
})

$(document).on('click','.js-prev',function(){
	var clickInfo = $(this).attr('data-month');
	var month = clickInfo.split(" ");
	month = month[0];
	if(month == 'January'){
		$('.chevron-arrow-left').click();
		$('li[data-month-val="11"]').click();
	}else if(month == 'February'){
		$('li[data-month-val="0"]').click();
	}else if(month == 'March'){
		$('li[data-month-val="1"]').click();
	}else if(month == 'April'){
		$('li[data-month-val="2"]').click();
	}else if(month == 'May'){
		$('li[data-month-val="3"]').click();
	}else if(month == 'June'){
		$('li[data-month-val="4"]').click();
	}else if(month == 'July'){
		$('li[data-month-val="5"]').click();
	}else if(month == 'August'){
		$('li[data-month-val="6"]').click();
	}else if(month == 'September'){
		$('li[data-month-val="7"]').click();
	}else if(month == 'October'){
		$('li[data-month-val="8"]').click();
	}else if(month == 'November'){
		$('li[data-month-val="9"]').click();
	}else if(month == 'December'){
		$('li[data-month-val="10"]').click();
	}
	
});

$(document).on('click','.js-next',function(){
	var clickInfo = $(this).attr('data-month');
	var month = clickInfo.split(" ");
	month = month[0];
	if(month == 'January'){
		$('li[data-month-val="1"]').click();
	}else if(month == 'February'){
		$('li[data-month-val="2"]').click();
	}else if(month == 'March'){
		$('li[data-month-val="3"]').click();
	}else if(month == 'April'){
		$('li[data-month-val="4"]').click();
	}else if(month == 'May'){
		$('li[data-month-val="5"]').click();
	}else if(month == 'June'){
		$('li[data-month-val="6"]').click();
	}else if(month == 'July'){
		$('li[data-month-val="7"]').click();
	}else if(month == 'August'){
		$('li[data-month-val="8"]').click();
	}else if(month == 'September'){
		$('li[data-month-val="9"]').click();
	}else if(month == 'October'){
		$('li[data-month-val="10"]').click();
	}else if(month == 'November'){
		$('li[data-month-val="11"]').click();
	}else if(month == 'December'){
		$('.chevron-arrow-right').click();
		$('li[data-month-val="0"]').click();
	}
	
});

$(document).on('click','.js-save-schedule',function(){
	var id = $(this).attr('data-id');
	var url = appUrl + "/schedulerStore";
	var token = $('meta[name=csrf-token]').attr("content");
	$.ajax({
		url: url,
		method: "post",
		data: {'id':id,'_token':token},
		success: function(result){
			js_notification('success', 'Slot Booked Successfully');
			setTimeout(function() {
				window.location.href = appUrl + "/zoom-create";
			}, 1000);
		}
	})
});

$(document).on('click','.js-cancel-schedule',function(){
	var id = $(this).attr('data-id');
	
	var url = appUrl + "/schedulerCancel";
	var token = $('meta[name=csrf-token]').attr("content");
	$.ajax({
		url: url,
		method: "post",
		data: {'id':id,'_token':token},
		success: function(result){
			js_notification('success', 'Slot Cancelled Successfully');
			setTimeout(function() {
				window.location.href = appUrl + "/zoom-delete";
			}, 1000);
		}
	})
	
});


</script>
</html>