<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Swarkul | Advisory Committee</title>

	<!-- Styles -->
	@include('site.layouts.CommonCSS')
	@stack('css')
	@stack('css-inline')
</head>

<body class="bg-full-screen-image">
	@include('site.layouts.header')
	<section id="page-header" class="page-evaluate-1">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item"><a href="/examiner-evaluation/">Evaluation</a></li>
					<li class="breadcrumb-item active" aria-current="page">@if(isset($examinerScheduler->student)){{ $examinerScheduler->student->name }} @else John Doe @endif</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				Evaluation
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<div class="col-md-12">
			<div class="row">
				<div class="col-md-12">
					<div class="row">
						<div class="col-md-8">
							<h3>Student Information</h3>
						</div>
						<div class="col-md-4 card p-3 eval-timer">							
							Duration<br>
							<h3>
								
								<label id="minutes"></label>:<label id="seconds"></label>
							</h3>
						</div>
					</div>
					@if(isset($examinerScheduler->student))
					<div class="row p-5">
						<div class="col-md-4">
							<h6>Name</h6>
							<h4> {{ $examinerScheduler->student->name }}</h4>
						</div>
						<div class="col-md-4">
							<h6>Gender</h6>
							@if($examinerScheduler->student->gender == 'female')
							<i style="padding-right: 10px; font-size: 18px;" class="bx bx-female"></i> Female
							@else
							<i style="padding-right: 10px; font-size: 18px;" class="bx bx-male"></i> Male
							@endif
						</div>
						<div class="col-md-4">
							<h6>DOB</h6>
							<b>Born on {{ date('d , F Y',strtotime($examinerScheduler->student->dob)) }}</b>
						</div>

					</div>
				</div>
				@else
				<div class="row">
					<div class="col-md-12 p-5 mb-2">
						<h4>No student information found</h4>
					</div>
				</div>
				@endif
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="row">
					<div class="col-md-8">
						<h3>{{ @$examinerScheduler->exam_master->genre }} Evaluation</h3>
					</div>
					<div class="col-md-4">

					</div>
				</div>
				<div class="row">
					<div class="col-md-12">
						<table class="swarkul-table">
							<tr>
								<th>Category</th>
								<th>Total Marks</th>
								<th>Marks Given</th>
								<th>Notes</th>
							</tr>

							<?php $category = App\Http\Helper\Admin\Helpers::getEvaluationCategory($examinerScheduler->exam_master_id, 0, 0,$examinerScheduler->id); ?>
							@foreach($category as $list)
							{!! $list !!}
							@endforeach
						</table>
					</div>
				</div>
				<div class="row">
					<div class="col-md-12">

						<b>Total Grade : </b><span id="grade_total">{{ (isset($examinerScheduler->examEvaluationGrade->grade) ? $examinerScheduler->examEvaluationGrade->grade." %" : '') }}</span><br>
						<input type="hidden" value="{{ (isset($examinerScheduler->examEvaluationGrade->grade) ? $examinerScheduler->examEvaluationGrade->grade : '') }}" name="mark" class="form-control js-grade" id="grade_mark" maxlength="3" style="width: 100px;">
						<input type="hidden" name="finalMark" class="form-control js-finalMark" id="finalMark" maxlength="3" style="width: 100px;">
						<br>
						<br>
						<input type="hidden" name="scheduler_id" id="scheduler_id" value="{{ $id }}" />
						<b>Final Comment*</b>

						<textarea type="textarea" name="note" class="form-control js-final-note" id="note">{{ (isset($examinerScheduler->examEvaluationGrade->final_comment) ? $examinerScheduler->examEvaluationGrade->final_comment : '' )}}</textarea>
						<span id="err_note" style="color:red;display:none">Enter final comment</span>
					</div>
				</div>
				<div class="row mt-2">
					<div class="col-md-2">
						<button type="button" class="btn btn-success js-save glow w-100 position-relative">Submit Evaluation</button>
					</div>
				</div>
			</div>
		</div>
		</div>
	</section>
	@include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')
<script>
	$('.js-parent').attr('readonly', true);

	$(document).on('change', '.js-child', function() {
		var parentId = $(this).attr('data-parent');
		var totalMark = 0;
		$(".js-child[data-parent='" + parentId + "']").each(function() {
			if ($(this).val() != '')
				totalMark = parseInt(totalMark) + parseInt($(this).val());
		});
		
		$(".js-parent[data-parent='" + parentId + "']").each(function() {
			if ($(this).val() != '')
				totalMark = parseInt(totalMark) + parseInt($(this).val());
		});
		
		if(parentId != 0){
			$('.js-parent[data-child="' + parentId + '"]').val(totalMark).change();
		}else{
			var baseParentMark = 0;
			$(".js-child").each(function() {
				if ($(this).val() != '')
					baseParentMark = parseInt(baseParentMark) + parseInt($(this).val());
			});
			$('.js-parent[data-child="' + parentId + '"]').val(baseParentMark).change();
		}
	});

	$(document).on('change', '.js-parent', function() {
		var parentId = $(this).attr('data-parent');
		var totalParentMark = 0;
		$(".js-parent[data-parent='" + parentId + "']").each(function() {
			if ($(this).val() != '')
				totalParentMark = parseInt(totalParentMark) + parseInt($(this).val());
		});
		if(parentId != 0){
			$('.js-parent[data-child="' + parentId + '"]').val(totalParentMark).change();
		}else{
			var baseParentMark = 0;
			$(".js-child").each(function() {
				if ($(this).val() != '')
					baseParentMark = parseInt(baseParentMark) + parseInt($(this).val());
			});
			$('.js-parent[data-child="' + parentId + '"]').val(baseParentMark).change();
		}
		//$('.js-parent[data-child="' + parentId + '"]').val(totalParentMark);
		
		var given_mark = $('input[data-parent="0"]').val();
		var total_mark = $('td[data-parent="0"]').text();
		
		var final_grade =  (given_mark * ( 100 / total_mark) );
			final_grade =  final_grade.toFixed(2);
		$('#grade_total').text(final_grade+' %');
		$('#grade_mark').val(final_grade);
		$('#finalMark').val(given_mark);

	});

	$(document).on('click', '.js-save', function() {
		
		var given_mark = $('input[data-parent="0"]').val();
		$('#finalMark').val(given_mark);
		
		var data = {};
		$(".js-mark").each(function() {
			var saveId = $(this).attr('data-save');
			data[saveId] = $('.js-mark[data-save="' + saveId + '"]').val() + "~~" + $('.js-notes[data-save="' + saveId + '"]').val();
		});

		/* Mark Validation */

		var errCount = 0;
		$(".js-category-mark").each(function() {
			var category_mark = parseInt($(this).text());
			var givenMark = parseInt($(this).next().find('.js-mark').val());
			console.log(givenMark);
			if (!isNaN(givenMark)) {
				if (category_mark >= givenMark && givenMark >= 0) {
					$(this).next().find('.js-mark-err').hide();
					//errCount--;
				} else {
					$(this).next().find('.js-mark-err').show();
					errCount++;
				}
			}
		});
		var exam_scheduler_id = '{{ $examinerScheduler->id }}';
		var url = appUrl + "/evaluationStore";
		var token = $('meta[name=csrf-token]').attr("content");
		var grade = $('.js-grade').val();
		var mark = $('.js-finalMark').val();
		var final_note = $('.js-final-note').val();
		if (grade == '') {
			$('#err_grade').show();
		} else if (final_note == '') {
			$('#err_grade').hide();
			$('#err_note').show();
		} else if (errCount > 0) {

		} else {
			$('#err_note').hide();
			$('#err_grade').hide();
			swal({
					title: "Submit Evaluation?",
					text: "Once submitted you will not be able to change the evaluation! Press Ok if you want to proceed",
					icon: "warning",
					buttons: true,
					dangerMode: false,
				})
				.then((saveEval) => {
					if (saveEval) {
						var data = {};
						$(".js-mark").each(function() {
							var saveId = $(this).attr('data-save');
							data[saveId] = $('.js-mark[data-save="' + saveId + '"]').val() + "~~" + $('.js-notes[data-save="' + saveId + '"]').val();
						});

						var errCount = 0;
						$(".js-category-mark").each(function() {
							var category_mark = parseInt($(this).text());
							var givenMark = parseInt($(this).next().find('.js-mark').val());
							console.log(givenMark);
							if (!isNaN(givenMark)) {
								if (category_mark >= givenMark && givenMark >= 0) {
									$(this).next().find('.js-mark-err').hide();
									errCount--;
								} else {
									$(this).next().find('.js-mark-err').show();
									errCount++;
								}
							}
						});
						var exam_scheduler_id = '{{ $examinerScheduler->id }}';
						var url = appUrl + "/evaluationStore";
						var token = $('meta[name=csrf-token]').attr("content");
						var grade = $('.js-grade').val();
						var mark = $('.js-finalMark').val();
						var final_note = $('.js-final-note').val();
						if (grade == '') {
							$('#err_grade').show();
						} else if (final_note == '') {
							$('#err_grade').hide();
							$('#err_note').show();
						} else if (errCount > 0) {

						} else {
							$('#err_note').hide();
							$.ajax({
								url: url,
								method: "post",
								data: {
									'exam_scheduler_id': exam_scheduler_id,
									'_token': token,
									'data': data,
									'grade':grade,
									'mark':mark,
									'final_note': final_note
								},
								success: function(result) {
									js_notification('success', 'Student Evaluation Completed');
									setTimeout(function() {
										location.href = "{{ url('/') }}" + '/examiner-evaluation';
									}, 3000);
								}
							})
						}

					}
				});
		}

	});

	$(document).on('change', '.js-mark', function() {
		$(".js-category-mark").each(function() {
			var category_mark = parseInt($(this).text());
			var givenMark = parseInt($(this).next().find('.js-mark').val());
			console.log(givenMark);
			if (!isNaN(givenMark)) {
				if (category_mark >= givenMark && givenMark >= 0) {
					$(this).next().find('.js-mark-err').hide();

				} else {
					$(this).next().find('.js-mark-err').show();

				}
			}
		});
	});
	
var minutesLabel = document.getElementById("minutes");
var secondsLabel = document.getElementById("seconds");
if (localStorage.getItem("seconds_"+"{{ $examinerScheduler->id }}") === null)
	var totalSeconds = '{{ $slot_time }}' * 60;
else
	var totalSeconds = localStorage.getItem("seconds_"+"{{ $examinerScheduler->id }}");

setInterval(setTime, 1000);
var Timecount = 0;
function setTime() {
  --totalSeconds;
  if(totalSeconds > 0){
		localStorage.setItem("seconds_"+"{{ $examinerScheduler->id }}", totalSeconds);
	  secondsLabel.innerHTML = pad(totalSeconds % 60);
	  minutesLabel.innerHTML = pad(parseInt(totalSeconds / 60));
  }else{
	  localStorage.setItem("seconds_"+"{{ $examinerScheduler->id }}", 0);
	  totalSeconds = 0;
	  Timecount++;
	  secondsLabel.innerHTML = pad(totalSeconds % 60);
	  minutesLabel.innerHTML = pad(parseInt(totalSeconds / 60));
	  if(Timecount == 1)
		js_time_notification('Time exceeded');
  }
}

function pad(val) {
  var valString = val + "";
  if (valString.length < 2) {
    return "0" + valString;
  } else {
    return valString;
  }
}


$(document).on('change','.js-dynamic-change', function(){
	var given_mark = $('input[data-parent="0"]').val();
	$('#finalMark').val(given_mark);
	
	var data = {};
	$(".js-mark").each(function() {
		var saveId = $(this).attr('data-save');
		data[saveId] = $('.js-mark[data-save="' + saveId + '"]').val() + "~~" + $('.js-notes[data-save="' + saveId + '"]').val();
	});
	var exam_scheduler_id = '{{ $examinerScheduler->id }}';
	var url = appUrl + "/evaluationStore";
	var token = $('meta[name=csrf-token]').attr("content");
	var grade = $('.js-grade').val();
	var mark = $('.js-finalMark').val();
	var final_note = $('.js-final-note').val();
	$.ajax({
		url: url,
		method: "post",
		data: {
			'exam_scheduler_id': exam_scheduler_id,
			'_token': token,
			'data': data
		},
		success: function(result) {
			
		}
	})
});
</script>

</html>