<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>Swarkul | Advisory Committee</title>

	<!-- Styles -->
	@include('site.layouts.CommonCSS')
	@stack('css')
	@stack('css-inline')
	<?php date_default_timezone_set('Asia/Kolkata'); ?>
</head>

<body class="bg-full-screen-image">
	@include('site.layouts.header')
	<section id="page-header" class="page-evaluate-1">
		<div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Evaluation</li>
				</ol>
			</nav>
			<div class="page-title" style="max-width: 420px;">
				Evaluation
			</div>
		</div>
	</section>
	<section id="content" class="container">
		<div class="row mb-5">
			<div class="col-md-12 js-dynamic-list">
				<center><span data-date="{{ date('m/d/Y') }}" class="prev-arrow js-prev-month"><b>
							<<</b> </span> <span class="font-600 month-heading">{{ date('F - Y') }}</span><span data-date="{{ date('m/d/Y') }}" class="next-arrow js-next-month"> <b>>></b></span></center>
				<table class="swarkul-table mt-3">
					<thead>
						<tr>
							<th scope="col">Student</th>
							<th scope="col">Genre</th>
							<th scope="col">Date</th>
							<th scope="col">Time Slot</th>
							<th scope="col">Grade</th>
							<th scope="col">Status</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
						@if(count($examinerSchedulerinfo) == 0)
						<tr>
							<td colspan="7">
								<div class="card p-3 w-100 text-center"><b>No slot scheduled for evaluation</b></div>
							</td>
						</tr>
						@else
						@foreach($examinerSchedulerinfo as $key => $list)
						<tr>
							<td>
							@if(@$list->student != null)
							{{ @$list->student->name }}<br><small>DOB: {{ date('m/d/Y',strtotime(@$list->student->dob))  }} </small>
							@else
							<div class="badge badge-light p-2">Student Not Assigned</div>
							@endif
						</td>
							<td>{{ @$list->exam_master->genre }}</td>
							<td>{{ date('m/d/Y',strtotime($list->slot->slot_date))  }}</td>
							<td>{{ $list->slot->slot_time_start  }} to {{ $list->slot->slot_time_end  }}</td>
							<?php
							$currentTime = date('Ymdhi');
							$enableTime = date('Ymdhi',strtotime('-'.$evalaution_time_from.'  minutes',strtotime($list->slot->slot_date.' '.$list->slot->slot_time_start)));
							$stopTime = date('Ymdhi',strtotime('+'.$evalaution_time_to.'  minutes',strtotime($list->slot->slot_date.' '.$list->slot->slot_time_end)));
							?>
							<td>@if($list->status == 'Complete')
								<?php $grade = json_decode($list->examEvaluationGrade->status, true);
								$array_mark = array_keys($grade);
								$array_status = array_values($grade);
								$status = '';
								if ($list->examEvaluationGrade->grade  >= 0 && $list->examEvaluationGrade->grade <= $array_mark[0]) {
									$status = $array_status[0];
								} elseif ($list->examEvaluationGrade->grade >= $array_mark[0] && $list->examEvaluationGrade->grade <= $array_mark[1]) {
									$status = $array_status[1];
								} elseif ($list->examEvaluationGrade->grade >= $array_mark[1] && $list->examEvaluationGrade->grade <= $array_mark[2]) {
									$status = $array_status[2];
								} elseif ($list->examEvaluationGrade->grade >= $array_mark[2] && $list->examEvaluationGrade->grade <= $array_mark[3]) {
									$status = $array_status[3];
								}
								?>
								<div><b>{{ $status }}</b></div>
								@else
								<div><b> - </b></div>
								@endif
							</td>
							
							<td>@if($list->status == 'Complete')
								<div class="swarkul-status complete">Completed</div>
								@else
								@if($slotInfo[$key]->slot_date < $currentDate)
									<div class="swarkul-status pending"><font color="red">Over Due</font></div>
								@elseif($slotInfo[$key]->slot_date == $currentDate)
									@if($slotInfo[$key]->slot_time_start < $currentTimeist)
									<div class="swarkul-status pending"><font color="red">Over Due</font></div>
									@else
										<div class="swarkul-status pending">{{ $list->status }}</div>
									@endif
								@else
									@if($list->status == 'Pending')
										<div class="swarkul-status pending">{{ $list->status }}</div>
									@elseif($list->status == 'Inprogress')
										<div class="swarkul-status inprogress">{{ $list->status }}</div>
									@endif
								@endif
								@endif
							</td>
							@if(isset($list->examEvaluationGrade))
								@if($slotInfo[$key]->slot_date < $currentDate)
									<td><div class="badge badge-danger p-2">Contact Site Administrator</div></td>
								@elseif($slotInfo[$key]->slot_date == $currentDate)
									@if($slotInfo[$key]->slot_time_start < $currentTimeist)
									    @if($list->status != 'Complete')
										    <td><div class="badge badge-danger p-2">Contact Site Administrator</div></td>
										@endif
									@else
										<td><a class="btn btn-success" href="{{ url('/examiner-evaluation/view/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode')) }}">View</a></td>
									@endif
								@else
									<td><a class="btn btn-success" href="{{ url('/examiner-evaluation/view/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode')) }}">View</a></td>
								@endif
							@else
							@if($currentTime >= $enableTime && $currentTime <= $stopTime) 
							<td><a class="btn btn-success" href="{{ url('/examiner-evaluation/'.App\Http\Helper\Admin\Helpers::encodeAndDecodeID($list->id,'encode')) }}">Evaluate</a></td>
								@else
								@if($list->status == 'Inprogress')
								<td>
									<div class="badge badge-danger p-2">Contact Site Administrator</div>
								</td>
								@else
								<td>
									<div class="badge badge-danger p-2">Contact Site Administrator</div>
								</td>
								@endif
								@endif
								@endif
						</tr>
						@endforeach
						@endif

					</tbody>
				</table>
			</div>
		</div>
		<div class="row">
			<div class="col-md-12">
				<div class="card bg-light p-3">
					<ul>
						<li>Evaluate button will be enabled {{ $evalaution_time_from }} mins before the slot time</li>
						<li>Once you click on evaluate your timer will be enabled and you have {{ $slot_time }} mins to complete the evaluation</li>
					</ul>
				</div>
			</div>
		</div>

	</section>
	@include('site.layouts.footer')
</body>
@include('site.layouts.CommonJS')
@include('site.layouts.flashMessage')
@stack('script')
@stack('script-function')
<script>
	$(document).on('click', '.js-save-schedule', function() {
		var id = $(this).attr('data-id');
		var url = appUrl + "/schedulerStore";
		var token = $('meta[name=csrf-token]').attr("content");
		$.ajax({
			url: url,
			method: "post",
			data: {
				'id': id,
				'_token': token
			},
			success: function(result) {
				location.reload();
			}
		})
	});

	$(document).on('click', '.js-prev-month', function() {
		var type = -1;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	$(document).on('click', '.js-next-month', function() {
		var type = 0;
		var monthDate = $(this).attr('data-date');
		loadListing(monthDate, type);
	});

	function loadListing(monthDate, type) {
		var url = appUrl + "/getExamEvaluationListing";
		var token = $('meta[name=csrf-token]').attr("content");
		$.ajax({
			url: url,
			method: "post",
			data: {
				'date': monthDate,
				'type': type,
				'_token': token
			},
			success: function(result) {
				$('.js-dynamic-list').html(result);
			}
		})
	}
</script>

</html>