<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    @include('site.layouts.CommonCSS')
    @stack('css')
    @stack('css-inline')
</head>
<body class="bg-full-screen-image">
@include('site.layouts.header')
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Dashboard</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Teacher Management
            </div>
		</div>
    </section>
    <section id="content" class="container">
	<a href="{{ url('teacher-registration') }}" class="btn btn-primary" style="float:right;">Add Teacher</a><br>
		<div class="row">
			<table class="swarkul-table mt-3" id="teacherTable">
					<thead>
						<tr>
							<th scope="col">Code</th>
							<th scope="col">Name</th>
							<th scope="col">email</th>
							<th scope="col">Music Academy</th>
							<th scope="col">Music Stream</th>
							<th scope="col">Is Academy</th>
							<th scope="col">Status</th>
							<th scope="col">Action</th>
						</tr>
					</thead>
					<tbody>
						@if(count($teacherInfo) == 0)
						<tr>
							<td colspan="7">
								<div class="card p-3 w-100 text-center"><b>No slot scheduled for evaluation</b></div>
							</td>
						</tr>
						@else
						@foreach($teacherInfo as $list)
						<tr>
							
							<td>{{ $list->unique_code }}</td>
							<td>{{ $list->academy_name }}</td>
							<td>{{ $list->email }}</td>
							<td>{{ $list->music_academy }}</td>
							<td>{{ $list->music_stream }}</td>
							<td>{{ ($list->is_academy == 1) ? "Yes" : "No" }}</td>
							<td>{{ $list->status }}</td>
							<td><a href="{{ url('admin/teacher',$list->id) }}">Edit</a> | <a href="{{ url('admin/changeStatus/'.$list->id) }}">{{ ($list->status == 'Active') ? "Deactivate" : "Activate" }} </a></td>
							
							
						</tr>
						@endforeach
						@endif

					</tbody>
				</table>
		</div>
		
		
    </section>
    @include('site.layouts.footer')
</body>
    @include('site.layouts.CommonJS')
	@include('site.layouts.flashMessage')
    @stack('script')
    @stack('script-function')
	<script>
	$(document).ready( function () {
		$('#teacherTable').DataTable({
			dom: 'Bfrtip',
			buttons: [
				'excelHtml5',
				'csvHtml5',
				'pdfHtml5'
			]
		});
	} );
	</script>
</html>