<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
    <title>Swarkul | Dashboard</title>

    <!-- Styles -->
    @include('site.layouts.CommonCSS')
    @stack('css')
    @stack('css-inline')
</head>
<body class="bg-full-screen-image">
@include('site.layouts.header')
    <section id="page-header" class="page-contact">
    <div class="container-swarkul">
			<nav aria-label="breadcrumb" class="d-none d-sm-block">
				<ol class="breadcrumb">
					<li class="breadcrumb-item"><a href="/">Home</a></li>
					<li class="breadcrumb-item active" aria-current="page">Edit Teacher</li>
				</ol>
            </nav>
            <div class="page-title" style="max-width: 420px;">
                Edit Teacher
            </div>
		</div>
    </section>
    <section id="content" class="container">
		<div class="row col-md-6">
			{!! Form::model($usersInfo,['url' => url('admin/update'),'id'=>'teacherEditRegister']) !!}
				<input type="hidden" name="id" value="{{ App\Http\Helper\Admin\Helpers::encodeAndDecodeID($usersInfo->id,'encode') }}" />
				@include('site.admin.form')
			{!! Form::close() !!}
		</div>
		
		
    </section>
    @include('site.layouts.footer')
</body>
    @include('site.layouts.CommonJS')
	@include('site.layouts.flashMessage')
    @stack('script')
    @stack('script-function')

</html>