/*****************************************************************************************************
 * @name:       LivIconsEvo.min.js - the main (minified) JS file of LivIcons (Live Icons) Evolution
 * @version:    2.8.XXX (XXX is a total number of icons)
 * @URL:        https://livicons.com
 * @copyright:  (c) 2013-2019 DeeThemes (https://codecanyon.net/user/DeeThemes)
 * @licenses:   https://codecanyon.net/licenses/regular
                https://codecanyon.net/licenses/extended
******************************************************************************************************/
(function(k, H) {
    function Q(b, a) {
        b.css("visibility", "hidden");
        var e = m(b.find("svg")[0]);
        e.attr({
            preserveAspectRatio: "xMinYMin meet"
        });
        var c = e.attr("viewBox").w / 2 + " " + e.attr("viewBox").h / 2;
        e.selectAll("desc").forEach(function(a) {
            "Created with Snap" === a.innerSVG() && k(a.node).text("LivIcons Evolution")
        });
        var f = k(e.node),
            x = e.select("g.lievo-main"),
            h = e.g().addClass("lievo-setrotation");
        e.prepend(h);
        h = h.g().addClass("lievo-setsharp");
        h = h.g().addClass("lievo-setflip");
        h.append(x);
        a.morph ? "end" === a.morphState ?
            (f.find("g.lievo-main g.lievo-morphstartstate").remove(), a.curMorphState = "end") : (f.find("g.lievo-main g.lievo-morphendstate").remove(), a.curMorphState = "start") : a.curMorphState = "not morph";
        switch (a.style) {
            case "solid":
                f.find("g.lievo-main g.lievo-solidicon").siblings(":not(g.lievo-common)").remove();
                break;
            case "lines":
            case "lines-alt":
            case "linesAlt":
                f.find("g.lievo-main g.lievo-lineicon").siblings(":not(g.lievo-common)").remove();
                break;
            default:
                f.find("g.lievo-main g.lievo-filledicon").siblings(":not(g.lievo-common)").remove()
        }
        f =
            x.rect(-19, -19, 4, 4).addClass("lievo-checkshift lievo-donotdraw lievo-nohoverstroke lievo-nohovercolor").attr({
                fill: "none",
                stroke: "#ffffff",
                "stroke-width": 2,
                "stroke-linecap": "butt",
                "stroke-linejoin": "round",
                opacity: 0
            });
        e.attr("data-shift") && ("x" === e.attr("data-shift") ? f.attr("x", -20) : "y" === e.attr("data-shift") ? f.attr("y", -20) : "xy" === e.attr("data-shift") && f.attr({
            x: -20,
            y: -20
        }));
        "solid" === a.style && e.attr("data-solidshift") && ("x" === e.attr("data-solidshift") ? f.attr("x", -19.5) : "y" === e.attr("data-solidshift") ?
            f.attr("y", -19.5) : "xy" === e.attr("data-solidshift") && f.attr({
                x: -19.5,
                y: -19.5
            }));
        if (a.morph && a.morphImage) {
            if (f = e.select(".lievo-morphimage")) {
                var d = e.ptrn(0, 0, "100%", "100%", 0, 0, 0, 0);
                d.node.removeAttribute("viewBox");
                var l = d.attr("patternUnits", "userSpaceOnUse").addClass("lievo-morphpattern").toDefs().g()
            } else a.morphImage = !1;
            f = e.select(".lievo-morphimage").attr("fill");
            l.rect(0, 0, 60, 60).attr({
                fill: f,
                stroke: "#ffffff",
                "stroke-width": 0
            }).addClass("lievo-donotdraw")
        }
        var y = e.selectAll("circle, ellipse, image, line, path, polygon, polyline, rect, text, use");
        y.forEach(function(a) {
            k(a.node).attr("stroke") || a.attr({
                stroke: "none",
                "stroke-width": 0
            });
            k(a.node).attr("fill") || a.attr("fill", "none")
        });
        "round" === a.strokeStyle ? y.forEach(function(a) {
            "none" === a.attr("stroke") || a.hasClass("lievo-savelinecap") || (a.node.setAttribute("stroke-linecap", "round"), a.node.setAttribute("stroke-linejoin", "round"))
        }) : "square" === a.strokeStyle && y.forEach(function(a) {
            "none" === a.attr("stroke") || a.hasClass("lievo-savelinecap") || (a.node.setAttribute("stroke-linecap", "square"), a.node.setAttribute("stroke-linejoin",
                "miter"), a.attr("stroke-miterlimit") || a.attr("stroke-miterlimit", "10"))
        });
        y.forEach(function(a) {
            a.data("initStrokeWidth", a.attr("stroke-width"));
            a.data("initStrokeLinecap", a.attr("stroke-linecap"));
            a.data("initStrokeLinejoin", a.attr("stroke-linejoin"))
        });
        switch (a.style) {
            case "filled":
                y.forEach(function(b) {
                    "none" === b.attr("stroke") || b.hasClass("lievo-savestroke") || b.attr("stroke", a.strokeColor);
                    "none" === b.attr("fill") || b.hasClass("lievo-savefill") || b.attr("fill", a.fillColor);
                    b.hasClass("lievo-likestroke") &&
                        b.attr("fill", a.strokeColor)
                });
                break;
            case "lines":
                y.forEach(function(b) {
                    "none" === b.attr("stroke") || b.hasClass("lievo-savestroke") || b.attr("stroke", a.strokeColor);
                    b.hasClass("lievo-savefill") || b.attr("fill", "none");
                    b.hasClass("lievo-likestroke") && b.attr("fill", a.strokeColor)
                });
                break;
            case "lines-alt":
            case "linesAlt":
                y.forEach(function(b) {
                    b.hasClass("lievo-altstroke") ? ("none" !== b.attr("stroke") && b.attr("stroke", a.strokeColorAlt), b.hasClass("lievo-likestroke") ? b.attr("fill", a.strokeColorAlt) : b.hasClass("lievo-savefill") ||
                        b.attr("fill", "none")) : ("none" === b.attr("stroke") || b.hasClass("lievo-savestroke") || b.attr("stroke", a.strokeColor), b.hasClass("lievo-likestroke") ? b.attr("fill", a.strokeColor) : b.hasClass("lievo-savefill") || b.attr("fill", "none"))
                });
                break;
            case "solid":
                y.forEach(function(b) {
                    b.hasClass("lievo-solidbg") ? ("none" === b.attr("stroke") || b.hasClass("lievo-savestroke") || b.attr("stroke", a.solidColorBg), "none" === b.attr("fill") || b.hasClass("lievo-savefill") || b.attr("fill", a.solidColorBg)) : ("none" === b.attr("stroke") ||
                        b.hasClass("lievo-savestroke") || b.attr("stroke", a.solidColor), "none" === b.attr("fill") || b.hasClass("lievo-savefill") || b.attr("fill", a.solidColor))
                })
        }
        b.css("width", a.size);
        v && b.hasClass("livicon-evo-back-in-combined") && (b.parent(".livicon-evo-combined").css("width", a.size), b.css("width", "100%"));
        a.morph && a.morphImage && (l.image(a.morphImage, 0, 0, "100%", "100%"), d.select("image").attr("preserveAspectRatio", "xMidYMid slice"), e.select(".lievo-morphimage").attr("fill", d));
        var u, F = function() {
            a.scaleStrokeFactor =
                b.width() / 60;
            0 >= a.scaleStrokeFactor && (a.scaleStrokeFactor = 1);
            "original" !== a.strokeWidth ? (y.forEach(function(b) {
                if ("none" !== b.attr("stroke")) {
                    var c = ("" + a.strokeWidth).replace(/[0-9.]/g, ""),
                        E = b.data("initStrokeWidth").replace(/[^0-9.]/g, "") / 2;
                    E *= +("" + a.strokeWidth).replace(/[^0-9.]/g, "") / a.scaleStrokeFactor;
                    b.node.setAttribute("stroke-width", E + c);
                    b.data("curStrokeWidth", E + c)
                }
            }), u = ("" + a.strokeWidth).replace(/[^0-9.]/g, "") / a.scaleStrokeFactor / 2) : a.tryToSharpen && .5 > a.scaleStrokeFactor ? (y.forEach(function(b) {
                if ("none" !==
                    b.attr("stroke")) {
                    var c = b.data("initStrokeWidth").replace(/[0-9.]/g, ""),
                        E = b.data("initStrokeWidth").replace(/[^0-9.]/g, "") / 2;
                    E *= 1 / a.scaleStrokeFactor;
                    b.node.setAttribute("stroke-width", E + c);
                    b.data("curStrokeWidth", E + c)
                }
            }), u = 1 / a.scaleStrokeFactor / 2) : (y.forEach(function(a) {
                "none" !== a.attr("stroke") && a.data("curStrokeWidth", a.data("initStrokeWidth"))
            }), u = e.select(".lievo-checkshift").attr("stroke-width").replace(/[^0-9.]/g, "") / 2);
            (0 === a.strokeWidthFactorOnHover || a.strokeWidthFactorOnHover) && y.forEach(function(b) {
                if ("none" !==
                    b.attr("stroke") && !b.hasClass("lievo-nohoverstroke")) {
                    var c = b.data("curStrokeWidth");
                    if (c) {
                        var d = ("" + c).replace(/[0-9.]/g, "");
                        c = +("" + c.replace(/[^0-9.]/g, "")) * a.strokeWidthFactorOnHover;
                        b.data("hoverStrokeWidth", c + d)
                    }
                }
            })
        };
        F();
        if (a.keepStrokeWidthOnResize) k(window).on("resize", function() {
            F()
        });
        if (a.colorsOnHover) var r = a.colorsOnHover;
        a.morph && a.colorsWhenMorph && (a.colorsOnHover = !1, r = a.colorsWhenMorph);
        y.forEach(function(b) {
            var c = k(b.node).attr("fill");
            b.data("curFill", c);
            b.data("curStroke", b.attr("stroke"));
            b.data("curOpacity", b.attr("opacity"));
            if (r) {
                if ("none" === c) b.data("actionFill", "none");
                else if (c.toLowerCase().match(/url\(/)) b.data("actionFill", c);
                else {
                    if ("lighter" === r) var d = "solid" === a.style && b.hasClass("lievo-solidbg") ? a.solidColorBgAction : J(c, -a.saturation, a.brightness);
                    else if ("darker" === r) d = "solid" === a.style && b.hasClass("lievo-solidbg") ? a.solidColorBgAction : J(c, a.saturation, -a.brightness);
                    else if ("hue" === r.replace(/[^hue]/g, "")) d = "solid" === a.style && b.hasClass("lievo-solidbg") ? a.solidColorBgAction :
                        R(c, r.replace(/[^0-9.]/g, "") ? r.replace(/[^0-9.]/g, "") : 0);
                    else if ("custom" === r) switch (a.style) {
                        case "solid":
                            d = b.hasClass("lievo-solidbg") ? a.solidColorBgAction : a.solidColorAction;
                            break;
                        case "lines":
                            d = a.strokeColorAction;
                            break;
                        case "lines-alt":
                        case "linesAlt":
                            d = b.hasClass("lievo-altstroke") ? a.strokeColorAltAction : a.strokeColorAction;
                            break;
                        default:
                            d = b.hasClass("lievo-likestroke") ? a.strokeColorAction : a.fillColorAction
                    }
                    b.data("actionFill", d)
                }
                if ("none" === b.attr("stroke")) b.data("actionStroke", "none");
                else {
                    if ("lighter" ===
                        r) d = "solid" === a.style && b.hasClass("lievo-solidbg") ? a.solidColorBgAction : J(b.attr("stroke"), -a.saturation, a.brightness);
                    else if ("darker" === r) d = "solid" === a.style && b.hasClass("lievo-solidbg") ? a.solidColorBgAction : J(b.attr("stroke"), a.saturation, -a.brightness);
                    else if ("hue" === r.replace(/[^hue]/g, "")) d = "solid" === a.style && b.hasClass("lievo-solidbg") ? a.solidColorBgAction : R(b.attr("stroke"), r.replace(/[^0-9.]/g, "") ? r.replace(/[^0-9.]/g, "") : 0);
                    else if ("custom" === r) switch (a.style) {
                        case "solid":
                            d = b.hasClass("lievo-solidbg") ?
                                a.solidColorBgAction : a.solidColorAction;
                            break;
                        case "lines":
                            d = a.strokeColorAction;
                            break;
                        case "lines-alt":
                        case "linesAlt":
                            d = b.hasClass("lievo-altstroke") ? a.strokeColorAltAction : a.strokeColorAction;
                            break;
                        default:
                            d = a.strokeColorAction
                    }
                    b.data("actionStroke", d)
                }
            }
        });
        a.rotate && (g.set(e.select("g.lievo-setrotation").node, {
            rotation: a.rotate,
            svgOrigin: c
        }), a.morph && a.morphImage && !a.allowMorphImageTransform && (l = d.select("g"), !a.flipVertical && a.flipHorizontal ? l.transform("r" + a.rotate + ",30,30") : a.flipVertical &&
            !a.flipHorizontal ? l.transform("r" + a.rotate + ",30,30") : l.transform("r" + -a.rotate + ",30,30")));
        a.flipVertical && !a.flipHorizontal ? (e.select("g.lievo-setflip").transform("s1,-1,30,30"), a.morph && a.morphImage && !a.allowMorphImageTransform && d.select("image").transform("s1,-1,30,30")) : a.flipHorizontal && !a.flipVertical ? (e.select("g.lievo-setflip").transform("s-1,1,30,30"), a.morph && a.morphImage && !a.allowMorphImageTransform && d.select("image").transform("s-1,1,30,30")) : a.flipVertical && a.flipHorizontal && (e.select("g.lievo-setflip").transform("s-1,-1,30,30"),
            a.morph && a.morphImage && !a.allowMorphImageTransform && d.select("image").transform("s-1,-1,30,30"));
        a.animated ? (e.attr("data-animoptions") ? (d = JSON.parse(e.attr("data-animoptions").replace(/'/g, '"')), a.defaultDuration = d.duration ? t(d.duration) : 1, a.defaultRepeat = d.repeat ? "loop" === d.repeat ? -1 : t(d.repeat) : 0, a.defaultRepeatDelay = d.repeatDelay ? t(d.repeatDelay) : .5) : (a.defaultDuration = 1, a.defaultRepeat = 0, a.defaultRepeatDelay = .5), a.useDuration = "default" === a.duration ? a.defaultDuration : t(a.duration), isNaN(a.useDuration) &&
            (a.useDuration = 1), a.useRepeat = "default" === a.repeat ? a.defaultRepeat : "loop" === a.repeat ? -1 : t(a.repeat), isNaN(a.useRepeat) && (a.useRepeat = 0), -1 !== a.useRepeat && 0 > a.useRepeat && (a.useRepeat = 0), a.useRepeatDelay = "default" === a.repeatDelay ? a.defaultRepeatDelay : t(a.repeatDelay), isNaN(a.useRepeatDelay) && (a.useRepeatDelay = a.defaultRepeatDelay), 0 >= a.delay && (a.delay = .001), 0 >= a.useRepeatDelay && (a.useRepeatDelay = .001), 0 >= a.drawDelay && (a.drawDelay = .001), 0 >= a.eraseDelay && (a.eraseDelay = .001), a.morph && (a.defaultRepeat =
                0, a.useRepeat = 0, a.defaultRepeatDelay = 0, a.useRepeatDelay = 0)) : (a.defaultDuration = 0, a.defaultRepeat = 0, a.defaultRepeatDelay = 0);
        var p = b.data("drawTL");
        p ? p.pause().kill().clear() : p = new G({
            paused: !0
        });
        var n = b.data("mainTL");
        n ? n.pause().kill().clear() : n = new G({
            paused: !0
        });
        if (a.animated) {
            d = e.selectAll("circle, ellipse, g, image, line, path, polygon, polyline, rect, text, use");
            var A = new G;
            if (a.morph && a.colorsWhenMorph) {
                var w, q, K, z;
                var B = new G;
                d.forEach(function(b) {
                    "end" !== a.morphState ? b.hasClass("lievo-nohovercolor") ||
                        "g" === b.type.toLowerCase() || (w = b.data("actionStroke"), q = b.data("actionFill"), w && "none" !== w && (K = g.to(b.node, a.useDuration, {
                            stroke: w
                        }), B.add(K, 0)), q && "none" !== q && !q.match(/url\(/) && (z = g.to(b.node, a.useDuration, {
                            fill: q
                        }), B.add(z, 0))) : b.hasClass("lievo-nohovercolor") || "g" === b.type.toLowerCase() || (w = b.data("actionStroke"), q = b.data("actionFill"), w && "none" !== w && g.set(b.node, {
                            stroke: w
                        }), q && "none" !== q && !q.match(/url\(/) && g.set(b.node, {
                            fill: q
                        }), w = b.data("curStroke"), q = b.data("curFill"), w && "none" !== w && (K = g.to(b.node,
                            a.useDuration, {
                                stroke: w
                            }), B.add(K, 0)), q && "none" !== q && !q.match(/url\(/) && (z = g.to(b.node, a.useDuration, {
                            fill: q
                        }), B.add(z, 0)))
                })
            }
            d.forEach(function(a) {
                if (a.attr("data-animdata")) {
                    var b = JSON.parse(a.attr("data-animdata").replace(/'/g, '"')),
                        c = new G;
                    b.steps.forEach(function(b) {
                        for (var d in b.vars) b.vars.hasOwnProperty(d) && (b.vars[d] = t(b.vars[d]), "none" !== b.vars[d] && (b.vars[d] = D(b.vars[d])));
                        0 === t(b.duration) && (b.duration = .001);
                        b.vars.ease = "none" !== b.vars.ease && b.vars.ease ? N(b.vars.ease) : S.easeNone;
                        b.vars.path &&
                            (b.vars.morphSVG = b.vars.path);
                        if (b.vars.bezier && b.vars.bezier.values && "string" === typeof b.vars.bezier.values) {
                            d = m.path.toCubic(b.vars.bezier.values).toString();
                            d = d.replace(/[M|m]/g, "").replace(/[C|c]/g, ",");
                            d = d.split(",");
                            b.vars.bezier.values = [];
                            for (var h = 0; h < d.length; h += 2) {
                                var e = {};
                                e.x = d[h];
                                e.y = d[h + 1];
                                b.vars.bezier.values.push(e)
                            }
                        }
                        O || P ? b.vars.drawSVG ? "0%" === b.vars.drawSVG || 0 === b.vars.drawSVG ? (d = g.to(a.node, +b.duration, b.vars), d.eventCallback("onStart", function() {
                            "square" === a.data("initStrokeLinecap").toLowerCase() &&
                                g.set(a.node, {
                                    attr: {
                                        "stroke-linecap": "round"
                                    }
                                });
                            "miter" === a.data("initStrokeLinejoin").toLowerCase() && g.set(a.node, {
                                attr: {
                                    "stroke-linejoin": "round"
                                }
                            })
                        })) : "100%" === b.vars.drawSVG ? (d = g.to(a.node, +b.duration, b.vars), d.eventCallback("onComplete", function() {
                            "square" === a.data("initStrokeLinecap").toLowerCase() && g.set(a.node, {
                                attr: {
                                    "stroke-linecap": "square"
                                }
                            });
                            "miter" === a.data("initStrokeLinejoin").toLowerCase() && g.set(a.node, {
                                attr: {
                                    "stroke-linejoin": "miter"
                                }
                            })
                        })) : d = g.to(a.node, +b.duration, b.vars) : d = g.to(a.node, +b.duration, b.vars) : d = g.to(a.node, +b.duration, b.vars);
                        c.add(d, b.position || "+=0");
                        A.add(c, 0)
                    });
                    a.node.removeAttribute("data-animdata")
                }
            });
            n.add(A, 0);
            A.duration(a.useDuration);
            a.morph && a.colorsWhenMorph && (n.add(B, 0), B.duration(a.useDuration));
            n.delay(a.delay).repeat(a.useRepeat).repeatDelay(a.useRepeatDelay)
        } else e.selectAll("circle, ellipse, g, image, line, path, polygon, polyline, rect, text, use").forEach(function(a) {
            a.node.removeAttribute("data-animdata")
        });
        b.data("drawTL", p);
        b.data("mainTL", n);
        a.eventElement = "self" !== a.eventOn && a.eventOn ? "parent" === a.eventOn ? b.parent() : "grandparent" === a.eventOn ? b.parent().parent() : k(a.eventOn) : b;
        v && b.hasClass("livicon-evo-back-in-combined") && ((d = b.parent(".livicon-evo-combined"), "self" !== a.eventOn && a.eventOn) ? "parent" === a.eventOn ? a.eventElement = d.parent() : "grandparent" === a.eventOn && (a.eventElement = d.parent().parent()) : a.eventElement = d);
        v && b.parent().hasClass("livicon-evo-front-in-combined") && ((d = b.parent(".livicon-evo-front-in-combined"), "self" !== a.eventOn &&
            a.eventOn) ? "parent" === a.eventOn ? a.eventElement = d.parent() : "grandparent" === a.eventOn && (a.eventElement = d.parent().parent()) : a.eventElement = b);
        if (a.animated)
            if (!a.morph)
                if ("click" === a.eventType) a.eventElement.on("click.LiviconEvo", function() {
                    -1 === a.useRepeat ? a.ending ? n.isActive() && n.tweenTo(n.duration(), {
                        onComplete: function() {
                            n.pause().totalProgress(0);
                            "function" === typeof a.afterAnim && a.afterAnim();
                            a.ending = !1
                        }
                    }) : a.drawn && (a.ending = !0, b.playLiviconEvo()) : a.drawn && (b.playLiviconEvo(), a.ending = !1)
                });
                else {
                    if ("hover" ===
                        a.eventType)
                        if (d = function() {
                                a.ending || a.drawn && b.playLiviconEvo()
                            }, l = function() {
                                n.isActive() && (a.ending = !0, n.tweenTo(n.duration(), {
                                    onComplete: function() {
                                        n.pause().totalProgress(0); - 1 === a.useRepeat && "function" === typeof a.afterAnim && a.afterAnim();
                                        a.ending = !1
                                    }
                                }))
                            }, -1 === a.useRepeat) a.eventElement.on("mouseenter.LiviconEvo", d).on("mouseleave.LiviconEvo", l);
                        else a.eventElement.on("mouseenter.LiviconEvo", function() {
                            a.drawn && b.playLiviconEvo()
                        })
                } else if (a.morph)
            if ("click" === a.eventType) a.eventElement.on("click.LiviconEvo",
                function() {
                    a.drawn && b.playLiviconEvo()
                });
            else "hover" === a.eventType && (l = function() {
                a.drawn && n.reverse()
            }, a.eventElement.on("mouseenter.LiviconEvo", function() {
                a.drawn && b.playLiviconEvo()
            }).on("mouseleave.LiviconEvo", l));
        if (a.colorsOnHover) a.eventElement.on("mouseenter.LiviconEvo", function() {
            !p.isActive() && a.drawn && y.forEach(function(b) {
                if (!b.hasClass("lievo-nohovercolor")) {
                    var c = b.data("actionStroke"),
                        d = b.data("actionFill");
                    c && "none" !== c && g.to(b.node, a.colorsHoverTime, {
                        stroke: c
                    });
                    d && "none" !== d && !d.match(/url\(/) &&
                        g.to(b.node, a.colorsHoverTime, {
                            fill: d
                        })
                }
            })
        }).on("mouseleave.LiviconEvo", function() {
            !p.isActive() && a.drawn && y.forEach(function(b) {
                if (!b.hasClass("lievo-nohovercolor")) {
                    var c = b.data("curStroke"),
                        d = b.data("curFill");
                    c && "none" !== c && g.to(b.node, a.colorsHoverTime, {
                        stroke: c
                    });
                    d && "none" !== d && !d.match(/url\(/) && g.to(b.node, a.colorsHoverTime, {
                        fill: d
                    })
                }
            })
        });
        if (0 === a.strokeWidthFactorOnHover || a.strokeWidthFactorOnHover) a.eventElement.on("mouseenter.LiviconEvo", function() {
            !p.isActive() && a.drawn && y.forEach(function(b) {
                if (!b.hasClass("lievo-nohoverstroke")) {
                    var c =
                        b.data("hoverStrokeWidth");
                    c && g.to(b.node, a.strokeWidthOnHoverTime, {
                        attr: {
                            "stroke-width": c
                        }
                    })
                }
            })
        }).on("mouseleave.LiviconEvo", function() {
            !p.isActive() && a.drawn && y.forEach(function(b) {
                if (!b.hasClass("lievo-nohoverstroke")) {
                    var c = b.data("curStrokeWidth");
                    c && g.to(b.node, a.strokeWidthOnHoverTime, {
                        attr: {
                            "stroke-width": c
                        }
                    })
                }
            })
        });
        if (a.touchEvents && (a.animated || a.colorsOnHover || 0 === a.strokeWidthFactorOnHover || a.strokeWidthFactorOnHover)) a.eventElement.on("touchstart.LiviconEvo", function(b) {
            b.preventDefault();
            a.eventElement.trigger("mouseenter.LiviconEvo")
        }).on("touchend.LiviconEvo", function() {
            a.eventElement.trigger("mouseleave.LiviconEvo");
            try {
                a.eventElement[0].click()
            } catch (V) {
                if ("function" === typeof document.createEvent) {
                    var b = document.createEvent("MouseEvents");
                    b.initMouseEvent("click", !0, !0, window, 0, 0, 0, 0, 0, !1, !1, !1, !1, 0, null);
                    a.eventElement.get(0).dispatchEvent(b)
                } else "function" === typeof window.MouseEvent && (b = new MouseEvent("click", {
                    bubbles: !0,
                    cancelable: !0
                }), a.eventElement.get(0).dispatchEvent(b))
            }
        });
        if (d = b.find("svg")[0].getScreenCTM()) l = -d.e % 1, f = -d.f % 1, 0 === l ? l = 0 : -.5 >= l && (l += 1), 0 === f ? f = 0 : -.5 >= f && (f += 1), b.find("svg").css({
            left: l + "px",
            top: f + "px"
        }), a.tryToSharpen && (l = e.select(".lievo-checkshift"), f = e.select(".lievo-morphpattern"), x = m.matrix(), l && (l = l.getBBox(), 0 !== (l.x + u) * d.a % 1 && (g.set(e.select("g.lievo-setsharp").node, {
            x: "+=" + ((l.x - u) * d.a % 1 / d.a || 0),
            svgOrigin: c
        }), x.e = (l.x - u) * d.a % 1 / d.a || 0), 0 !== (l.y + u) * d.d % 1 && (g.set(e.select("g.lievo-setsharp").node, {
                y: "+=" + ((l.y - u) * d.d % 1 / d.d || 0),
                svgOrigin: c
            }), x.f =
            (l.y - u) * d.d % 1 / d.d || 0), f && f.attr("patternTransform", x.toString())));
        if (a.drawOnViewport && !a.drawOnce) {
            c = b.find("svg").get(0).getBoundingClientRect().height;
            switch (a.viewportShift) {
                case "none":
                case !1:
                    var C = 1;
                    break;
                case "one-half":
                case "oneHalf":
                    C = c / 2;
                    break;
                case "one-third":
                case "oneThird":
                    C = c / 3;
                    break;
                case "full":
                    C = c;
                    break;
                default:
                    C = c / 2
            }
            var U = function() {
                if (!a.drawOnce) {
                    var c = k(window).height();
                    C > c && (C = c - 10);
                    T.inViewport(b, -C) && (b.pauseLiviconEvo(), b.drawLiviconEvo(), a.drawOnce = !0)
                }
            };
            U();
            k(window).on("resize scroll",
                function() {
                    U()
                })
        } else b.css("visibility", "visible"), a.drawOnce = !0, a.drawn = !0, a.autoPlay && b.playLiviconEvo()
    }

    function L() {
        return L.counter++
    }

    function M(b) {
        if (null === b || "object" !== typeof b) return b;
        var a = new b.constructor,
            e;
        for (e in b) b.hasOwnProperty(e) && (a[e] = M(b[e]));
        return a
    }

    function D(b) {
        if ("string" === typeof b || b instanceof String) switch (b.toLowerCase()) {
            case "true":
            case "yes":
                return !0;
            case "false":
            case "no":
            case "none":
                return !1;
            default:
                return b
        } else return b
    }

    function t(b) {
        return "string" === typeof b ||
            b instanceof String ? +b || "0" === b ? +b : b : b
    }

    function N(b) {
        var a = b.split(".");
        if (2 === a.length && "SteppedEase" !== a[0]) return v ? window.DeeThemes_GS[a[0]][a[1]] : window[a[0]][a[1]];
        b = b.match(/true|false|(-?\d*\.?\d*(?:e[\-+]?\d+)?)[0-9]/ig).map(JSON.parse);
        return "SteppedEase" !== a[0] ? v ? window.DeeThemes_GS[a[0]][a[1]].config.apply(null, b) : window[a[0]][a[1]].config.apply(null, b) : v ? window.DeeThemes_GS[a[0]].config.apply(null, b) : window[a[0]].config.apply(null, b)
    }

    function J(b, a, e) {
        b = m.color(b);
        b = m.rgb2hsb(b.r, b.g,
            b.b);
        b.s += a;
        0 > b.s && (b.s = 0);
        1 < b.s && (b.s = 1);
        b.b += e;
        0 > b.b && (b.b = 0);
        1 < b.b && (b.b = 1);
        return m.hsb(b.h, b.s, b.b)
    }

    function R(b, a) {
        var e = m.color(b);
        e = m.rgb2hsb(e.r, e.g, e.b);
        a = Math.abs(a) / 360 % 1;
        e.h = (e.h + a) % 1;
        return m.hsb(e.h, e.s, e.b)
    }
    var v = !1,
        g = window.TweenMax,
        G = window.TimelineMax,
        S = window.Power0,
        m = window.Snap,
        T = window.verge;
    window.DeeThemes_GS && window.DeeThemes_Snap && window.DeeThemes_Verge && (v = !0);
    v && (g = window.DeeThemes_GS.TweenMax, G = window.DeeThemes_GS.TimelineMax, S = window.DeeThemes_GS.Power0, m = window.DeeThemes_Snap,
        T = window.DeeThemes_Verge);
    var I = window.LivIconsEvoDefaults(),
        O = "ActiveXObject" in window ? !0 : !1,
        P = navigator.userAgent.match(/Edge\/\d+/) ? !0 : !1;
    I.pathToFolder.match(/(\/)$/) || "" === I.pathToFolder.trim() || (I.pathToFolder += "/");
    k.fn.extend({
        addLiviconEvo: function(b, a) {
            if (2 > arguments.length) var e = b === Object(b) ? b : {};
            else b === Object(b) ? e = b : (e = {}, e[b] = a);
            return this.each(function() {
                var a = k(this),
                    b = a.data("options"),
                    x = a.data("savedOptions"),
                    h = {};
                a.addClass("livicon-evo-holder");
                x && x.eventElement && (x.eventElement.off(".LiviconEvo"),
                    x.eventElement = H);
                b && (b = b.split(";"), b.forEach(function(a) {
                    a = a.trim().split(/:(.+)/);
                    a[0] && a[1] && (h[a[0].trim()] = a[1].trim())
                }));
                h = k.extend(M(I), h, e);
                if (h.name) {
                    h.name.match(/(\.svg)$/) || (h.name += ".svg");
                    for (var d in h) h.hasOwnProperty(d) && (h[d] = t(h[d]), h[d] = D(h[d]));
                    h.name.match(/morph+(-)/) ? h.morph = !0 : h.morph = !1;
                    h.drawOnce = !1;
                    h.drawn = !1;
                    h.ending = !1;
                    a.removeData("savedOptions");
                    a.data("savedOptions", h);
                    "function" === typeof h.beforeAdd && h.beforeAdd();
                    k.ajax({
                        url: h.pathToFolder + h.name,
                        type: "GET",
                        dataType: "text",
                        global: !0,
                        success: function(b) {
                            a.removeClass("livicon-evo-error");
                            var c = b.match(/(id=["'](.*?)["'])/gi);
                            c && c.forEach(function(a) {
                                a = a.replace(/id=["']/i, "").replace(/["']/, "");
                                b = b.replace(new RegExp(a, "g"), a + "_" + L())
                            });
                            b = m.parse(b);
                            c = a.empty().append("<div>").children().addClass("lievo-svg-wrapper");
                            try {
                                c[0].appendChild(b.node)
                            } catch (u) {
                                c.html(b.node)
                            }
                            Q(a, h);
                            "function" === typeof h.afterAdd && h.afterAdd()
                        },
                        error: function(b, c) {
                            a.addClass("livicon-evo-error");
                            0 === b.status && "error" === c ? a.html('<span><acronym title="Please use LivIconsEvo script on a working local or internet connected webserver, it does NOT work directly opened from a HDD.">Network Error</acronym></span>') :
                                404 === b.status && "error" === c ? a.html('<span><acronym title="Please check the &quot;name&quot; option and/or default &quot;pathToFolder&quot; one where all SVG LivIconEvo files are placed.">Not Found</acronym></span>') : a.html('<span><acronym title="There is an unknown error. Please check for messages in Console (F12 key).">Unknown Error</acronym></span>')
                        }
                    })
                } else a.addClass("livicon-evo-error").html('<span><acronym title="Please check the &quot;name&quot; option of your SVG LivIconEvo file.">Name Error</acronym></span>')
            })
        },
        updateLiviconEvo: function(b, a) {
            if (2 > arguments.length) var e = b === Object(b) ? b : {};
            else b === Object(b) ? e = b : (e = {}, e[b] = a);
            return this.each(function() {
                var a = k(this),
                    b = a.data("savedOptions");
                if (b) {
                    b.eventElement && b.eventElement.off(".LiviconEvo");
                    b.eventElement = H;
                    b = M(b);
                    b = k.extend(b, e);
                    b.name.match(/(\.svg)$/) || (b.name += ".svg");
                    for (var x in b) b.hasOwnProperty(x) && (b[x] = t(b[x]), b[x] = D(b[x]));
                    b.name.match(/morph+(-)/) ? b.morph = !0 : b.morph = !1;
                    b.drawOnce = !1;
                    b.drawn = !1;
                    b.ending = !1;
                    a.data("savedOptions", b);
                    "function" ===
                    typeof b.beforeUpdate && b.beforeUpdate();
                    k.ajax({
                        url: b.pathToFolder + b.name,
                        type: "GET",
                        dataType: "text",
                        global: !0,
                        success: function(c) {
                            var d;
                            a.addClass("livicon-evo-holder").removeClass("livicon-evo-error");
                            (d = c.match(/(id=["'](.*?)["'])/gi)) && d.forEach(function(a) {
                                a = a.replace(/id=["']/i, "").replace(/["']/, "");
                                c = c.replace(new RegExp(a, "g"), a + "_" + L())
                            });
                            c = m.parse(c);
                            d = a.empty().append("<div>").children().addClass("lievo-svg-wrapper");
                            try {
                                d[0].appendChild(c.node)
                            } catch (l) {
                                d.html(c.node)
                            }
                            Q(a, b);
                            "function" ===
                            typeof b.afterUpdate && b.afterUpdate()
                        },
                        error: function(b, c) {
                            a.addClass("livicon-evo-error");
                            0 === b.status && "error" === c ? a.html('<span><acronym title="Please use LivIconsEvo script on a working local or internet connected webserver, it does NOT work directly opened from a HDD.">Network Error</acronym></span>') : 404 === b.status && "error" === c ? a.html('<span><acronym title="Please check the &quot;name&quot; option and/or default &quot;pathToFolder&quot; one where all SVG LivIconEvo files are placed.">Not Found</acronym></span>') :
                                a.html('<span><acronym title="There is an unknown error. Please check for messages in Console (F12 key).">Unknown Error</acronym></span>')
                        }
                    })
                } else a.addLiviconEvo(e)
            })
        },
        changeLiviconEvo: function(b, a) {
            if (2 > arguments.length) var e = b === Object(b) ? b : {};
            else b === Object(b) ? e = b : (e = {}, e[b] = a);
            for (var c in e) e.hasOwnProperty(c) && (e[c] = t(e[c]), e[c] = D(e[c]));
            return this.each(function() {
                var a = k(this),
                    b = a.data(),
                    c = b.savedOptions;
                if (c) {
                    var d = b.drawTL;
                    b = b.mainTL;
                    var l = a.find("circle, ellipse, line, path, polygon, polyline, rect");
                    c.eventElement && c.eventElement.off(".LiviconEvo");
                    c.eventElement = H;
                    c = M(c);
                    c = k.extend(c, e);
                    d.pause().totalProgress(0).clear();
                    b.pause().totalProgress(0);
                    c.drawn = !0;
                    c.drawOnViewport = !1 === e.drawOnViewport ? !1 : !0;
                    a.eraseLiviconEvo(c);
                    var g = setTimeout(function() {
                        a.updateLiviconEvo(c);
                        clearTimeout(g)
                    }, 1E3 * (c.eraseDelay + c.eraseTime + c.eraseStagger * l.length))
                } else a.addLiviconEvo(e)
            })
        },
        drawLiviconEvo: function(b, a, e) {
            if (1 >= arguments.length)
                if (b === Object(b)) var c = b;
                else c = {}, c.force = b;
            else 2 === arguments.length ?
                b === Object(b) ? (c = b, c.force = a) : (c = {}, c[b] = a, c.force || (c.force = !1)) : (c = {}, c[b] = a, c.force = e);
            for (var f in c) c.hasOwnProperty(f) && (c[f] = t(c[f]), c[f] = D(c[f]));
            return this.each(function() {
                var a = k(this),
                    b = a.data(),
                    d = b.savedOptions;
                if (d) {
                    var e = b.drawTL,
                        f = b.mainTL;
                    b = 0 === c.drawDelay || c.drawDelay ? c.drawDelay : d.drawDelay;
                    var u = 0 === c.drawTime || c.drawTime ? c.drawTime : d.drawTime,
                        F = 0 === c.drawStagger || c.drawStagger ? c.drawStagger : d.drawStagger,
                        r = c.drawStartPoint ? c.drawStartPoint : d.drawStartPoint,
                        p = c.drawColor ? c.drawColor :
                        d.drawColor,
                        n = 0 === c.drawColorTime || c.drawColorTime ? c.drawColorTime : d.drawColorTime,
                        A = c.drawEase ? c.drawEase : d.drawEase,
                        w = c.beforeDraw ? c.beforeDraw : d.beforeDraw,
                        q = c.afterDraw ? c.afterDraw : d.afterDraw,
                        t = c.duringDraw ? c.duringDraw : d.duringDraw,
                        z = "undefined" !== typeof c.drawReversed ? c.drawReversed : d.drawReversed,
                        B = a.find("circle, ellipse, line, path, polygon, polyline, rect").not(".lievo-morphpattern").not(".lievo-donotdraw").not(".lievo-nohovercolor").get();
                    e.eventCallback("onStart", null);
                    e.eventCallback("onComplete",
                        null);
                    e.eventCallback("onUpdate", null);
                    0 >= b && (b = .001);
                    0 >= u && (u = .001);
                    D(c.force) && (e.clear(), e.pause().totalProgress(0), f.pause().totalProgress(0), d.drawn = !1);
                    if (!e.isActive() && !f.isActive() && !d.drawn) {
                        z && B.reverse();
                        if (d.morph && d.colorsWhenMorph) {
                            m(a.find("svg")[0]).selectAll("circle, ellipse, image, line, path, polygon, polyline, rect, text, use").forEach(function(a) {
                                a.data("curFill", k(a.node).attr("fill"));
                                a.data("curStroke", a.attr("stroke"));
                                a.data("curOpacity", a.attr("opacity"))
                            });
                            var C = m(a.find("svg")[0]).select(".lievo-checkshift");
                            C = C.data("actionStroke")
                        }
                        f = function() {
                            var a = m(this.target);
                            if (O || P) "square" === a.data("initStrokeLinecap").toLowerCase() && g.set(this.target, {
                                attr: {
                                    "stroke-linecap": "round"
                                }
                            }), "miter" === a.data("initStrokeLinejoin").toLowerCase() && g.set(this.target, {
                                attr: {
                                    "stroke-linejoin": "round"
                                }
                            });
                            "same" !== p ? (g.set(this.target, {
                                strokeOpacity: 1,
                                stroke: p
                            }), "none" === a.data("curStroke") && a.attr({
                                "stroke-width": 1 / d.scaleStrokeFactor
                            })) : (g.set(this.target, {
                                strokeOpacity: 1
                            }), "none" === a.data("curStroke") && a.attr({
                                "stroke-width": 1 /
                                    d.scaleStrokeFactor,
                                stroke: a.data("curFill")
                            }), "solid" === d.style && a.hasClass("lievo-solidbg") && (d.morph && d.colorsWhenMorph && "end" === d.morphState ? C ? a.attr({
                                stroke: C
                            }) : a.attr({
                                stroke: d.solidColorAction
                            }) : a.attr({
                                stroke: d.solidColor
                            })))
                        };
                        z = function() {
                            var a = m(this.target);
                            if (O || P) "square" === a.data("initStrokeLinecap").toLowerCase() && g.set(this.target, {
                                attr: {
                                    "stroke-linecap": "square"
                                }
                            }), "miter" === a.data("initStrokeLinejoin").toLowerCase() && g.set(this.target, {
                                attr: {
                                    "stroke-linejoin": "miter"
                                }
                            });
                            g.to(this.target,
                                n, {
                                    stroke: a.data("curStroke"),
                                    fillOpacity: 1
                                })
                        };
                        var v = function() {
                            d.drawn = !0
                        };
                        e.clear();
                        "function" === typeof w && e.eventCallback("onStart", w);
                        "function" === typeof t && e.eventCallback("onUpdate", t);
                        e.eventCallback("onComplete", function() {
                            "function" === typeof q && q();
                            d.autoPlay && a.playLiviconEvo()
                        });
                        e.delay(b);
                        g.set(B, {
                            strokeOpacity: 0,
                            fillOpacity: 0
                        });
                        a.css("visibility", "visible");
                        "string" === typeof A && (A = N(A));
                        switch (r) {
                            case "middle":
                                g.set(B, {
                                    drawSVG: "0% 100%"
                                });
                                e.staggerFrom(B, u, {
                                    drawSVG: "50% 50%",
                                    ease: A,
                                    onStart: f,
                                    onComplete: z
                                }, F, 0, v);
                                break;
                            case "end":
                                e.staggerFromTo(B, u, {
                                    drawSVG: "100% 100%"
                                }, {
                                    drawSVG: "0% 100%",
                                    ease: A,
                                    onStart: f,
                                    onComplete: z
                                }, F, 0, v);
                                break;
                            default:
                                e.staggerFromTo(B, u, {
                                    drawSVG: "0% 0%"
                                }, {
                                    drawSVG: "0% 100%",
                                    ease: A,
                                    onStart: f,
                                    onComplete: z
                                }, F, 0, v)
                        }
                        e.restart(!0)
                    }
                } else c.drawOnViewport = !0, a.addLiviconEvo(c)
            })
        },
        eraseLiviconEvo: function(b, a, e) {
            if (1 >= arguments.length)
                if (b === Object(b)) var c = b;
                else c = {}, c.force = b;
            else 2 === arguments.length ? b === Object(b) ? (c = b, c.force = a) : (c = {}, c[b] = a, c.force || (c.force = !1)) : (c = {}, c[b] = a, c.force = e);
            for (var f in c) c.hasOwnProperty(f) && (c[f] = t(c[f]), c[f] = D(c[f]));
            return this.each(function() {
                var a = k(this),
                    b = a.data(),
                    d = b.savedOptions;
                if (d) {
                    var e = b.drawTL,
                        f = b.mainTL;
                    b = 0 === c.eraseDelay || c.eraseDelay ? c.eraseDelay : d.eraseDelay;
                    var u = 0 === c.eraseTime || c.eraseTime ? c.eraseTime : d.eraseTime,
                        t = 0 === c.eraseStagger || c.eraseStagger ? c.eraseStagger : d.eraseStagger,
                        r = c.eraseStartPoint ? c.eraseStartPoint : d.eraseStartPoint,
                        p = c.eraseEase ? c.eraseEase : d.eraseEase,
                        n = c.beforeErase ? c.beforeErase : d.beforeErase,
                        A = c.afterErase ? c.afterErase : d.afterErase,
                        w = c.duringErase ? c.duringErase : d.duringErase,
                        q = "undefined" !== typeof c.eraseReversed ? c.eraseReversed : d.eraseReversed,
                        v = a.find("circle, ellipse, line, path, polygon, polyline, rect").not(".lievo-donotdraw").not(".lievo-nohovercolor").get();
                    0 >= b && (b = .001);
                    e.eventCallback("onStart", null);
                    e.eventCallback("onComplete", null);
                    e.eventCallback("onUpdate", null);
                    D(c.force) && (e.clear(), e.pause().totalProgress(0), f.pause().totalProgress(0), d.drawn = !0);
                    if (!e.isActive() && !f.isActive() &&
                        d.drawn) {
                        q && v.reverse();
                        d.morph && d.colorsWhenMorph && m(a.find("svg")[0]).selectAll("circle, ellipse, image, line, path, polygon, polyline, rect, text, use").forEach(function(a) {
                            a.data("curFill", k(a.node).attr("fill"));
                            a.data("curStroke", a.attr("stroke"));
                            a.data("curOpacity", a.attr("opacity"))
                        });
                        f = function() {
                            "none" === m(this.target).data("curStroke") && m(this.target).attr({
                                "stroke-width": 1 / d.scaleStrokeFactor,
                                stroke: m(this.target).data("curFill")
                            });
                            g.to(this.target, u, {
                                fillOpacity: 0
                            })
                        };
                        q = function() {
                            g.set(this.target, {
                                strokeOpacity: 0,
                                fillOpacity: 0
                            });
                            "none" === m(this.target).data("curStroke") && g.set(this.target, {
                                "stroke-width": 0,
                                stroke: "none"
                            })
                        };
                        var z = function() {
                            d.drawn = !1
                        };
                        e.clear();
                        "function" === typeof n && e.eventCallback("onStart", n);
                        "function" === typeof A && e.eventCallback("onComplete", A);
                        "function" === typeof w && e.eventCallback("onUpdate", w);
                        "string" === typeof p && (p = N(p));
                        e.delay(b);
                        g.set(v, {
                            strokeOpacity: 1,
                            fillOpacity: 1
                        });
                        a.css("visibility", "visible");
                        switch (r) {
                            case "middle":
                                e.staggerFromTo(v, u, {
                                    drawSVG: "0% 100%"
                                }, {
                                    drawSVG: "50% 50%",
                                    ease: p,
                                    onStart: f,
                                    onComplete: q
                                }, t, 0, z);
                                break;
                            case "end":
                                e.staggerFromTo(v, u, {
                                    drawSVG: "0% 100%"
                                }, {
                                    drawSVG: "100% 100%",
                                    ease: p,
                                    onStart: f,
                                    onComplete: q
                                }, t, 0, z);
                                break;
                            default:
                                e.staggerFromTo(v, u, {
                                    drawSVG: "0% 100%"
                                }, {
                                    drawSVG: 0,
                                    ease: p,
                                    onStart: f,
                                    onComplete: q
                                }, t, 0, z)
                        }
                        e.restart(!0)
                    }
                } else a.addLiviconEvo(c)
            })
        },
        playLiviconEvo: function(b, a, e) {
            if (1 >= arguments.length)
                if (b === Object(b)) var c = b;
                else c = {}, c.force = b;
            else 2 === arguments.length ? b === Object(b) ? (c = b, c.force = a) : (c = {}, c[b] = a, c.force || (c.force = !1)) : (c = {}, c[b] = a, c.force = e);
            for (var f in c) c.hasOwnProperty(f) && (c[f] = t(c[f]), c[f] = D(c[f]));
            return this.each(function() {
                var a = k(this),
                    b = a.data(),
                    d = b.savedOptions;
                if (d) {
                    a = b.drawTL;
                    b = b.mainTL;
                    var e = 0 === c.duration || c.duration ? c.duration : d.duration,
                        f = 0 === c.delay || c.delay ? c.delay : d.delay,
                        g = 0 === c.repeat || c.repeat ? c.repeat : d.repeat,
                        m = 0 === c.repeatDelay || c.repeatDelay ? c.repeatDelay : d.repeatDelay,
                        r = c.beforeAnim ? c.beforeAnim : d.beforeAnim,
                        p = c.afterAnim ? c.afterAnim : d.afterAnim,
                        n = c.duringAnim ? c.duringAnim : d.duringAnim;
                    if (d.animated) {
                        D(c.force) && (a.pause().totalProgress(1), b.pause().totalProgress(0), d.drawn = !0);
                        "default" === e && (e = d.defaultDuration);
                        var t = b.getChildren(!1, !1, !0);
                        t.forEach(function(a) {
                            a.duration(e)
                        });
                        0 >= f && (f = .001);
                        b.delay(f);
                        "default" === g ? g = d.defaultRepeat : "loop" === g && (g = -1);
                        "default" === m && (m = d.defaultRepeatDelay);
                        0 >= m && (m = .001);
                        d.morph ? (b.repeat(0).repeatDelay(0), "function" === typeof r && b.eventCallback("onStart", r), "function" === typeof n && b.eventCallback("onUpdate", n), b.eventCallback("onComplete",
                            function() {
                                d.curMorphState = "end" === d.morphState ? "start" : "end";
                                "function" === typeof p && p()
                            }), b.eventCallback("onReverseComplete", function() {
                            d.curMorphState = "end" === d.morphState ? "end" : "start";
                            "function" === typeof p && p()
                        }), a.isActive() || b.isActive() || !d.drawn || (a = b.progress(), 0 === a ? b.restart(!0) : b.paused() && 0 < a && 1 > a ? b.resume() : b.pause().reverse(0))) : (b.repeat(g).repeatDelay(m), "function" === typeof r && b.eventCallback("onStart", r), "function" === typeof p && -1 !== g && b.eventCallback("onComplete", p), "function" ===
                            typeof n && b.eventCallback("onUpdate", n), a.isActive() || b.isActive() || !d.drawn || (a = b.totalProgress(), b.paused() && 0 < a && 1 > a ? b.resume() : (b.restart(!0), d.ending = !0)))
                    }
                } else a.addLiviconEvo(c)
            })
        },
        stopLiviconEvo: function() {
            return this.each(function() {
                var b = k(this),
                    a = b.data(),
                    e = a.savedOptions;
                e ? (b = a.mainTL, e.morph ? b.pause().progress(0) : (b.pause().totalProgress(0), e.ending = !1)) : b.addLiviconEvo()
            })
        },
        pauseLiviconEvo: function() {
            return this.each(function() {
                var b = k(this).data("mainTL");
                b && b.pause()
            })
        },
        resumeLiviconEvo: function() {
            return this.each(function() {
                var b =
                    k(this).data("mainTL");
                b && b.resume()
            })
        },
        removeLiviconEvo: function(b, a, e) {
            if (1 >= arguments.length)
                if (b === Object(b)) var c = b;
                else c = {}, c.total = b;
            else 2 === arguments.length ? b === Object(b) ? (c = b, c.total = a) : (c = {}, c[b] = a, c.total || (c.total = !1)) : (c = {}, c[b] = a, c.total = e);
            return this.each(function() {
                var a = k(this),
                    b = a.data("savedOptions");
                if (b) {
                    var e = c.beforeRemove ? c.beforeRemove : b.beforeRemove,
                        d = c.afterRemove ? c.afterRemove : b.afterRemove;
                    b.eventElement && b.eventElement.off(".LiviconEvo");
                    b.eventElement = H;
                    "function" ===
                    typeof e && e();
                    a.removeData("savedOptions drawTL mainTL");
                    D(c.total) ? a.remove() : a.empty();
                    "function" === typeof d && d()
                }
            })
        },
        liviconEvoState: function(b) {
            if (0 === arguments.length) return k(this).data("savedOptions").curMorphState;
            if (1 <= arguments.length) return this.each(function() {
                var a = k(this).data("savedOptions"),
                    e = k(this).data("mainTL");
                "start" === b.toLowerCase() ? e && a.morph && ("end" === a.morphState ? e.pause().progress(1) : e.pause().progress(0), a.curMorphState = "start") : "end" === b.toLowerCase() && e && a.morph && ("end" ===
                    a.morphState ? e.pause().progress(0) : e.pause().progress(1), a.curMorphState = "end")
            })
        },
        liviconEvoOptions: function() {
            var b = k(this).data("savedOptions");
            if (b) {
                var a = {};
                a.afterAdd = b.afterAdd;
                a.afterAnim = b.afterAnim;
                a.afterDraw = b.afterDraw;
                a.afterErase = b.afterErase;
                a.afterRemove = b.afterRemove;
                a.afterUpdate = b.afterUpdate;
                a.allowMorphImageTransform = b.allowMorphImageTransform;
                a.animated = b.animated;
                a.autoPlay = b.autoPlay;
                a.beforeAdd = b.beforeAdd;
                a.beforeAnim = b.beforeAnim;
                a.beforeDraw = b.beforeDraw;
                a.beforeErase =
                    b.beforeErase;
                a.beforeRemove = b.beforeRemove;
                a.beforeUpdate = b.beforeUpdate;
                a.brightness = b.brightness;
                a.colorsHoverTime = b.colorsHoverTime;
                a.colorsOnHover = !1 === b.colorsOnHover ? "none" : b.colorsOnHover;
                a.colorsWhenMorph = !1 === b.colorsWhenMorph ? "none" : b.colorsWhenMorph;
                a.delay = .001 === b.delay ? 0 : b.delay;
                a.drawColor = b.drawColor;
                a.drawColorTime = b.drawColorTime;
                a.drawDelay = .001 === b.drawDelay ? 0 : b.drawDelay;
                a.drawEase = b.drawEase;
                a.drawOnViewport = b.drawOnViewport;
                a.drawReversed = b.drawReversed;
                a.drawStagger = b.drawStagger;
                a.drawStartPoint = b.drawStartPoint;
                a.drawTime = b.drawTime;
                a.duration = b.duration;
                a.duringAnim = b.duringAnim;
                a.duringDraw = b.duringDraw;
                a.duringErase = b.duringErase;
                a.eraseDelay = .001 === b.eraseDelay ? 0 : b.eraseDelay;
                a.eraseEase = b.eraseEase;
                a.eraseReversed = b.eraseReversed;
                a.eraseStagger = b.eraseStagger;
                a.eraseStartPoint = b.eraseStartPoint;
                a.eraseTime = b.eraseTime;
                a.eventOn = b.eventOn;
                a.eventType = !1 === b.eventType ? "none" : b.eventType;
                a.fillColor = b.fillColor;
                a.fillColorAction = b.fillColorAction;
                a.flipHorizontal = b.flipHorizontal;
                a.flipVertical = b.flipVertical;
                a.keepStrokeWidthOnResize = b.keepStrokeWidthOnResize;
                a.morphImage = !1 === b.morphImage ? "none" : b.morphImage;
                a.morphState = b.morphState;
                a.name = b.name;
                a.pathToFolder = b.pathToFolder;
                a.repeat = b.repeat;
                a.repeatDelay = b.repeatDelay;
                a.rotate = !1 === b.rotate ? "none" : b.rotate;
                a.saturation = b.saturation;
                a.size = b.size;
                a.solidColor = b.solidColor;
                a.solidColorAction = b.solidColorAction;
                a.solidColorBg = b.solidColorBg;
                a.solidColorBgAction = b.solidColorBgAction;
                a.strokeColor = b.strokeColor;
                a.strokeColorAction =
                    b.strokeColorAction;
                a.strokeColorAlt = b.strokeColorAlt;
                a.strokeColorAltAction = b.strokeColorAltAction;
                a.strokeStyle = b.strokeStyle;
                a.strokeWidth = b.strokeWidth;
                a.strokeWidthFactorOnHover = !1 === b.strokeWidthFactorOnHover ? "none" : b.strokeWidthFactorOnHover;
                a.strokeWidthOnHoverTime = b.strokeWidthOnHoverTime;
                a.style = b.style;
                a.touchEvents = b.touchEvents;
                a.tryToSharpen = b.tryToSharpen;
                a.viewportShift = !1 === b.viewportShift ? "none" : b.viewportShift;
                a.defaultDuration = b.defaultDuration;
                a.defaultRepeat = b.defaultRepeat;
                a.defaultRepeatDelay = b.defaultRepeatDelay;
                return a
            }
            return H
        }
    });
    k(document).ready(function() {
        k(".livicon-evo").addLiviconEvo()
    });
    k(window).on("orientationchange", function() {
        k(window).resize()
    });
    L.counter = 1
})(window.jQuery);