<?php

namespace App\Http\Helper\Admin;
use App\Http\Helper\Admin\EncryptIdAlgorithm as EncryptIdAlgorithm;
use Request;
use Auth;
use Log;
use App\Models\ExamMaster;
use App\Models\ExamEvaluation;

class Helpers {
	public static $data = [];
    public static function handleSiderActive($Page = ''){
		$currentPage = Request::segment(3);
		switch(true){
			case ($currentPage == $Page):
				return 'active';
				break;
		}
	}
	
	public static function encodeAndDecodeID($id, $type = 'encode') {
		
        $encode_decode_alg = 'base64_alg';
        return EncryptIdAlgorithm::$encode_decode_alg($id, $type);
    }

	public static function checkModulePermission($mainModule = '',$subModule = '',$icon = ''){
		if(Auth::user()->role_type != 'Admin'){
			$path = storage_path('permission');
			$fileName = Auth::user()->id.'.json';
			$data = file_get_contents($path.'/'.$fileName);
			$data = json_decode($data,true);
			$module = json_decode($data['module'],true);
			//echo "<pre>";print_r($module);die;
			if(!empty($mainModule) && !empty($subModule) && !empty($icon)){
				if(isset($module[$mainModule]) && isset($module[$mainModule][$subModule]) && isset($module[$mainModule][$subModule][$icon])){
					return true;
				}else{
					return false;
				}
			}elseif(!empty($mainModule) && !empty($subModule)){
				if(isset($module[$mainModule]) && isset($module[$mainModule][$subModule])){
					return true;
				}else{
					return false;
				}
			}elseif(!empty($mainModule)){
				if(isset($module[$mainModule])){
					return true;
				}else{
					return false;
				}
			}
		}else{
			return true;
		}
	}
	
	public static function getEvaluationCategory($examMasterId = '',$partentId = '', $i = 0, $examSchdulerId = ''){
		if($partentId == 0)
			$categoryInfo = ExamMaster::where('id',$examMasterId)->where('parent_exam_id',$partentId)->get();
		else
			$categoryInfo = ExamMaster::where('parent_exam_id',$partentId)->get();
			
		foreach($categoryInfo as $list){
			$count = Self::getChildCount($list->id);
			$examEvaluation = ExamEvaluation::where('exam_shedule_id',$examSchdulerId)->where('exam_id',$list->id)->get()->first();
			if($count > 0) {
				$i = $i + 3;
				
				Self::$data[] = '<tr style="border-bottom: 1px solid #aaa;"><td style="padding-left:'.$i.'0px; "><b>'.$list->category.'</b></td><td data-parent="'.$list->parent_exam_id.'" class="js-category-mark">'.$list->category_total_marks.'</td><td><input type="number" name="mark" data-field="mark" data-save="'.$list->id.'" data-child="'.$list->id.'" max='.$list->category_total_marks.' value="'.(isset($examEvaluation->marks) ? $examEvaluation->marks : '' ).'" data-parent="'.$list->parent_exam_id.'" class="form-control js-parent js-mark js-dynamic-change" id="mark" maxlength="3" style="width: 100px;"><span class="js-mark-err" style="color:red;display:none">Invalid mark</span></td><td><textarea data-save="'.$list->id.'"  type="text"  data-field="note"  name="note" class="form-control js-notes js-dynamic-change" id="note">'.(isset($examEvaluation->note) ? $examEvaluation->note : '').'</textarea></td></tr>';
			}else{
				$i = $i + 3;
							
				Self::$data[] = '<tr><td style="padding-left:'.$i.'0px;">'.$list->category.'</td><td data-parent="'.$list->parent_exam_id.'" class="js-category-mark">'.$list->category_total_marks.'</td><td><input data-field="mark" type="number" name="mark" data-save="'.$list->id.'" data-parent="'.$list->parent_exam_id.'" value="'.(isset($examEvaluation->marks) ? $examEvaluation->marks : '' ).'" class="form-control js-child js-mark" max='.$list->category_total_marks.' id="mark" maxlength="3" style="width: 100px;"><span class="js-mark-err" style="color:red;display:none">Invalid mark</span></td><td><textarea type="text" data-field="note"  name="note" data-save="'.$list->id.'" class="form-control js-notes js-dynamic-change" id="note">'.(isset($examEvaluation->note) ? $examEvaluation->note : '').'</textarea></td></tr>';

			}
					
			Self::getEvaluationCategory('',$list->id, $i, $examSchdulerId);
			$i = $i - 3;
		}
		return Self::$data;
	}
	
	public static function getEvaluationCategoryView($examMasterId = '',$partentId = '', $i = 0, $examSchdulerId = ''){
		if($partentId == 0)
			$categoryInfo = ExamMaster::where('id',$examMasterId)->where('parent_exam_id',$partentId)->get();
		else
			$categoryInfo = ExamMaster::where('parent_exam_id',$partentId)->get();
		foreach($categoryInfo as $list){
		
			$count = Self::getChildCount($list->id);
			$examEvaluation = ExamEvaluation::where('exam_shedule_id',$examSchdulerId)->where('exam_id',$list->id)->get()->first();
			if($count > 0) {
				$i = $i + 3;
				
				Self::$data[] = '<tr style="border-bottom: 1px solid #aaa;"><td style="padding-left:'.$i.'0px; "><b>'.$list->category.'</b></td><td class="js-category-mark">'.$list->category_total_marks.'</td><td><input type="number" name="mark" data-save="'.$list->id.'" data-child="'.$list->id.'" max='.$list->category_total_marks.' data-parent="'.$list->parent_exam_id.'" class="form-control js-parent js-mark" id="mark" value="'.$examEvaluation->marks.'" maxlength="3" style="width: 100px;"><span class="js-mark-err" style="color:red;display:none">Invalid mark</span></td><td><textarea data-save="'.$list->id.'"  type="text"  name="note"  class="form-control js-notes" id="note">'.$examEvaluation->note.'</textarea></td></tr>';
			}else{
				$i = $i + 3;
							
				Self::$data[] = '<tr><td style="padding-left:'.$i.'0px;">'.$list->category.'</td><td class="js-category-mark">'.$list->category_total_marks.'</td><td><input type="number" name="mark" data-save="'.$list->id.'" data-parent="'.$list->parent_exam_id.'" class="form-control js-child js-mark" value="'.$examEvaluation->marks.'" max='.$list->category_total_marks.' id="mark" maxlength="3" style="width: 100px;"><span class="js-mark-err" style="color:red;display:none">Invalid mark</span></td><td><textarea type="text"  name="note" data-save="'.$list->id.'" class="form-control js-notes"  id="note">'.$examEvaluation->note.'</textarea></td></tr>';

			}
					
			Self::getEvaluationCategoryView('',$list->id, $i, $examSchdulerId);
			$i = $i - 3;
		}
		return Self::$data;
	}
	
	public static function getChildCount($partentId){
		return $childCount = ExamMaster::where('parent_exam_id',$partentId)->count();
	}
}