<?php

namespace App\Http\Controllers\Site;
use App\Http\Controllers\Controller as Controller;
use Request;
use Auth;
use App\Models\Slots;
use App\Http\Helper\Admin\Helpers;
use App\Models\ExamScheduler;
use App\Models\ExamEvaluation;
use App\Models\ExamEvaluationGrade;
use App\Models\Configurations;
use App\Mail\CommonEmail;
use App\Models\Users;
use App\Models\Token;
use Mail;
use GuzzleHttp\Client;
use Session;

class ExaminerController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
	public $loadingDate ='';
	public $dateCount ='';
	
    public function __construct()
    {
        $this->loadingDate = date('m/d/y');
        $this->dateCount = 0;
    }

   
    public function index()
    {
		
		$examinerScheduler = ExamScheduler::pluck('slot_id')->toArray();
		$slotCount = Slots::whereNotIn('id',$examinerScheduler)->where('status','Active')->count();
		$schedulerCount = ExamScheduler::where('examiner_id',Auth::user()->id)->where('examiner_id',Auth::user()->id)->whereIn('status',['Pending','Inprogress'])->count();
        return view('site/examiner/examiner_landing',compact('slotCount','schedulerCount'));
    }
	
	public function examiner_scheduler(){
		//$examinerScheduler = ExamScheduler::where('examiner_id','!=',Auth::user()->id)->pluck('slot_id')->toArray();
		$examinerScheduler = ExamScheduler::where('examiner_id',Auth::user()->id)->pluck('slot_id')->toArray();
		$slotInfo = Slots::where('status','Active')->get();
		//dd(Auth::user()->id);
		return view('site/examiner/examiner_scheduler',compact('slotInfo','examinerScheduler'));
	}
	
	public function schedulerStore(){
		$request = Request::all();
		$data['slot_id'] = $request['id'];
		$data['examiner_id'] = Auth::user()->id;
		$data['created_by'] = Auth::user()->id;
		$schedule = ExamScheduler::create($data);
		Session::put('slot_id',$data['slot_id']);
		Session::put('schedule_id',$schedule->id);
		return response()->json(['status' => true]);
		// $schedulerInfo = ExamScheduler::where('slot_id',$request['id'])->count();
		// if($schedulerInfo == 0){
		// 	$data['created_by'] = Auth::user()->id;
		// 	ExamScheduler::create($data);
		// }else{
		// 	ExamScheduler::where('slot_id',$request['id'])->update($data);
		// }
	}

	public function zoomCreate(){
	    
	 	$users = Users::find(Auth::user()->id);
		$redirect = env('APP_URL').'zoom-metting';
		return redirect('https://zoom.us/oauth/authorize?response_type=code&client_id='.$users->client_id."&redirect_uri=".$redirect);
	}

	public function zoomMetting(){
		$users = Users::find(Auth::user()->id);
        $redirect = env('APP_URL').'zoom-metting';
        
		try {
    		$client = new \GuzzleHttp\Client(['base_uri' => 'https://zoom.us']);
 
		    $response = $client->request('POST', '/oauth/token', [
		        "headers" => [
		            "Authorization" => "Basic ". base64_encode($users->client_id.':'.$users->secret_id)
		        ],
		        'form_params' => [
		            "grant_type" => "authorization_code",
		            "code" => $_GET['code'],
		            "redirect_uri" => $redirect
		        ],
		    ]);
			 
		    $token = json_decode($response->getBody()->getContents(), true);
		 
		 
		    $tokenModel = new Token();
		    
		    if($tokenModel->is_table_empty(Session::get('schedule_id'))) {
		        $tokenModel->update_access_token(json_encode($token),Session::get('schedule_id'));
		       
		    }

			} catch(Exception $e) {
			    
			    echo $e->getMessage();
			}
		

		$client = new \GuzzleHttp\Client(['base_uri' => 'https://api.zoom.us']);
    
	    $accessToken = $tokenModel->get_access_token(Session::get('schedule_id'));
	   	
	   	$token = json_decode($accessToken->access_token)->access_token;
        
	   	$slots = Slots::find(\Session::get('slot_id'));
	   	
   	   	$password = \Str::random(9);
	   	
	    try {
	        $response = $client->request('POST', '/v2/users/me/meetings', [
	            "headers" => [
	                "Authorization" => "Bearer $token"
	            ],
	            'json' => [
	                "topic" => "Swarkul",
	                "type" => 2,
	                "start_time" => $slots->slot_date.'T'.$slots->slot_time_start.':00',
	                "duration" => "60",
	                "password" => $password
	            ],
	        ]);
	 
	        $data = json_decode($response->getBody());
	        
            ExamScheduler::where('id',\Session::get('schedule_id'))->update(['zoom_url' => $data->join_url, 'zoom_password' => $data->password, 'meetingId' => "$data->id"]);
            Session::forget('schedule_id');
            Session::forget('slot_id');
            return redirect('examiner-scheduler');
	        

	    }catch(Exception $e) {
	        if( 401 == $e->getCode() ) {
	 
	            $client = new GuzzleHttp\Client(['base_uri' => 'https://zoom.us']);
	            $response = $client->request('POST', '/oauth/token', [
	                "headers" => [
	                    "Authorization" => "Basic ". base64_encode($users->client_id.':'.$users->secret_id)
	                ],
	                'form_params' => [
	                    "grant_type" => "refresh_token",
	                    "refresh_token" => json_decode($accessToken->access_token)->refresh_token
	                ],
	            ]);
	            
	            $tokenModel->update_access_token($response->getBody(),Session::get('schedule_id'));
	            return redirect('https://apjtek.in/zoom-create');
	        } else {
	            echo $e->getMessage();
	        }
	    }
	}
	
	public function schedulerCancel(){
		$request = Request::all();
	    $schedule =	 ExamScheduler::where('slot_id',$request['id'])->where('examiner_id',Auth::user()->id)->first();
	    Session::put('scheduleId',$schedule->id);
	    Session::put('mettingId',$schedule->meetingId);
	    ExamScheduler::where('slot_id',$request['id'])->where('examiner_id',Auth::user()->id)->delete();
	}
	
	public function deleteMetting(){
	    
	    
        $client = new \GuzzleHttp\Client(['base_uri' => 'https://api.zoom.us']);
        $tokenModel = new Token();
        
        $accessToken = $tokenModel->get_access_token(Session::get('scheduleId'));
        
	   	$token = json_decode($accessToken->access_token)->access_token;
        $meetingId = Session::get('mettingId');
        
        $response = $client->request('DELETE', "/v2/meetings/{$meetingId}", [
            "headers" => [
                "Authorization" => "Bearer $token"
            ]
        ]);
        Session::forget('scheduleId');
        Session::forget('mettingId');
        
        return redirect('examiner-scheduler');
        
	}

	
	public function examiner_evaluation(){
		
		$examinerScheduler = ExamScheduler::where('examiner_id',Auth::user()->id)->pluck('slot_id')->toArray();
		$slotInfo = Slots::with('evaluation')->whereIn('id',$examinerScheduler)->where('status','Active')->get();
		
		$currentDate = Date('Y-m-d');
		$currentTimeist = date("H:i");

		$slot_info = Configurations::where('configuration_name','slot_time')->get()->first();
		$evalaution_info = Configurations::where('configuration_name','evaluation_button_enable_from')->get()->first();
		$evalaution_toinfo = Configurations::where('configuration_name','evaluation_button_enable_to')->get()->first();
		$slot_time = $slot_info->configuration_value;
		$evalaution_time_from = $evalaution_info->configuration_value;
		$evalaution_time_to = $evalaution_toinfo->configuration_value;
		$date = date('m/d/Y');
		$first_day_this_month = date('Y-m-01',strtotime($date));
		$last_day_this_month  = date('Y-m-t',strtotime($date));
		
		$examinerSchedulerinfo = ExamScheduler::where('examiner_id',Auth::user()->id)->whereHas('slot', function($q) use($first_day_this_month,$last_day_this_month){
									$q->whereRaw("DATE(slot_date) >= '$first_day_this_month' and DATE(slot_date) <= '$last_day_this_month'");
								})->with('exam_master','student','slot','examEvaluationGrade')->get();
		return view('site/examiner/examiner_evaluation',compact('slotInfo','examinerScheduler','examinerSchedulerinfo','slot_time','evalaution_time_from','evalaution_time_to','currentDate','currentTimeist'));
	}
	
	public function getExamEvaluationListing(){
		$request = Request::all();
		$date = date('m/d/Y',strtotime($request['date']));
		$type = $request['type'];
		if($type == 0){
			$first_day_this_month = date('Y-m-01', strtotime("+1 month",strtotime($date)));
			$last_day_this_month  = date('Y-m-t',strtotime("+1 month",strtotime($date)));
			$date = date('F - Y',strtotime("+1 month",strtotime($date)));
		}else{
			$first_day_this_month = date('Y-m-01', strtotime("-1 month",strtotime($date)));
			$last_day_this_month  = date('Y-m-t',strtotime("-1 month",strtotime($date)));
			$date = date('F - Y',strtotime("-1 month",strtotime($date)));
		}
		$evalaution_info = Configurations::where('configuration_name','evaluation_button_enable_from')->get()->first();
		$evalaution_toinfo = Configurations::where('configuration_name','evaluation_button_enable_to')->get()->first();
		$evalaution_time_from = $evalaution_info->configuration_value;
		$evalaution_time_to = $evalaution_toinfo->configuration_value;
		$examinerScheduler = ExamScheduler::where('examiner_id',Auth::user()->id)->pluck('slot_id')->toArray();
		$slotInfo = Slots::with('evaluation')->whereIn('id',$examinerScheduler)->where('status','Active')->get();
		$examinerSchedulerinfo = ExamScheduler::where('examiner_id',Auth::user()->id)->whereHas('slot', function($q) use($first_day_this_month,$last_day_this_month){
									$q->whereRaw("DATE(slot_date) >= '$first_day_this_month' and DATE(slot_date) <= '$last_day_this_month'");
								})->with('exam_master','student','slot','examEvaluationGrade')->get();
		return view('site/examiner/examiner_evaluation_ajax',compact('slotInfo','examinerScheduler','examinerSchedulerinfo','date','evalaution_time_from','evalaution_time_to'));
	}
	
	
	public function examiner_evaluation2($id){
		$id = Helpers::encodeAndDecodeID($id,'decode');
		ExamScheduler::where('id',$id)->update(['status'=>'Inprogress']);
		$examinerScheduler = ExamScheduler::with('exam_master','student','examEvaluationGrade')->where('id',$id)->get()->first();
		$slot_info = Configurations::where('configuration_name','slot_time')->get()->first();
		$slot_time = $slot_info->configuration_value;
		return view('site/examiner/examiner_evaluation_2',compact('id','examinerScheduler','slot_time'));
	}
	
	public function examiner_evaluation2_view($id){
		$id = Helpers::encodeAndDecodeID($id,'decode');
		$examinerScheduler = ExamScheduler::with('exam_master','student','examEvaluationGrade')->where('id',$id)->get()->first();
		return view('site/examiner/examiner_evaluation_2_view',compact('id','examinerScheduler'));
	}
	
	public function evaluationStore(){
		$request = Request::all();
		$exam_scheduler_id = $request['exam_scheduler_id'];
		
		$evalaution_info = Configurations::where('configuration_name','evaluation_grading')->get()->first();
		$status = $evalaution_info->configuration_value;
		$dataArr = [];
		foreach($request['data'] as $key => $value){
			$data['exam_id'] = $key;
			$temp = explode('~~',$value);
			$data['marks'] = $temp[0];
			$data['note'] = $temp[1];
			$data['exam_shedule_id'] = $exam_scheduler_id;
			$data['status'] = 'Active';
			
			$examInfo = ExamEvaluation::where('exam_shedule_id',$exam_scheduler_id)->where('exam_id',$key)->count();
			if($examInfo == 0){
				$data['created_by'] = Auth::user()->id;
				ExamEvaluation::create($data);
			}else{
				ExamEvaluation::where('exam_shedule_id',$exam_scheduler_id)->where('exam_id',$key)->update($data);
			}
		}
		if(isset($request['grade']) && isset($request['mark']) && isset($request['final_note'])){
			$gradeArr['exam_shedule_id'] = $exam_scheduler_id;
			$gradeArr['final_comment'] = $request['final_note'];
			$gradeArr['grade'] = $request['grade'];
			$gradeArr['marks'] = $request['mark'];
			$gradeArr['status'] = $status;
			
			$examGradeInfo = ExamEvaluationGrade::where('exam_shedule_id',$exam_scheduler_id)->count();
			if($examGradeInfo == 0){
				$gradeArr['created_by'] = Auth::user()->id;
				ExamEvaluationGrade::create($gradeArr);
				ExamScheduler::where('id',$exam_scheduler_id)->update(['status'=>'Complete']);
				$grade = json_decode($status, true);
				$array_mark = array_keys($grade);
				$array_status = array_values($grade);
				if ($request['grade']  >= 0 && $request['grade'] <= $array_mark[0]) {
					$status = $array_status[0];
				} elseif ($request['grade'] >= $array_mark[0] && $request['grade'] <= $array_mark[1]) {
					$status = $array_status[1];
				} elseif ($request['grade'] >= $array_mark[1] && $request['grade'] <= $array_mark[2]) {
					$status = $array_status[2];
				} elseif ($request['grade'] >= $array_mark[2] && $request['grade'] <= $array_mark[3]) {
					$status = $array_status[3];
				}
				
				$examSchedulerInfo = ExamScheduler::where('id',$exam_scheduler_id)->get()->first();
				$studentInfo = Users::where('id',$examSchedulerInfo->student_id)->get()->first();
				$email = $studentInfo->email;
				$data['from'] = 'sivakumaraa@gmail.com';
				$data['replayTo'] = 'sivakumaraa@gmail.com';
				$data['subject'] = 'Your ICIMP certification result';
				$data['message'] = 'Dear '.$studentInfo->name.'<br>Congratulations!<br>You have successfully passed ICIMP certification for You have passed the exam with following grade - '.$gradeArr['grade'].'<br>You can now login to your profile for detailed evaluation.<br>You can download your temporary certificate PDF online.<br>We will send you hard copy of your ICIMP certificate on your registered address within 15 days.<br>for any questions please contact - <br>'.$email.'<br>'.$examSchedulerInfo->phone.'<br>Thanks & Regards,<br>Team ICIMP<br>www.icimp.com<br>www.swarkul.com';
				$template = 'evaluation';
				Mail::to($email)->send(new CommonEmail($template,$data));
			}else{
				ExamEvaluationGrade::where('exam_shedule_id',$exam_scheduler_id)->update($gradeArr);
			}
		}
	}
    
}
