<?php

namespace App\Http\Controllers\Site\Admin;
use App\Http\Controllers\Controller as Controller;
use Request;
use App\Http\Helper\Admin\Helpers;
use Auth;
use DB;
use App\Models\Users;
use App\Models\Academy;
use App\Models\Country;
use Hash;

class DashboardController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        
    }

   
    public function index()
    {
		
        return view('site/admin/dashboard');
	}
	public function teacherMgmt()
    {
		$teacherInfo = Academy::whereNull('deleted_at')->where('role_type','Academy')->get();
	
        return view('site/admin/teachermanagement',compact('teacherInfo'));
    }

	public function changeStatus($id)
    {
		$teacherInfo = Academy::where('id',$id)->get()->first();
		if($teacherInfo->status == 'Active')
			$status = 'Inactive';
		else
			$status = 'Active';
		Academy::where('id',$id)->update(['status'=>$status]);
		return redirect('admin/teacher-management')->with('success','Successfully changed teacher status');
    }
    
	public function edit($id)
    {
	//	$id = Helpers::encodeAndDecodeID($id,'decode');
		$usersInfo = Academy::where('id',$id)->get()->first();
		$country = Country::whereNull('deleted_at')->pluck('name','id')->toArray();
		return view('site/admin/teacherEdit',compact('usersInfo','country'));
	}
	
	public function update(){
		DB::beginTransaction();
		try{
			$request = Request::all();
			$id = Helpers::encodeAndDecodeID($request['id'],'decode');
			unset($request['_token']);
			unset($request['confirm_password']);
			unset($request['id']);
			if(isset($request['password']))
				$request['password'] = Hash::make($request['password']);
			Academy::where('id',$id)->update($request);
			DB::commit();
			return redirect('admin/dashboard')->with('success','Successfully updated');
		} catch(Exception $e) {
			DB::rollback();
			return redirect('admin/dashboard')->with('success','Something went wrong');
		}
		
	}
	
}
