<?php
#**************************************************************************
#  openSIS is a free student information system for public and non-public 
#  schools from Open Solutions for Education, Inc. web: www.os4ed.com
#
#  openSIS is  web-based, open source, and comes packed with features that 
#  include student demographic info, scheduling, grade book, attendance, 
#  report cards, eligibility, transcripts, parent portal, 
#  student portal and more.   
#
#  Visit the openSIS web site at http://www.opensis.com to learn more.
#  If you have question regarding this system or the license, please send 
#  an email to info@os4ed.com.
#
#  This program is released under the terms of the GNU General Public License as  
#  published by the Free Software Foundation, version 2 of the License. 
#  See license.txt.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#***************************************************************************************
include('RedirectRootInc.php'); 
include 'Warehouse.php';
$url=validateQueryString(curPageURL());
if($url===FALSE)
 {
 header('Location: index.php');
 }
// DEFAULT
if(User('PROFILE')=='admin')
	$help['default'] = '<p><strong>openSIS Dashboard</strong></p><p>The Dashboard is your default home page and provides access to important alerts when you log in to the application. The openSIS dashboard shows all recent calendar event information, portal notes and alerts for teachers that have missing attendance. When you login for the first time it will be a blank screen. It will fill up as and when you add day-today records in your instance of the software. As an administrator, you can setup the schools in this system, modify students and users, and access essential student reports.</p><p>You have access to any school in the system.  To choose a school to work on, select the school from the pull-down menu on the top.  The program will automatically refresh with the new school in the workspace. You can also change the school year and current marking period in a similar fashion.</p><p>You can also quickly access a Student\'s Demographic Information from the Student\'s tab.</p><p>Similarly to access a User\'s Information click on the User tab.</p><p>When you click on any of the tabs in the top menu, you will see a list of sub-menus available to you in that category.  Clicking on any menu will launch the specific page in the main frame, and it will update the help frame to display help for that section.</p><p>In many places in openSIS, you will see data that are modifiable.  You will have to first click the value you want to change to have access to an input field.  Then, when you change the value and save, the value will return to its previous state.</p><p>You can logout of openSIS at any time by clicking the "Logout" link at the top right of your workspace.</p>';
elseif(User('PROFILE')=='teacher')
	$help['default'] = '<p> The Dashboard is your default home page and provides access to important alerts when you log in to the application. The openSIS dashboard shows all recent calendar event information, portal notes and alerts for teachers that have missing attendance. When you login for the first time it will be a blank screen. It will fill up as and when you add day-today records in your instance of the software. As a teacher, you can view student information and schedules for students who you teach and input attendance, grades, and eligibility for these students. You can keep track of students\' grades from the Grades tab.  From this tab, not only can you keep track of grades, but you can print progress reports for any of your students.</p><p>To choose a period to work on, select the period from the pull-down menu on the top.  The program will automatically refresh with the new period in the workspace. You can also change the school year and current marking period in a similar fashion.</p><p> You can also quickly access a Student\'s Demographic Information from the Student\'s tab.</p><p> When you click on any of the tabs in the top menu, you will see a list of sub-menus available to you in that category.  Clicking on any menu will launch the specific page in the main frame, and it will update the help frame to display help for that section.</p><p>In many places in openSIS, you will see data that are modifiable.  You will have to first click the value you want to change to have access to an input field.  Then, when you change the value and save, the value will return to its previous state.</p><p>You can logout of openSIS at any time by clicking the "Logout" link at the top right of your workspace.</p>';
elseif(User('PROFILE')=='parent')
	$help['default'] = '<p> The Dashboard is your default home page and provides access to important alerts when you log in to the application. The openSIS dashboard shows all recent calendar event information, portal notes and alerts for teachers that have missing attendance. When you login for the first time it will be a blank screen. It will fill up as and when you add day-today records in your instance of the software. As a parent, you can view your children\'s information, schedules, grades, eligibility, and attendance.</p><p>To choose a child, select the child\'s name from the pull-down menu on the top.  The program will automatically refresh with the new child in the workspace. You can also change the school year and current marking period in a similar fashion.</p><p> When you click on any of the tabs in the top menu, you will see a list of sub-menus available to you in that category.  Clicking on any menu will launch the specific page in the main frame, and it will update the help frame to display help for that section.</p><p>In many places in openSIS, you will see data that are modifiable.  You will have to first click the value you want to change to have access to an input field.  Then, when you change the value and save, the value will return to its previous state.</p><p>You can logout of openSIS at any time by clicking the "Logout" link at the top right of your workspace.</p>';
elseif(User('PROFILE')=='student')
{
	$help['default'] = '<p>The Dashboard is your default home page and provides access to important alerts when you log in to the application. The openSIS dashboard shows all recent calendar event information and portal notes. When you login for the first time it will be a blank screen. It will fill up as and when new portal notes and events are added in your instance of the software. As a student, you can view your demographic information, schedule, grades, eligibility, and attendance records.</p><p>You can change the school year and current marking period with the pull-down menus in the left frame to view records for that specific period.</p><p> When you click on any of the tabs in the top menu, you will see a list of sub-menus available to you in that category.  Clicking on any menu will launch the specific page in the main frame, and it will update the help frame to display help for that page.</p><p>You can logout of openSIS at any time by clicking the "Logout" link at the top right of your workspace.</p>';
	$_openSIS['User'][1]['PROFILE'] = 'parent';
	$student = true;
}
// SCHOOL SETUP ---
if(User('PROFILE')=='admin')
{
            $help['School_Setup/PortalNotes.php'] = '<p><strong>Portal Notes</strong></p><p>This page allows you to add Notes to the system. Notes help to keep users of the system informed about any new developments in the School. You can choose the time period for which the specific note will be visible to users. You can also specify which users can view the same. <p>To modify a note, click on any of the note\'s information, change the value, and click the "Save" button.</p><p>To delete an note, click the delete icon (-) next to the note you want to delete.  You will be asked to confirm the deletion.</p>';
            $help['School_Setup/Schools.php'] = '<p><strong>School Information</strong></p><p>The automated installer creates a default school during installation. Once logged in, you can update the existing information with your School\'s Information viz. change the name, address, and principal of the current school from this page.</p><p>To edit and change the default school information, simply click on the existing text and it will become an editable text input field. Enter the updated information and click Update. You also have the option to delete the school. However you cannot delete a school if you have existing students enrolled in that school.</p>';
            $help['School_Setup/Schools.php?new_school=true'] = '<p><strong>Add a School</strong></p><p>This page allows you to add a school to the system.  Complete the school\'s information, and hit the "Save" button.</p><p>To switch to the new school you just added, change the school pull-down menu on the top from your current school to the new one.</p>';
            $help['School_Setup/CopySchool.php'] = '<p><strong>Copy School</strong></p><p>This page lets you make a copy of your existing school. The data copied includes School Periods, Marking Periods, Report Card Grade Codes, Report Card Comment Codes, Eligibility Activity Codes, Attendance Codes and Grade Levels.</p>';
            $help['School_Setup/UploadLogo.php']='<p><strong>Upload School Logo</strong></p><p>This tab allows you to Upload your School Logo in openSIS. The logo you add will show up in all the reports that you can print from the system. Eg : Report Card, Transcripts, Advanced Report, Schedule Report and so on.</p><p>First you need to save your school\'s logo somewhere in your computer, then click on Upload School Logo option, then select the file, finally click on Upload and you schools\' logo is added in openSIS.</p>';
            $help['School_Setup/SystemPreference.php'] = '<p><strong>System Preference</strong></p><p>This page has five different options. The entire tab allows you to set the system as per your preference.</p>';
            $help['School_Setup/SystemPreference.php?page_display=SystemPreference']= '<p><strong>Set half-day and full-day minutes</strong></p><p>This option allows you to set the half day and full day minutes. You can change the minutes as per your requirement on click and then click on save. </p>';
            $help['School_Setup/SystemPreference.php?page_display=FAILURE']= '<p><strong>Set Log in Failure allowance count</strong></p><p>This option allows you to set the log in failure allowance count. That means how many times a user can give incorrect password after that the a/c would be locked. Only an administrator can unlock the a/c. If you don\'t want to set such count you can also make it disable. </p>';
            $help['School_Setup/SystemPreference.php?page_display=INACTIVITY']='<p><strong>Set Allowable User Inactivity Days</strong></p><p>This option allows you to set up allowable user inactivity days. If a user doesn’t log in to the system for 30 days the a/c would be locked. Only an administrator can unlock the a/c. If you want you can set it up or make disabled.</p>';
            $help['School_Setup/SystemPreference.php?page_display=MAINTENANCE']='<p><strong>Put System in Maintenance Mode</strong></p><p>This option allows the administrator to type any important notice while system maintenance is going on. Admin doesn\'t want any user to log in to the system at that time. The notice he types will show up on the log in screen. None of the users would be able to log in to the system.</p>';
            $help['School_Setup/SystemPreference.php?page_display=CURRENCY']='<p><strong>Set Currency</strong></p><p>This option allows you to set the currency as per your requirement. You can choose any currency you want and then click on save.</p>';
            $help['School_Setup/MarkingPeriods.php'] = '<p><strong>Marking Periods</strong></p><p>The Marking Periods page is where you setup your school\'s marking periods for a school year. There are four default tiers of marking periods added during the installation: Year, Semesters, Quarters, and Progress periods. openSIS installation scripts create 2 Semesters and 4 Quarters by default. However you can always have more or fewer as required by your school. Similarly, there can be any number of progress periods in a given quarter. </p><p>To add a marking period, click on the Add button (+) in the column corresponding to the type of marking period you want to add. Then, complete the marking period\'s information in the fields above the list of marking periods and click the "Save" button. </p><p>To edit a marking period, click on the marking period you want to change, and click on whatever value you want to change. It will automatically become editable. Update the value and click the "Save" button. </p><p>To delete a marking period, select it by clicking on its title on the list and click the "Delete" button at the top of the screen. You will be asked to confirm the deletion. </p><p>Note: You cannot delete a marking period if it has students assigned to periods in that marking period. </p><p>Notice that neither two marking periods nor two posting periods in the same tier can overlap dates.</p>';
            $help['School_Setup/Calendar.php'] = '<p><strong>School Calendar</strong></p><p>This page allows you to setup your school\'s calendar for the year.  The calendar displays the current month by default. The month and year displayed can be changed by changing the month and year pull-down menus at the top of the screen and clicking the "Update" button.</p><p>On full school days, the checkbox in the upper right-hand corner of the day\'s square should be checked.  For partial days, the checkbox should be unchecked and the number of minutes school will be in attendance should be entered into the text box next to the checkbox.  For days on which there will be no school, the checkbox should be unchecked and the text field should be blank. To uncheck the checkbox or change the number of minutes in the school day, you must first click on the value you want to change. After making any changes to the calendar, click the "Update" button at the top of the screen.</p><p>To setup your calendar at the beginning of the year, you should use the "Create this year\'s calendar" feature.  By clicking on this link in the upper right-hand corner of the screen, you can setup all days in a specified timeframe as meeting all day.  You can also select which days of the week that your school is in session.  After selecting the beginning and ending dates of your school\'s school year and the day\'s of the week that your school meets, click the "OK" button. You can now go through the calendar and mark holidays and partial days.</p><p>The calendar is also a display of school events. This can include everything from teacher in-service days to sporting events.  These events are visible by other administrators as well as parents and teachers at your school.</p><p>To add a school event, click on the add icon (+) in the lower left-hand corner of the event\'s date.  In the popup window that appears, enter the event\'s information and click the "Save" button.  The popup window will close, and the calendar will be automatically refreshed to display the added event.</p><p>To modify an event, click on the event you want to modify, and change the event\'s information in the popup window that appears after clicking on the values you want to change.  Click the "Save" button.  The window will close and the calendar will automatically refresh to display the change.</p>';
            $help['School_Setup/Periods.php'] = '<p><strong>School Periods</strong></p><p>This page allows you to setup your school\'s individual class periods. The openSIS installation script creates a group of default periods. Update these periods to match yours and delete the extra periods created during installation if necessary. </p><p>Middle and high schools will likely have multiple periods in a school day, where elementary schools may have only one period (called All Day) or perhaps three (All Day, Morning, and Afternoon). If required, you can add new periods very easily. To add a period, fill in the period\'s title, short name, sort order, and length in minutes in the empty fields at the bottom of the periods list and click the "Save" button. </p><p>To modify a period, click on any of the period\'s information, change the value, and click the "Save" button. To delete a period, click the delete icon (X) next to the period you want to delete. You will be asked to confirm the deletion.</p>';
            $help['School_Setup/GradeLevels.php'] = '<p><strong>School Grade Levels</strong></p><p> This page allows you to setup your school\'s grade levels. By default the openSIS installer creates all the grades from Kindergarten to the 8th Grade. If your school has a different grade level structure, simply delete the extra Grade Levels. Similarly if you have some grades that have not been created, create them on this page. </p><p>To add a grade level, fill in the grade level\'s title, short name, sort order, and next grade in the empty fields at the bottom of the grade levels list and click the "Save" button. The "Next Grade" field indicates the grade students in the current grade will proceed to in the next school year. </p><p>To modify a grade level, click on any of the grade level\'s information, change the value, and click the "Save" button. To delete a grade level, click the delete icon (X) next to the grade level you want to delete. You will be asked to confirm the deletion.</p>';
            $help['School_Setup/Rollover.php'] = '<p><strong>Rollover School</strong></p><p>The Rollover page copies the current year\'s data to the next school year.  Students are enrolled in the next grade, and each school\'s information is duplicated for the next school year.</p><p>The data copied include periods, marking periods, users, courses, student enrollment, report card grade codes, enrollment codes, attendance codes, and eligibility activities.</p>';
            $help['School_Setup/Courses.php']='<p><strong>Course Manager</strong></p><p>This page allows you to create subjects, courses and course periods. By clicking on the + sign or Add a subject you can create any number of subjects you want to. After you create the subject select that and then you will get the option to create courses under that particular subject. After you finish creating courses you will get an option to create course periods under a particular course. Here you have to give the Short Name, Teacher, Grading scale, Marking period etc and click on save. After you schedule students under that course periods you won’t be able to delete that course.</p>';
            $help['School_Setup/CourseCatalog.php']='<p><strong>Course Catalog</strong></p><p>This option gives you the entire details of the course manager like a chart. Here you will get all the information about the subjects, Courses, Marking Periods, Time, Period, days when that course is taught, location(room no) and the teacher teaching that course. In this page you have options to choose from dropdowns. There are two options through which you can search. Select Marking period and Select Subject. After you complete the search it gives you an option to take a print out of all the details.</p>';
            $help['School_Setup/PrintCatalog.php']='<p><strong>Print Catalog By Term</strong></p><p>This option gives you the course catalog by term. You will get the dropdown to select the term and you can take the print out of it.</p>';
            $help['School_Setup/PrintAllCourses.php']='<p><strong>Print All Courses</strong></p><p>This option allows you to take a print out of all courses. Here you will get all the required details of subject, courses and course period.</p>';
            $help['School_Setup']=$help['School_Setup/Calendar.php'];
}

else
{
            $help['School_Setup/Schools.php'] = '<p><strong>School Information</strong></p><p> displays the name, address, and principal of the current school.</p>';
            $help['School_Setup/Calendar.php'] = '<p><strong>School Calendar</strong></p><p>The Calendar is a display of school events and your student\'s assignments.  The calendar also displays whether or not school is in attendance on any given day.  By default, the calendar displays the current month.  The month and year displayed can be changed by changing the month and year pull-down menus at the top of the screen and clicking the "Update" button.</p><p>The titles of school events and assignments are displayed in each date\'s box.  Clicking on these titles will open a popup window that displays more information about the event or assignment. School assignments are preceded by a red dot and assignments are preceded by a blue dot.</p><p>For days that school is in attendance all day, a green checkmark appears in the upper right-hand corner of the date.  On partial days, the number of minutes that school is in session is displayed here instead. If the school is not in attendance at all on any given day, nothing will appear in the upper right-hand corner of the date.</p>';
            $help['School_Setup/MarkingPeriods.php'] = '<p><strong>Marking Periods</strong></p><p>The Marking Periods page is where you setup your school\'s marking periods for a school year. There are four default tiers of marking periods added during the installation: Year, Semesters, Quarters, and Progress periods. openSIS installation scripts create 2 Semesters and 4 Quarters by default. However you can always have more or fewer as required by your school. Similarly, there can be any number of progress periods in a given quarter. </p><p>To add a marking period, click on the Add button (+) in the column corresponding to the type of marking period you want to add. Then, complete the marking period\'s information in the fields above the list of marking periods and click the "Save" button. </p><p>To edit a marking period, click on the marking period you want to change, and click on whatever value you want to change. It will automatically become editable. Update the value and click the "Save" button. </p><p>To delete a marking period, select it by clicking on its title on the list and click the "Delete" button at the top of the screen. You will be asked to confirm the deletion. </p><p>Note: You cannot delete a marking period if it has students assigned to periods in that marking period. </p><p>Notice that neither two marking periods nor two posting periods in the same tier can overlap dates.</p>';
            $help['School_Setup']=$help['School_Setup/Calendar.php'];
}

// STUDENTS ---
if(User('PROFILE')=='admin')
{
            $help['Students/Student.php'] = '<p><strong>Student Information</strong></p><p>This option gives you all the necessary details of a particular student. After clicking on this tab when you click on submit you will get the list of all the students. You can select a specific student and will get the details of that student. </p>';
            $help['Students/Student.php?include=GeneralInfoInc?student_id=new'] = '<p><strong>Add Student</strong></p><p>By clicking on this option you will get an empty form where you need to fill up all the required details then click on save and the details would be saved. Only the * marked fields are mandatory. You get an option to upload a student’s photo here. Here you get the general info, address and contact details, Medical details, comments and goals (if any) of that specific student. </p>';
            $help['Students/Student.php?include=GeneralInfoInc'] = "<p><strong>General Information</strong></p><p>General Information is a display of a student's fundamental information. This includes birth date, social security number, ethnicity, gender, birthplace, and grade.</p>";
            $help['Students/Student.php?include=Address'] = "<p><strong>Address &amp; Contacts</strong></p><p> is a display of a student's address and contact information.</p><p> A student must have one addresses and two mandatory emergency contacts.</p>";
            $help['Students/Student.php?include=Medical'] = "<p><strong>Medical</strong></p><p>The \"Medical\" tab displays a  student\'s medical information.</p><p>This includes the student\'s physician, the physician\'s phone, the student\'s preferred hospital, any medical comments, whether or not the student has a doctor's note, and comments concerning the doctor's note.  To change any of these values, click on the value you want to change, change it, and click the \"Save\" button at the top of the screen.</p><p>You can also add entries for each immunization or physical received by the student as well as any medical alerts such as allergies or illnesses.</p><p>To add an immunization, physical, or medical alert, fill in the blank fields at the bottom of the appropriate list, and click the \"Save\" button at the top of the screen.</p><p>To change an immunization, physical, or medical alert, click on the value you want to change, change it, and click the \"Save\" button at the top of the screen.</p><p>To delete an immunization, physical, or medical alert, click on the delete icon (-) next to the item you want to delete.  You will be asked to confirm your deletion.</p>";
            $help['Students/Student.php?include=Enrollment'] = '<p><strong>Enrollment</strong></p><p>The "Enrollment" page can be used to enroll or drop a student from any school. A student can have only one active enrollment record at any time.</p><p>To drop a student, change the "Dropped" date and reason to the effective date of the student\'s drop as well as the reason for his drop. Click the "Save" button at the top of the screen.</p><p>Now you can re-enroll the student.  To do this, select the effective date of the student\'s enrollment and the reason for his enrollment from the blank line at the bottom of the list.  Also, select the school at which the student should be enrolled and click the "Save" button at the top of the screen.</p><p>The enrollment and drop dates and reasons can be modified by clicking on the values, changing them to the desired value, and clicking the "Save" button at the top of the screen.</p>';
            $help['Students/AssignOtherInfo.php'] = '<p><strong>Group Assign Student Info</strong></p><p>This option allows you to change any details of a student. You can change any detail you want to in groups. Like you can select a bunch of students in one go and change any information. The change will show up in the student info page. After clicking on this option you can perform search by First, Last name, Grade, Activity etc then you will get a page where at the top from a drop down box you can select All categories, General info, Medical. Then you will have the text boxes, choose and type information as per your requirement. Then at the bottom of the page select the students by ticking in the check boxes beside and click on save. Now that information is changed for a group of a student.</p>';
            $help['Students/AddUsers.php'] = '<p><strong>Associate Parents with Students</strong></p><p>This option allows you to associate parents with students. If you do that, the parent would be able to log in to the system and can see all the required details like attendance, report card, grade book of his/her child. After you click on this option you get an option to search where you can select the grade and perform search and you will get the student list then select a student from the list and associate that student to a particular parent. </p>';
            $help['Students/DataFields.php'] = '<p><strong>Data Fields</strong></p><p>The "Data Fields" page allows you to setup your school\'s custom data fields.  These fields are used to store information about a student in the "Other Info" student screen.</p><p>There are four types of Data Fields, text fields, checkbox fields, date fields, and pull-down menu fields. Text fields can store any text value up to 255 characters long.  Checkbox fields can be checked, indicating "Yes" or remain unchecked, indicating "No." Date fields store dates, and pull-down menu fields allow you to select any one of a set of predetermined values.</p><p>To add a data field, fill in the data field\'s title and data type, and select whether or not the field should appear on student search screens in the empty fields at the bottom of the data fields list. If the field is a pull-down menu, enter each of the available options in the "Pull-down Options" field separated by commas. Otherwise, leave this field blank.  Click the "Save" button.</p><p>To modify a data field, click on any of the data field\'s information, change the value, and click the "Save" button.</p><p>To delete a data field, click the delete icon (-) next to the data field you want to delete.  You will be asked to confirm the deletion.</p>';
            $help['Students/EnrollmentCodes.php'] = '<p><strong>Enrollment Codes</strong></p><p>The "Enrollment Codes" page allows you to setup your school\'s enrollment codes.  Enrollment codes are used in the Enrollment student screen, and specify the reason the student was enrolled or dropped from a school.  These codes apply to all schools system-wide.</p><p>To add an enrollment code, fill in the enrollment code\'s title, short name, and type in the empty fields at the bottom of the enrollment codes list. Click the "Save" button.</p><p>To modify an enrollment code, click on any of the enrollment code\'s information, change the value, and click the "Save" button.</p><p>To delete an enrollment code, click the delete icon (-) next to the enrollment code you want to delete.  You will be asked to confirm the deletion.</p>';

            $help['Students/AdvancedReport.php'] = '<p><strong>Advanced Reports</strong></p><p>This option allows you to create a special report as per your requirement. After clicking on this tab you will get a search option. If you think you need to create a report which will show up the details of only Grade- Sophomore. Then you need to select the Grade option as Sophomore now perform the search, you will get the student list for that particular grade. Now if you click on '._createReportForSelectedStudents.', It will give you an option to choose that what details you want in the report card. Here you have General, Address, General Info, Medical and Schedule, now tick the boxes as per your requirement and again click on Create Reports for Selected Students. Your report is ready with all the necessary information you wanted.</p>';
            $help['Students/AddDrop.php'] = '<p><strong>Add/ Drop Reports</strong></p><p>This option allows you to prepare a report which shows a student\'s enrollment and the drop date  in the school. After you click on this option you will get a page at the top of it you will have to select a specific date range then click on Go. You will get the student list with the Students\' name, Student ID, School, Enrollment and Drop Date. Here you get an option of creating an Xcel sheet as well.</p>';
            $help['Students/Letters.php'] = '<p><strong>Print Letters</strong></p><p>The "Print Letters" page allows you to print form letters for any number of students. </p><p>To print the letters, enter the letter text in the "Letter Text" text field at the bottom of the search screen.  Then search for students by filling in any desired search field, and click the "Submit" button.</p><p>You can insert certain pieces of student information into your letter with special variables:<UL><LI><b>Full Name:</b> __FULL_NAME__</LI><LI><b>First Name:</b> __FIRST_NAME__</LI><LI><b>Middle Name:</b> __MIDDLE_NAME__</LI><LI><b>Last Name:</b> __LAST_NAME__</LI><LI><b>Student ID:</b> __STUDENT_ID__</LI><LI><b>Grade:</b> __GRADE_ID__</LI></UL></p><p>Also, you can choose to print the letters with mailing labels.  The letters will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one letter may be printed per student if the student has guardians residing at more than one address.</p><p>The letters will be automatically give you a printer-friendly html format when you click the "Submit" button.</p>';
            $help['Students/MailingLabels.php'] = '<p><strong>Print Mailing Labels</strong></p><p>This tab helps you to create mailing labels for selected students. In this page you have 4 options like To Student, To Primary Emergency Contact, To Secondary Emergency Contact, and To Both Emergency Contacts. After selecting the option if you click on Create labels for selected students you will get the mailing labels for those selected students.</p>';
            $help['Students/StudentLabels.php'] = '<p><strong>Print Students Labels</strong></p><p>This tab helps you to create student labels. If you click on this option you will get the student list and you will also get 2 options to choose attendance teacher, attendance room. The student label will show up that information. You can also take a print out of the details.</p>';
            $help['Students/PrintStudentInfo.php'] = '<p><strong>Print Student Info</strong></p><p>This page allows you to print students\' basic information. If you click on this tab you will get a search option, you need to perform a search and as per your search it will give you the student list. At the top of that page you will have five options (General Info, Addresses and Contacts, Medical, Comments and Goals). Now you can choose any of those options and then select students as per your requirement.  Now if you click on Print Info For Selected Students you will get a print view containing all the selected students with their details. You can also take a print out of that.</p>';
            $help['Students/GoalReport.php'] = '<p><strong>Print Goals and Progresses</strong></p><p>This page allows you to print students\' Goals and Progresses. If you click on this tab you will get a search option, you need to perform a search and as per your search it will give you the student list. . At the top of that page you will have a Date Range to select. Select the Date Range and select the students as per your requirement and now if you click on Print Info for Selected Students you will get a print view containing all the selected students with their Goals and Progresses. You can also take a print out of that.</p>';

            $help['Students/StudentFields.php'] = '<p><strong>Student Fields </strong></p><p>This option allows you to create a new student field and it will be added in the student information page. If you click on it you an option to create a new field, now you need to give a Title and a Sort Order then click on save and you have successfully created a new student field. Now if you want you can create a Field under the new student field category. Here in this page you will have to give the Field Name, the Data Type, Sort Order, and if you check the Required Box it would be a mandatory field to fill up while adding a student into the system. You can also delete this field that you created if you don’t require it anymore. Just select that field you want to delete and click on Delete Tab and it will ask for a confirmation, click on OK and that particular field is deleted.</p>';
            $help['Students/Upload.php'] = '<p><strong>'._uploadStudentSPhoto.'</strong></p><p>This option allows you to '._uploadStudentSPhoto.' in the student info page. First you need to select a student then upload his/ her photo into the system.</p>';
            $help['Students/Upload.php?modfunc=edit'] = '<p><strong>Update Student\'s Photo</strong></p><p>Using this option you would be able to change or update a particular student\'s photo in the student info page.</p>';
            $help['Students']= $help['Students/Student.php'];
}

if(User('PROFILE')=='teacher')
{
            $help['Students/Student.php'] = '<p><strong>Student Information</strong></p><p>This option gives you all the necessary details of a particular student. After clicking on this tab when you click on submit you will get the list of all the students. You can select a specific student and will get the details of that student. </p>';
            $help['Students/Student.php?include=GeneralInfoInc'] = "<p><strong>General Information</strong></p><p> is a display of a student's fundamental information. This includes birth date, social security number, ethnicity, gender, birthplace, and grade.</p>";
            $help['Students']= $help['Students/Student.php'];
}

// USERS
if(User('PROFILE')=='admin')
{
            $help['users/User.php'] = '<p><strong>User Information</strong></p><p>This page displays a user\'s fundamental information. This includes his name, username, password, profile, school, email address, and phone number.  You can change any of this information by clicking on the value you want to change, changing the value, and clicking the "Save" button at the bottom of the page. </p>';
            $help['users/User.php?staff_id=new'] ='<p><strong>Add a User</strong></p><p>This page allows you to add a user to the system. This includes administrators, teachers, and parents. Simply fill in the new user\'s name, username, password, profile, school, email address, and phone number. Click the "Save" button.</p><p><strong>Note:</strong> No two users can have identical usernames.</p>';
            $help['users/AddStudents.php'] = '<p><strong>Associate Students with Parents</strong></p><p>This page allows you to associate students to parents.</p><p>Once a parent\'s account has been set up, their children must be associated to their account with this program.  If you have not already chosen a user earlier in your session, select a user by using the "Find a User" Search screen.  Next, search for a student to add to the user\'s account.  From the search result, you can select any number of students.  You can select all the students in the list by checking the checkbox in the blue column headings above the list. After you have selected each desired student from this list, click the "Add Selected Students" button at the top of the screen.</p><p>At any time after a user has been selected, you can see the students already associated with that user.  These students are listed to the left of the student search screen / search results.  These students can be disassociated from this user by clicking the delete icon (-) next to the student you wish to disassociate from the user.  You will be asked to confirm this action.</p>';
            $help['users/Preferences.php'] = "<p><strong>Preferences</strong></p><p>This page allows you to deny access and/or write privileges to any program for any admin user.</p><p>To assign privileges to an admin user, first select an administrator by searching for one and clicking on his name on the list.  Then, use the checkboxes to define which programs the administrator can use and which programs he can use to modify information.  If a user cannot use a particular program, the program will not be displayed on his menu.  If he can use the program, but can't edit information with the program, the program will display the data, but won't let him change it.  After you have completed the program checkboxes, click the \"Save\" button to save the administrator's permissions.</p>";
            $help['users/TeacherPrograms.php?include=Grades/InputFinalGrades.php'] = '<p><strong>Input Final Grades</strong></p><p>This page allows you to enter quarter, semester, and semester exam grades for all the selected teacher\'s students in the current period. By default, this program will list the students in the selected teacher\'s first period class for the current quarter.  You can alter the period by changing the period pull-down menu at the top of the screen.  Also, you can alter the quarter by changing the marking period pull-down menu on top.  Furthermore, you can select the current semester or semester final by changing the marking period pull-down menu at the top of the screen to the desired marking period.</p><p>Once you are in the correct marking period, you can enter student grades by selecting the earned grade for each student and entering comments as desired.  Once all the grades and comments have been entered, click the "Save" button at the top of the screen.</p><p>If the selected teacher is using the Grades, you can have openSIS calculate each student\'s quarter grades by clicking on the "Use Gradebook Grades" link at the top of the list.  Clicking this link will automatically save each student\'s grades and refresh the list.</p>';
            $help['users/TeacherPrograms.php?include=Grades/Grades.php'] = '<p><strong>GradeBook Grades</strong></p><p>This tab allows the administrator to give the grades on behalf of the teacher. After you click on this tab you will get a list of the teachers. Now you need to select the teacher on behalf of whom administrator wants to give grades. After you select the teacher you can choose period. Then you will get a student list. From that list you need to select the student and you would be able to grade that student on behalf of that particular teacher.</p>';
            $help['users/TeacherPrograms.php?include=Grades/ProgressReports.php'] = '<p><strong>Progress Reports</strong></p><p>This tab allows the administrator to process the progress report on behalf of the teacher. After you click on this tab you will have to click on submit and will get the list of all the teachers. Then you need to select the teacher on behalf of whom administrator wants to prepare the progress report. Again you will get a search window where you can select the grade then click on submit and you get the list of the students of that particular grade. Now if you click on Create Progress Reports for Selected Students you can generate the progress report for those selected students.</p>';
            $help['users/TeacherPrograms.php?include=Attendance/TakeAttendance.php'] = '<p><strong>Take Attendance</strong></p><p>This page allows you to enter period attendance for all the selected teacher\'s students.  By default, this program will list the students in the selected teacher\'s first period class.  You can alter the current period by changing the period pull-down menu at the top of the screen to the desired period.</p><p>Once you are in the correct period, you can enter attendance by selecting the attendance code corresponding to each student.  Once you have entered attendance for all the students, click the "Save" button at the top of the screen.</p>';
            $help['users/TeacherPrograms.php?include=Attendance/Missing_Attendance.php'] = '<p><strong>Missing Attendance</strong></p><p>This tab allows the administrator to take attendance on behalf of the teacher. After clicking on this tab you will get a teacher list, now you will have to select a particular teacher on behalf of whom you want to take attendance. Then enter attendance by selecting the attendance code corresponding to each student. Once you have entered attendance for all the students, click the "Save" button at the top of the screen.</p>';
            $help['users/TeacherPrograms.php?include=Eligibility/EnterEligibility.php'] = '<p><strong>Enter Extracurricular</strong></p><p>This page allows you to enter eligibility grades for all the selected teacher\'s students.  By default, this program will list the students in the selected teacher\'s first period class.  You can alter the current period by changing the period pull-down menu in the left frame to the desired period.</p><p>Once you are in the correct period, you can enter eligibility grades by selecting the eligibility code corresponding to each student.  Once you have entered eligibility for all the students, click the "Save" button at the top of the screen.</p><p>You must enter eligibility each week during the timeframe specified by your school\'s administration.</p>';
            $help['users/Profiles.php'] = "<p><strong>User Profiles</strong></p><p>You can administer the sections of the application a user can access and edit.</p>";
            $help['users/Exceptions.php'] = "<p><strong>User Permissions</strong></p><p>This page allows you to view the access right for a user.</p>";
            $help['users/UserFields.php'] = "<p><strong>User Fields</strong></p><p>This page allows you to create custom fields for demographic information on a user.</p><p>Click on the (+) buton to create a new User Field. You can also choose to assign view rights to user roles for that field.</p>";
            $help['users']=$help['users/User.php'];

}

if(User('PROFILE')=='teacher')
{
            $help['users/User.php'] = "<p><strong>User Information</strong></p><p>This page displays a user's fundamental information. This includes his name, username, password, profile, school, email address, and phone number.  You can change any of this information by clicking on the value you want to change, changing the value, and clicking the \"Save\" button at the bottom of the page. </p>";
            $help['users']=$help['users/User.php'];
}

// SCHEDULING
if(User('PROFILE')=='admin')
{
            $help['Scheduling/Schedule.php'] = '<p><strong>Student Schedule</strong></p><p> This page allows you to modify a student\'s course schedule. <p>You must first select a student by using the "Find a Student" search screen. You can search for students who have requested a specific course or request by clicking on the "Choose" link next to the search options "Course" and "Request" respectively and choosing a course from the popup window that appears.</p><p>To add a course to the student\'s schedule, click on the "Add a Course" link next to the add icon (+) and select a course from the popup window that appears. The screen will automatically refresh to show the course addition.</p><p>To drop an existing course, click on the delete icon (-) next to the course you want to drop from the student\'s schedule.</p><p>To change the course period of a course for the student, click on the "Period - Teacher" of the course you want to change and select the new course period.  You can also change the term in the same fashion.</p><p>All additions, deletions, and modifications to a student\'s schedule are not made permanent until you click the "Save" button at the top of the screen and confirm your modifications.  In addition, you will have to specify the effective date (the date on which your changes should take effect) on the confirmation screen.</p>';
            $help['scheduling/ViewSchedule.php'] = '<p><strong>View Schedule</strong></p><p>This tab allows you to view the entire schedule of a student. After you click on View Schedule, system gives you a search box. Here you will have to perform a search with proper criteria. You will get a list of students as per your search criteria. Eg : if you give 1st grade in grade box you will get the list of all the students in 1st grade. Then you click on any students\' name you will get a chart where you can get to see his/ her schedules. Here you get many filters to narrow down your search. Like : Date, Marking Period(if you select the marking period as Full Year it will give you the list of schedules for the full year. If you select Quarter1 you will only get the schedules of Quarter1), Calendar View.</p><p>In the period List you get the following details like Period Time, Course Name, Period Teacher, Room Number and the Term. At the bottom left corner you will get a Print Schedule option to take a print out of the schedules.</p>';
            $help['scheduling/Requests.php'] = '<p><strong>Student Requests</strong></p><p>The "Student Requests</i>" page allows you to specify which courses a student intends to take in the next school year.  These requests are used by the Scheduler when filling a student\'s schedule.</p><p>You can add a request by selecting the course you want to add from under the corresponding subject heading.  You can add requests from each subject in the same way, or you can add another request in the same subject by clicking on the add icon (+) next to the subject name.  Doing this will cause another set of request pull-down menus to appear under the subject heading.  Once you have added all the desired requests, click the \"Save\" button at the top of the screen.</p><p>When you save the student\'s requests, the Requests program will run the Scheduler without saving the schedule for the current student to notify you of any conflicts.  The Scheduler output will also tell you if any course requested has zero available seats. If a request could not be met, you can change the requests accordingly to ensure complete scheduling. You will also be given the option to schedule the student with the requests you entered.</p><p>Furthermore, when you have saved the student\'s requests, you will have the option to specify a teacher or period and to exclude a teacher or period.  To do this, select the teacher or period from the "With" and "Without" pull-down menus respectively.  You can also delete a request that you entered by changing the course and weight to "Not Specified." Once you have made all the desired modifications, click the "Save" button again.</p>';
            $help['scheduling/MassRequests.php'] = '<p><strong>Group Requests</strong></p><p>This utility allows you to add a request to a group of students in one action.</p><p>First, select a course to be added as a request by clicking the "Choose a Course" link at the top of the screen and choosing the course from the popup screen that appears. You can also perform this action from the next screen.  Next, search for students.  Notice that you can search for students who already have a certain request or are in a certain activity.  This can be useful since you can add a laboratory course request to all students who requested chemistry.  Or you can add a P.E. course request to all students in Boy\'s Basketball.  From the search result, you can select any number of students. To select all the students in the list, check the checkbox in the blue column headings above the list. After you have selected each desired student from this list, click the "Add Course to Selected Students" button at the top of the screen. If you have not yet chosen a course to add as a request, you must do that before you click this button.</p>';
            $help['scheduling/MassSchedule.php'] = '<p><strong>Group Schedule</strong></p><p>This utility allows you to add a schedule to a group of students in one action.</p><p>First, select a course to be added as a request by clicking the "Choose a Course" link at the top of the screen and choosing the course from the popup screen that appears. Select the starting date for the course and the marking period in which you want to schedule the students. Select the students in the grid below and click the "Save" button. The selected schedule will be added to the selected students.</p>';
            $help['scheduling/MassDrops.php'] = '<p><strong>Group Drops</strong></p><p>This utility allows you to add a remove a group of students from a schedule in one action.</p><p>First, select a course to be removed by clicking the "Choose a Course" link at the top of the screen and choosing the course from the popup screen that appears. Select the starting date for the course and the marking period in which you want to remove the students. Select the students in the grid below and click the "Save" button. The selected schedule will be removed from the selected schedule.</p>';
            $help['scheduling/ScheduleReport.php'] = '<p><strong>Student Schedule Report</strong></p><p>This report shows the students who are scheduled into each course, the students who requested the course but weren\'t successfully scheduled into it, and the number of requests, open seats, and total seats in each course.</p><p>To navigate through this report, first click on any one of the subjects.  You will now see each course in that subject as well as the number of requests for that course and open and total seats available for that course.  If you choose a course by clicking on it, you will see a list of the course weights, and the requests, open, and total seats numbers will be broken down by each weight.  Here, you can also see a list of students scheduled in the course or a list of students who requested the course but weren\'t scheduled into it by clicking the "List Students" and "List Unscheduled Students" links respectively.</p><p>If you select a weight by clicking on it, the open / total seats will be broken down even farther by each period.  Here again you can list scheduled and unscheduled students.  Also, you can select a single course period and list the scheduled and unscheduled students.</p><p>At any point after selecting a subject, you can navigate backwards by clicking on the links that appear in the grey bar at the top of the screen.  These links also show you which students you are viewing.</p>';
            $help['scheduling/RequestsReport.php'] = '<p><strong>Student Requests Report</strong></p><p>This report shows the number of students who requested each course and the number of total seats in that course. The courses are grouped by subject.</p><p>This report is useful for creating the master schedule since it helps you determine the number of course periods necessary for each course due to demand for the course.</p>';
            $help['scheduling/PrintSchedules.php'] = '<p><strong>Student Schedules Report</strong></p><p>This report allows you to print schedules for any number of students.</p><p>You can search for students who requested or are enrolled in a specific course by clicking the "Choose" link next to the "Request" and "Course" search options respectively and choosing a course from the popup window that appears.</p><p>Also, you can choose to print the schedules with mailing labels.  The schedules will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one schedule may be printed per student if the student has guardians residing at more than one address.</p><p>The schedules will be automatically downloaded to your computer in the printable PDF format when you click the "Submit" button.</p>';
            $help['scheduling/PrintRequests.php'] = '<p><strong>Student Requests Report</strong></p><p>This report allows you to print requests sheets for any number of students.</p><p>You can search for students who requested a specific course by clicking the "Choose" link next to the "Request" search option and choosing a course from the popup window that appears.</p><p>Also, you can choose to print the requests sheets with mailing labels.  The requests sheets will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one request sheet may be printed per student if the student has guardians residing at more than one address.</p><p>The request sheets will be automatically downloaded to your computer in the printable PDF format when you click the "Submit" button.</p>';
            $help['scheduling/PrintClassLists.php'] = '<p><strong>Student Class List Report</strong></p><p>This report allows you to print requests sheets for any number of students.</p><p>You can search for students who requested a specific course by clicking the "Choose" link next to the "Request" search option and choosing a course from the popup window that appears.</p><p>Also, you can choose to print the requests sheets with mailing labels.  The requests sheets will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one request sheet may be printed per student if the student has guardians residing at more than one address.</p><p>The request sheets will be automatically downloaded to your computer in the printable PDF format when you click the "Submit" button.</p>';
            $help['scheduling/PrintClassPictures.php'] ='<p><strong>Print Class Pictures</strong></p><p>This tab allows you to print the class pictures.</p>';
            $help['scheduling/UnfilledRequests.php'] ='<p><strong>Unfilled Requests </strong></p><p>This option allows you to get a report of the Unfilled Schedule Requests. When a student is requesting for a particular class with or without a particular teacher, if all available seats are full for that specific class or while running Run Scheduler you have not ticked Schedule Unscheduled Request that request will show up in this option. In this way you would be able to know how many such left are still left to schedule.</p>';
            $help['scheduling/IncompleteSchedules.php'] ='<p><strong>Incomplete Schedules</strong></p><p>This option will give you the list of the students with all their scheduling details. After you click on this option you need to perform a search as per your requirement. Then you will get the list of students with their schedule details. Like which are the periods which are already scheduled will show up as a cross sign and which periods are still blank and you can assign period there.</p>';
            $help['scheduling/AddDrop.php'] ='<p><strong>Add/ Drop Request</strong></p><p>This option helps you to create a report of the Enrollment and Drop Date of a student in a particular Course and Course Period. After clicking on this tab you get a page at the top of it you will have to select a particular Date Range, then click on Go. Now you will get a student list. Now you need to select the students you want by ticking in the boxes beside. Now if you click on Create Add/ Drop Report for Selected Students you will get a report with Students’ Name, Student ID, Course, Course Period, Enrollment and Drop Date. </p>';
            $help['scheduling/Courses.php'] = '<p><strong>Setup &raquo; Courses</strong></p><p>This utility allows you to setup your school\'s courses.  There are four tiers of courses: Subjects, Courses, Course Weights, and Course Periods.</p><p>To add any of these four things, click on the Add icon (+) in the column corresponding to what you want to add.  Then, fill in the information requested in the fields above the list of marking periods and click the "Save" button.</p><p>To change any of these four things, click on the item you want to change, and click on whatever value you want to change in the grey area above the lists.  Then, change the value and click the "Save" button.</p><p>Finally, to delete something, select it by clicking on its title on the list and click the "Delete" button at the top of the screen.  You will be asked to confirm the deletion.</p>';
            $help['scheduling/Scheduler.php'] = '<p><strong>Run Scheduler</strong></p><p>This utility schedules every student at your school according to the requests entered for them.</p><p>You first must confirm the Scheduler run.</p><p>Once the scheduler has run, which could take several minutes, it will notify you of any conflicts.  The Scheduler output will also tell you if any course requested has zero available seats. If a request could not be met, you can change the requests accordingly to ensure complete scheduling. Once the schedules have been saved, you will be given the option to view the Schedule Report.</p><p>The "Delete Current Schedule" deletes all the currently assigned schedules.</p>';
            $help['scheduling'] =$help['scheduling/Schedule.php'];

}
elseif(User('PROFILE')=='parent')
{
            $help['scheduling/Schedule.php'] = '<p><strong>Schedule</strong></p><p> is a display of your child\'s course schedule.</p>';
            $help['scheduling/PrintRequests.php'] = '<p><strong>Print Requests</strong></p><p> is a utility that allows you to print requests sheets for your child.</p><p>The request sheets will be automatically downloaded to your computer in the printable PDF format when you click the "Submit" button.</p>';
            $help['scheduling'] =$help['scheduling/Schedule.php'];

}
else
{
            $help['scheduling/Schedule.php'] = "<p><strong>Schedule</strong></p><p> is a display of the student's course schedule. <p>You must first select a student by using the \"Find a Student\" search screen. You can search for students who have requested a specific course or request by clicking on the \"Choose\" link next to the search options \"Course\" and \"Request\" respectively and choosing a course from the popup window that appears.</p>";
            $help['scheduling/PrintSchedules.php'] = "<p><strong>Student Schedules Report</strong></p><p>This report allows you to print schedules for any number of students.</p><p>You can search for students who requested or are enrolled in a specific course by clicking the \"Choose\" link next to the \"Request\" and \"Course\" search options respectively and choosing a course from the popup window that appears.</p><p>Also, you can choose to print the schedules with mailing labels.  The schedules will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one schedule may be printed per student if the student has guardians residing at more than one address.</p><p>The schedules will be automatically downloaded to your computer in the printable PDF format when you click the \"Submit\" button.</p>";
            $help['scheduling/PrintClassLists.php'] = "<p><strong>Student Class List Report</strong></p><p>This report allows you to print requests sheets for any number of students.</p><p>You can search for students who requested a specific course by clicking the \"Choose\" link next to the \"Request\" search option and choosing a course from the popup window that appears.</p><p>Also, you can choose to print the requests sheets with mailing labels.  The requests sheets will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one request sheet may be printed per student if the student has guardians residing at more than one address.</p><p>The request sheets will be automatically downloaded to your computer in the printable PDF format when you click the \"Submit\" button.</p>";
            $help['scheduling'] =$help['scheduling/Schedule.php'];
}

// GRADES
if(User('PROFILE')=='admin')
{
            $help['Grades/ReportCards.php'] = "<p><strong>Report Cards</strong></p><p><i></i>This utility allows you to print report cards for any number of students.</p><p>You can search for students who are enrolled in a specific course by clicking the \"Choose\" link next to the \"Course\" search option and choosing a course from the popup window that appears. You can also limit your search based on weighted/unweighted GPA, class rank, and letter grade by filling in the upper and lower bounds of the GPA and class rank range and checking the desired letter grade checkboxes.  For example, this allows you to search for all students in the top ten of their class, all students who are failing, or all students who have failed at least one course in the marking periods selected.</p><p>Also, you can choose to print the report cards with mailing labels.  The report cards will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one report card may be printed per student if the student has guardians residing at more than one address.</p><p>Before printing the report cards, you must select which marking periods to display on the report card by checking desired marking period checkboxes.</p><p>The report cards will be automatically downloaded to your computer in the printable PDF format when you click the \"Submit\" button.</p>";
            $help['Grades/CalcGPA.php'] = "<p><strong>Calculate GPA</strong></p><p>This utility calculates and saves the GPA and class rank of each student in your school based upon their semester grades.</p><p>You must confirm your intention to calculate GPA. Here, you can also specify what number your weighted scale is based upon and whether to base class rank upon weighted or unweighted GPA.</p><p>The Calculate GPA program calculates the weighted GPA earned per course by multiplying the GPA value of the grade earned by the GPA multiplier of the course weight.  Then, it divides that value by the number you specified as the base for your weighted scale.  For unweighted GPA, the Calculate GPA program simply takes the GPA value of the grade the student earned.  After finding the GPA points earned for each course, the program averages these values to determine the student's to-date GPA.  It then sorts these values to determine the class rank.  If more than one student has the same GPA, they will share a position in class rank.</p>";
            $help['Grades/Transcripts.php'] = "<p><strong>Transcripts</strong></p><p>This utility allows you to print transcripts for any number of students.</p><p>You can search for students who are enrolled in a specific course by clicking the \"Choose\" link next to the \"Course\" search option and choosing a course from the popup window that appears. You can also limit your search based on weighted/unweighted GPA, class rank, and letter grade by filling in the upper and lower bounds of the GPA and class rank range and checking the desired letter grade checkboxes.  For example, this allows you to search for all students in the top ten of their class, all students who are failing, or all students who have failed at least one course in the marking periods selected.</p><p>Before printing the transcripts, you must select which marking periods to display on the transcript by checking desired marking period checkboxes.</p><p>The transcripts will be automatically downloaded to your computer in the printable PDF format when you click the \"Submit\" button.</p>";
            $help['Grades/TeacherCompletion.php'] = "<p><strong>Teacher Completion Report</strong></p><p>This report shows which teachers have not entered grades for any given marking period.</p><p>The red checks indicate that a teacher has failed to enter the current marking period's grades for that period.</p><p>You can select the current quarter, semester, and semester exam from the pull-down menu at the top of the screen.  To change the current quarter, change the marking period pull-down menu on the left frame.  You can also show only one period by choosing that period from the period pull-down menu at the top of the screen.  After choosing a marking period or period, click the \"Go\" button to refresh the list with the new parameters.</p>";
            $help['Grades/GradeBreakdown.php'] = "<p><strong>Grade Breakdown</strong></p><p>This report shows the number of each grade that a teacher gave.</p><p>You can select the current quarter, semester, and semester exam from the pull-down menu at the top of the screen.  To change the current quarter, change the marking period pull-down menu on the left frame.</p>";
            $help['Grades/FinalGrades.php']='<p><strong>Student Final Grades</strong></p><p>This tab allows you to get the grade lists for the students. After you click on this tab you have perform a search by selecting the grade. Then you will get the list of all the students for that particular grade. Now if you click on Create Grade List for Selected Students you will get the grade list.</p>';
            $help['Grades/ReportCards.php?modfunc=gradelist'] = "<p><strong>Student Grades Report</strong></p><p>This report allows you to view the grades earned by any number of students.</p><p>You can search for students who are enrolled in a specific course by clicking the \"Choose\" link next to the \"Course\" search option and choosing a course from the popup window that appears. You can also limit your search based on weighted/unweighted GPA, class rank, and letter grade by filling in the upper and lower bounds of the GPA and class rank range and checking the desired letter grade checkboxes.  For example, this allows you to search for all students in the top ten of their class, all students who are failing, or all students who have failed at least one course in the marking periods selected.</p><p>Before searching, you must select which marking periods to display by checking desired marking period checkboxes.</p>";
            $help['Grades/GPARankList.php'] = "<p><strong>GPA / Class Rank List</strong></p><p>This report that shows the unweighted GPA, weighted GPA, and class rank of each student at your school.</p><p>As with any list in openSIS, you can sort by any value displayed by clicking on the coresponding column heading.  For example, you can sort by grade by clicking on the \"Grade\" column heading.  Similarly, you can sort by unweighted GPA by clicking on the \"Unweighted GPA\" column heading.</p>";
            $help['Grades/HonorRoll.php']='<p><strong>Honor Roll</strong></p><p>This option allows you to give Honor to the students.  Here you can search by the Honor Roll and you will get a list of students under that specific honor. Either you can create certificate and give it to the students or else you can make a list as well using the 2 options available on the page.</p>';
            $help['Grades/ReportCardGrades.php']='<p><strong>Report Card Grades</strong></p><p>This option allows you to set up the report card grades. Unless you are setting it up teachers won\'t be able to give grades to the students. You will have to give the title, break off, GP value, order and the comment and then click on save. After you create this you can grade the students.</p>';
            $help['Grades/ReportCardComments.php']='<p><strong>Report card comments</strong></p><p>This tab allows you to create comments for the Report Card. You can create n-number of comments here for all the courses. At the upper left side there is a dropdown from where you can choose the course you want give comments for. Or else you can give the same comments for all the courses by selecting All Courses. Here you get the option to give different comments for different subjects and whatever you create that will show up in the Report Card. Apart from these openSIS has a default General tab where you will get the default comments.</p><p>Select any tab as per your requirement and write the desired comments, give the sort order and click on Save. To create another comment you will have to click on the + sign at the left hand side and it will give you another box to write the other comments.</p>';
            $help['Grades/HonorRollSetup.php']='<p><strong>Honor Roll set Up</strong></p><p>This option allows you to set up the Honor Roll for the students. You can create the Honor Rolls and give the Break Off and click on save. After you set it up the Honor Rolls will show up under the Honor Roll tab. </p>';
            $help['Grades/FixGPA.php']='<p><strong>Recalculate GPA Numbers</strong></p><p>This option allows you to recalculate the running GPA numbers in case if there are any mistakes. Here you get 3 different options to choose (Full Year, Semester, Quarter1). If you select any one of those options and click on ok the grades for that particular marking period would be recalculated.</p>';      
            $help['Grades/EditReportCardGrades.php']='<p><strong>Edit Report Card Grades</strong></p><p>After you entered the Historical Marking Period in Edit Historical Marking Periods tab now you can edit Report Card Grades in case of a transferred student. If a student is transferred to your school and took admission in 5th grade, till 4th grade she was studying in a different school.  To keep her previous educational data you need to click on this option. Then perform a search as per your requirement. Now you will get a student list. Select a particular student from that list. Now at the top left of the page you will get a dropdown menu. There you need to select Add Another Marking period. Now you will get a page where you need to select New Marking Period from a Dropdown menu. If you have already created that Historical marking Period you will get it in the dropdown list. Select that and type the grade level. Now click on Save. In the next page you can give the Course Name, Percentage, Letter Grade, GP Value, Unweighted GP Value, and the Grade Scale. So that when you prepare the progress report or a certificate system calculates the marks accordingly.</p>';                 
            $help['Grades/EditHistoryMarkingPeriods.php']='<p><strong>Edit Historical Marking Periods</strong></p><p>This page allows you to create Historical Marking Periods. This is useful for maintaining the previous data of a transferred student. Like a student is enrolled in the school in 5th grade. Till 5th grade she was in a different school. So when she is in your school you need to keep her previous educational data. This tab will help you doing that. After you click on this option you will get a screen, where you need to select the Type as either Semester or Quarter. Then type a name of the Marking period which you want to add, give a Grade Post Date and give the School Year. So you are creating a Historical Marking Period for a transferred student so that you can add all the educational information of a particular student. Now click on Save.</p>';                 


            $help['Grades/ReportCardCodes.php'] = '<p><strong>Report Card Codes</strong></p><p>This page allows you to setup your school\'s report card codes.  Report card codes are used in the Input Final Grades program by teachers and in most of the Grades reports. Report card codes include letter grades as well as grade comments that a teacher can choose from when entering grades.</p><p>To add a report card grade, fill in the grade\'s title, GPA value, and sort order in the empty fields at the bottom of the grades list and click the "Save" button.</p><p>To add a comment, enter the new comment\'s title in the empty field at the bottom of the comments list.</p><p>To modify either type of code, click on any of the code\'s information, change the value, and click the "Save" button.</p><p>To delete either type of code, click the delete icon (-) next to the code you want to delete.  You will be asked to confirm the deletion.</p>';
            $help['Grades']=$help['Grades/ReportCards.php'];

}
elseif(User('PROFILE')=='parent')
{
            $help['Grades/ReportCards.php'] = "<p><strong>Report Cards</strong></p><p>This utility allows you to print report cards for your child.</p><p>Before printing the report cards, you must select which marking periods to display on the report card by checking desired marking period checkboxes.</p><p>The report cards will be automatically generated in a printer-friendly html page when you click the \"Submit\" button.</p>";
            $help['Grades/Transcripts.php'] = "<p><strong>Transcripts</strong></p><p>This utility allows you to print transcripts for your child.</p><p>Before printing the transcripts, you must select which marking periods to display on the transcript by checking desired marking period checkboxes.</p><p>The transcripts will be automatically generated in a printer-friendly html page when you click the \"Submit\" button.</p>";
            $help['Grades/ReportCards.php?modfunc=gradelist'] = "<p><strong>Student Grades</strong></p><p>This page allows you to view the grades earned by your child.</p><p>Before searching, you must select which marking periods to display by checking desired marking period checkboxes.</p>";
            $help['Grades/GPARankList.php'] = "<p><strong>GPA / Class Rank List</strong></p><p>This report that shows the unweighted GPA, weighted GPA, and class rank of your child.</p>";
            $help['Grades/InputFinalGrades.php'] = "<p><strong>Input Final Grades</strong></p><p>This page allows you to enter quarter, semester, and semester exam grades for all your students in the current period.  By default, this program will list the students in your first period class for the current quarter.  You can alter the quarter by changing the marking period pull-down menu on the left frame.  Also, you can select the current semester or semester final by changing the marking period pull-down menu at the top of the screen to the desired marking period.</p><p>Once you are in the correct marking period, you can enter student grades by selecting the earned grade for each student and entering comments as desired.  Once all the grades and comments have been entered, click the \"Save\" button at the top of the screen.</p><p>If you are using the Gradebook, you can have openSIS calculate each student's quarter grades by clicking on the \"Use Gradebook Grades\" link at the top of the list.  Clicking this link will automatically save each student's grades and refresh the list.</p>";
            $help['Grades/Configuration.php'] = "<p><strong>Configuration</strong></p><p>This page allows you to configure the gradebook.</p><p>You can configure the gradebook to round scores up, down, or normally.  Normal rounding would round 19.5 to 20 but 19.4 to 19.</p><p>You can also configure the score breakoff points for each letter grade.  For example, if you set the score breakoff points for A+, A, and A- to 99, 91, and 90 respectively, a student with 99% to 100% would have an A+, another student with a 91% to 98% would have an A, and a student with a 90% would have an A-. The score breakoff point for F should probably be 0.</p><p>Finally, you can also configure the final grading percentages of each semester.  These values are used when averaging the quarter and semester exam grades to calculate the semester grade.</p>";
            $help['Grades/Assignments.php'] = '<p><strong>Assignments</strong></p><p>This page allows you to setup your assignments.  There are two tiers involved with assignments: assignment types and assignments.</p><p>You will probably have assignment types called "Homework," "Tests," and perhaps "Quizzes."  Assignment types are set for every period on which you teach any given course.  So, if you teach Algebra on 1st and 3rd period, you will have to add assignment types to only one of these periods.</p><p>To add an assignment type or an assignment, click on the Add icon (+) in the column corresponding to what you want to add.  Then, fill in the information in the fields above the list of assignments / types and click the "Save" button.</p><p>If you check "Apply to all Periods for this Course," the assignment will be added for each period for which you teach a specific course, in the same way assignment types are added.</p><p>To change an assignment or type, click on the assignment or type you want to modify and click on the value you want to change in the grey area above the assignments / types lists.  Then, change the value and click the "Save" button.</p><p>Finally, to delete an item, select it by clicking on its title on the list and click the "Delete" button at the top of the screen.  You will be asked to confirm the deletion.</p>';
            $help['Grades/Grades.php'] = "<p><strong>Grades</strong></p><p>This page allows you to input assignment grades for all your students in the current period. By default, this program will list the students in your first period class.  You can alter the current period by changing the period pull-down menu in the left frame to the desired period.</p><p>Once you have chosen the correct period, you will see the total points and cumulative grade for each student in your class. You can view the grades for an assignment by selecting the assignment from the assignment pull-down menu at the top of the screen. From here, you can input a new grade by entering the points earned into the blank field next to the student's name or you can modify an existing grade by clicking on the points earned and changing the value. After changing the grades, click the \"Save\" button at the top of the screen.</p><p>You can also view and change all the grades for a single student by clicking on the student's name in the list.  Input grades in the same way that you did with the multiple student list.</p>";
            $help['Grades/ProgressReports.php'] = "<p><strong>Progress Reports</strong></p><p>This report that allows you to print progress reports for any number of students.</p><p>You can choose to print the progress reports with mailing labels.  The progress reports will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one progress report may be printed per student if the student has guardians residing at more than one address.</p><p>The progress reports will be automatically downloaded to your computer in the printable PDF format when you click the \"Submit\" button.</p>";
            $help['Grades']=$help['Grades/ReportCards.php'];

}

if(User('PROFILE')=='teacher')
{
            $help['Grades/ReportCards.php'] = "<p><strong>Report Cards</strong></p><p><i></i>This utility allows you to print report cards for any number of students.</p><p>You can search for students who are enrolled in a specific course by clicking the \"Choose\" link next to the \"Course\" search option and choosing a course from the popup window that appears. You can also limit your search based on weighted/unweighted GPA, class rank, and letter grade by filling in the upper and lower bounds of the GPA and class rank range and checking the desired letter grade checkboxes.  For example, this allows you to search for all students in the top ten of their class, all students who are failing, or all students who have failed at least one course in the marking periods selected.</p><p>Also, you can choose to print the report cards with mailing labels.  The report cards will have mailing labels positioned in such a way as to be visible in a windowed envelope when the sheet is folded in thirds.  More than one report card may be printed per student if the student has guardians residing at more than one address.</p><p>Before printing the report cards, you must select which marking periods to display on the report card by checking desired marking period checkboxes.</p><p>The report cards will be automatically downloaded to your computer in the printable PDF format when you click the \"Submit\" button.</p>";
            $help['Grades']=$help['Grades/ReportCards.php'];
}

// ATTENDANCE
if(User('PROFILE')=='admin')
{
            $help['Attendance/Administration.php'] = "<p><strong>Administration</strong></p><p>This page allows you to view and change the student attendance records for any given day.</p><p>To change the student's attendance status for any period, click on the current value and select the short name of the attendance code you would like to assign that student.  After making all the desired modifications, click the \"Update\" button at the top of the screen.  You can also limit the list of students based upon what attendance codes the students have been assigned on the current day.  For instance, by default, all students with any attendance codes with a state value of \"Absent\" are listed.  This is shown by the pull-down menu on the upper right-hand corner of the screen that displays \"Abs.\" This menu can be changed to the short name of any attendance code, and only students who received that code during the current day will be displayed.  This menu can even be changed to \"All\" which will list all students for whom attendance has been taken.  You can add an attendance code by clicking the add icon (+) next to the attendance code pull-down menu.  If you select a second attendance code, the program will list students who received either code during the day.</p><p>You can alter the date displayed by clicking on the date on the upper left-hand side of the screen and changing it to the desired date.</p><p>After making changes to the attendance codes displayed or the current date, click the \"Update\" button to refresh the screen with the new parameters.</p><p>You can also view the attendance code assigned to the student by the teacher as well as view and enter a comment for each period by clicking on the student's name.</p><p>Clicking on \"Current Student\" on the top of the screen will display the day's attendance records for the current student displayed in the left frame.</p>";
            $help['Attendance/AddAbsences.php'] = "<p><strong>Add Absences</strong></p><p>This page allows you to add an absence to a group of students in one action.</p>First, search for students.  Notice that you can search for students who are enrolled in a specific course or are in a certain activity.  This can be useful since you can add an absence record for each period to all of Mrs. Smith's first period students or the football team who will be on an all day field trip.</p><p>From the search result, you can select any number of students. You can select all the students in the list by checking the checkbox in the blue column headings above the list. You can also specify the periods to mark the selected students, the absence code, the absence reason, and the date in the yellow box above the student list.  After you have selected each desired student from this list, all the desired periods, the absence code, absence reason, and absence date, click the \"Save\" button at the top of the screen.</p>";
            $help['Attendance/AttendanceData.php?list_by_day=true']='<p><strong>Attendance Reports</strong></p><p>This option gives you an attendance report from a certain time span. You can select the time span and then click on go and it will give you a attendance report of that time span.</p>';
            $help['Attendance/Percent.php'] = "<p><strong>Average Daily Attendance Report</strong></p><p>This report shows the number of students, days possible, the number of student days present, the number of student days absent, the Average Daily Attendance, the average number of students in attendance per day, and the average number of students absent per day for any date range at your school.  These numbers are broken down by grade.</p><p>You can alter the date range displayed by changing the date pull-down menus at the top of the screen and clicking the \"Go\" button.  You can also limit the numbers by searching by gender or any of the customizable data fields by clicking on the \"Advanced\" link.</p>";
            $help['Attendance/Percent.php?list_by_day=true'] = '<p><Strong>Average Daily Attendance by Day</strong></p><p> is a report that shows the number of students, days possible, the number of student days present, the number of student days absent, and the Average Daily Attendance per day for any date range at your school.  These numbers are broken down by grade.</p><p>You can alter the date range displayed by changing the date pull-down menus at the top of the screen and clicking the "Go" button.  You can also limit the numbers by searching by gender or any of the customizable data fields by clicking on the "Advanced" link.</p>';
            $help['Attendance/DailySummary.php'] = '<p><strong>Daily Summary Report</strong></p><p>This report shows the daily attendance status of any number of students for every date during any timeframe.</p><p>After searching for students, you can alter the date range by changing the date pull-down menus at the top of the screen and clicking the "Go" button.  The list shows each student\'s daily attendance value for each day with color codes.  A red box signifies that the student was absent all day, a yellow box signifies that a student was absent half-day, and a green box signifies that a student was present all day long.</p><p>You can see the attendance records for each period for any student by clicking on a student\'s name from the list.  Here, the absence code is displayed in the color-coded box.</p>';
            $help['Attendance/StudentSummary.php'] = "<p><strong>Student Summary</strong></p><p>This report shows the days for which a student has an absence.</p><p>After selecting a student, you can alter the date range by changing the date pull-down menus at the top of the screen and clicking the \"Go\" button.  The list shows the student's absences for each period of each day that he had an absence.  A red \"x\" indicates the student was absent in the corresponding period.</p>";
            $help['Attendance/TeacherCompletion.php'] = "<p><strong>Teacher Completion</strong></p><p>This report shows which teachers have not entered attendance for any given day.</p><p>The red checks indicate that a teacher has failed to enter the current day's attendance for that period.</p><p>You can select the current date from the pull-down menu at the top of the screen. You can also show only one period by choosing that period from the period pull-down menu at the top of the screen.  After choosing a date or period, click the \"Go\" button to refresh the list with the new parameters.</p>";
            $help['Attendance/FixDailyAttendance.php']='<p><strong>Recalculate Daily Attendance</strong></p><p>This option allows you to recalculate daily attendance. You need to select the date range and then click on ok and you will get the recalculated daily attendance report.</p>';
            $help['Attendance/DuplicateAttendance.php']='<p><strong>Delete Duplicate Attendance</strong></p><p>This option allows you to delete duplicate attendance if given by mistake. </p>';
            $help['Attendance/AttendanceCodes.php'] = '<p><strong>Attendance Codes</strong></p><p>This page allows you to setup your school\'s attendance codes.  Attendance codes are used in the teacher\'s "Take Attendance" program (as well as most of the Attendance reports) and specify whether or not the student was present during the period, and if he wasn\'t, the reason.</p><p>To add an attendance code, fill in the attendance code\'s title, short name, type, and state code. Select whether or not the code should be a teacher\'s default from the empty fields at the bottom of the attendance codes list and click the "Save" button.  Generally, the attendance code called "Present" will be marked as the teacher\'s default.  If the attendance code is marked as being type "Teacher," a teacher will be able to select that attendance code from their "Take Attendance" program. Administrators will be able to assign all codes to a student.</p><p>To modify an attendance code, click on any of the attendance code\'s information, change the value, and click the "Save" button.</p><p>To delete an attendance code, click the delete icon (-) next to the attendance code you want to delete.  You will be asked to confirm the deletion.</p>';
            $help['Attendance']=$help['Attendance/Administration.php'];

}
elseif(User('PROFILE')=='parent')
{
            $help['Attendance/DailySummary.php'] = "<p><strong>Daily Summary</strong></p><p> is a report that shows the daily attendance status of your child during any timeframe.</p><p>You can alter the date range by changing the date pull-down menus at the top of the screen and clicking the \"Go\" button.  The list shows your child's daily attendance value for each period of each day with color codes.  A red box signifies that the student was absent that period, and a green box indicates that the student was either present or tardy that period. The absence code is displayed in the box.</p>";
            $help['Attendance']=$help['Attendance/DailySummary.php'];
}
if(User('PROFILE')=='teacher')
{
            $help['Attendance/TakeAttendance.php'] = "<p><strong>Take Attendance</strong></p><p> allows you to enter period attendance for all your students in the current period.  By default, this program will list the students in your first period class.  You can alter the current period by changing the period pull-down menu in the left frame to the desired period.</p><p>Once you are in the correct period, you can enter attendance by selecting the attendance code corresponding to each student.  Once you have entered attendance for all your students, click the \"Save\" button at the top of the screen.</p>";
            $help['Attendance/DailySummary.php'] = "<p><strong>Daily Summary Report</strong></p><p>This report shows the daily attendance status of any number of students for every date during any timeframe.</p><p>After searching for students, you can alter the date range by changing the date pull-down menus at the top of the screen and clicking the \"Go\" button.  The list shows each student's daily attendance value for each day with color codes.  A red box signifies that the student was absent all day, a yellow box signifies that a student was absent half-day, and a green box signifies that a student was present all day long.</p><p>You can see the attendance records for each period for any student by clicking on a student's name from the list.  Here, the absence code is displayed in the color-coded box.</p>";
            $help['Attendance/StudentSummary.php'] = "<p><strong>Student Summary</strong></p><p>This report shows the days for which a student has an absence.</p><p>After selecting a student, you can alter the date range by changing the date pull-down menus at the top of the screen and clicking the \"Go\" button.  The list shows the student's absences for each period of each day that he had an absence.  A red \"x\" indicates the student was absent in the corresponding period.</p>";
            $help['Attendance']=$help['Attendance/TakeAttendance.php'];
}
// eligibility
if(User('PROFILE')=='admin')
{
            $help['Eligibility/Student.php'] = "<p><strong>Student Screen</strong></p><p>This page displays the student's activities and the current timeframe's eligibility grades. The program also allows you to add and delete activities to the student.<p>You must first select a student by using the \"Find a Student\" search screen. You can search for students who are enrolled in a specific course by clicking on the \"Choose\" link next to the \"Course\" search option and choosing a course from the popup window that appears. You can also search for students in a certain activity and for students who are currently ineligible.</p><p>To add an activity to the student, select the desired activity from the activity pull-down next to the add icon (+) and click the \"Add\" button.</p><p>To drop an activity, click on the delete icon (-) next to the activity you want to drop.</p><p>You can specify the desired eligibility timeframe by choosing the desired timeframe from the pull-down menu at the top of the screen.  These timeframes are setup in the \"Entry Times\" program.</p>";
            $help['Eligibility/AddActivity.php'] = "<p><strong>Add Activity</strong></p><p>This page allows you to add an activity to a group of students in one action.</p><p>First, select an activity to be added from the pull-down menu at the top of the screen. You can also perform this action from the next screen.  Next, search for students.  Notice that you can search for students who are in a certain activity or course.  From the search result, you can select any number of students.  You can select all the students in the list by checking the checkbox in the blue column headings above the list. After you have selected each desired student from this list, click the \"Add Activity to Selected Students\" button at the top of the screen. If you have not yet chosen an activity, you must do that before you click this button.</p>";
            $help['Eligibility/Activities.php'] = '<p><strong>Activities</strong></p><p>This page allows you to setup your school\'s activities.</p><p>To add an activity, fill in the activity\'s title, beginning date, and ending date in the empty fields at the bottom of the activities list and click the "Save" button.</p><p>To modify an activity, click on any of the activity\'s information, change the value, and click the "Save" button.</p><p>To delete an activity, click the delete icon (-) next to the activity you want to delete.  You will be asked to confirm the deletion.</p>';
            $help['Eligibility/EntryTimes.php'] = '<p><strong>Entry Times</strong></p><p>This page allows you to setup the weekly timeframe in which teachers can enter eligibility.  Teachers must enter eligibility every week within this range.  Besides the teacher\'s "Enter Extracurricular" program, this timeframe is used in most eligibility reports</p><p>To change the timeframe, simply change the upper and lower bounds of the timeframe and click the "Save" button.</p>';
            $help['Eligibility/StudentList.php'] = "<p><strong>Student List</strong></p><p>This report shows every course and eligibility grade assigned to any number of students.</p><p>After searching for students, you can specify the eligibility timeframe you want to view.  These timeframes are setup in the \"Entry Times\" program.</p>";
            $help['Eligibility/TeacherCompletion.php'] = "<p><strong>Teacher Completion Report</strong></p><p>This report shows which teachers have not entered eligibility for any given date range.  The date range is set in the \"Entry Times\" program.</p><p>The red checks indicate that a teacher has failed to enter the current date range's eligibility for that period.</p><p>You can select the current date range from the pull-down menu at the top of the screen. You can also show only one period by choosing that period from the period pull-down menu at the top of the screen.  After choosing a date range or period, click the \"Go\" button to refresh the list with the new parameters.</p>";
            $help['Eligibility']=$help['Eligibility/Student.php'];
}
elseif(User('PROFILE')=='parent')
{
            $help['Eligibility/Student.php'] = "<p><strong>Student Screen</strong></p><p> is a display of your child's activities and the current timeframe's eligibility grades.<p>You can specify the eligibility timeframe you want to view by choosing the desired timeframe from the pull-down menu at the top of the screen.  Extracurricular is entered once per week.</p>";
            $help['Eligibility/StudentList.php'] = "<p><strong>Student List</strong></p><p> is a report that shows every course and eligibility grade assigned to your child.</p><p>You can specify the eligibility timeframe you want to view by choosing the timeframe from the pull-down menu at the top of the screen and clicking the \"Go\" button.  Extracurricular is entered once per week.</p>";
            $help['Eligibility']=$help['Eligibility/Student.php'];
}
if(User('PROFILE')=='teacher')
{
            $help['Eligibility/EnterEligibility.php'] = "<p><strong>Enter Extracurricular</strong></p><p> allows you to enter eligibility grades for all your students in the current period.  By default, this program will list the students in your first period class.  You can alter the current period by changing the period pull-down menu in the left frame to the desired period.</p><p>Once you are in the correct period, you can enter eligibility grades by selecting the eligibility code corresponding to each student.  Once you have entered eligibility for all your students, click the \"Save\" button at the top of the screen.</p><p>If you are using the Gradebook, you can have openSIS calculate each student's eligibility grades by clicking on the \"Use Gradebook Grades\" link at the top of the list.  Clicking this link will automatically save each student's eligibility grades and refresh the list.</p><p>You must enter eligibility each week during the timeframe specified by your school's administration.</p>";
            $help['Eligibility']=$help['Eligibility/EnterEligibility.php'];
}
if(User('PROFILE')=='admin')
{
            $help['tools/LogDetails.php']='<p><strong>Access Logs</strong></p><p>This option gives you the entire log in details. It shows up any failed log in details or correct log in attempts as well. You will have to select a date range and you get to know who has tried to log in and whether he has given any incorrect log in details or not.</p>';
            $help['tools/DeleteLog.php']='<p><strong>Delete Log</strong></p><p>This tab helps you to delete the access logs. You can select the date range and can delete if you want to.</p>';
            $help['tools/Rollover.php']= "<p><strong>Roll Over</strong></p><p>This tab allows you to roll over the entire database of a school to the next school year. It will ask whether you are sure about rolling over or not if you select yes it will be rolled over automatically. And you need to log in to the system again.</p>";
            $help['tools/Backup.php']='<p><strong>Back Up Database</strong></p><p>This backup utility will create a backup of the database along with the database structure. You will be able to use this backup file to restore the database. However, in order to restore, you will need to have access to MySQL administration application like phpMyAdmin and the root user id and password to MySQL.</p>';
            $help['tools']=$help['tools/LogDetails.php'];
}



if(strpos($_SERVER['PHP_SELF'],'Help.php'))
{
	switch(User('PROFILE'))
	{
		case 'admin':
			$title = 'Administrator';
		break;

		case 'teacher':
			$title = 'Teacher';
		break;

		case 'parent':
			if($student==true)
				$title = 'Student';
			else
				$title = 'Parent';
		break;
	}

	$handle = PDFStart();
	Warehouse('header');
	echo '<TABLE><TR><TD><IMG SRC=assets/logo.gif></TD><TD><h1>'.$title.' Handbook<BR><small>Version 1.5</small></h1></TD></TR></TABLE><div class=break></div><!-- NEW PAGE -->';

	foreach($help as $program=>$value)
	{
		if(strpos($program,'/'))
		{
			$modcat = str_replace('_',' ',substr($program,0,strpos($program,'/')));
			if($modcat!=$old_modcat)
				echo '<!-- NEW PAGE --><TABLE border=0><TR><TD><IMG SRC=assets/icons/'.str_replace(' ','_',$modcat).'.gif></TD><TD><h1><font color=#333366>'.$modcat.'</font></h1></TD></TR></TABLE><div class=break></div>';
			$old_modcat = $modcat;
		}
		echo '<h2><font color=#333366>';
		$_REQUEST['modname'] = $program;
		if($program=='default')
			echo 'openSIS School Information System '.$title.' Handbook<BR><small>Version 1.5</small>';
		else
			echo ProgramTitle();
		echo '</font></h2>';
		echo '<TABLE border=0  bgcolor=#DDDDDD width=100%><TR><TD>';
		if($student==true)
			$value = str_replace('your child','yourself',str_replace('your child\'s','your',$value));
		echo $value;
		echo '</TD></TR></TABLE><BR>';
	}
	Warehouse('footer_plain');
	PDFStop($handle);
}
?>